package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActPlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActPlanDetailRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActPlanRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemWorkTypeDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmActPlanDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmActPlanRepo repo;
    private final CrmActPlanDetailRepo repoDetail;
    private final QCrmActPlanDO qdo = QCrmActPlanDO.crmActPlanDO;
    private final QCrmActPlanDetailDO qdoDetail = QCrmActPlanDetailDO.crmActPlanDetailDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdSystemWorkTypeDO qdoWorkType = QPrdSystemWorkTypeDO.prdSystemWorkTypeDO;
    private final QCrmActActivityDO qdoActivity = QCrmActActivityDO.crmActActivityDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmActPlanDO save(CrmActPlanDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmActPlanDetailDO saveDetail(CrmActPlanDetailDO ado) {
        return repoDetail.save(ado);
    }


    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CrmActPlanPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getPlanName() != null) {
            update.set(qdo.planName, payload.getPlanName());
        }
        if (payload.getOrgId() != null) {
            update.set(qdo.orgId, payload.getOrgId());
        }
        if (payload.getPlanYear() != null) {
            update.set(qdo.planYear, payload.getPlanYear());
        }
        if (payload.getPlanYear() != null) {
            update.set(qdo.planYear, payload.getPlanYear());
        }
        if (payload.getBudgetMoney() != null) {
            update.set(qdo.budgetMoney, payload.getBudgetMoney());
        }
        if (payload.getLeadNum() != null) {
            update.set(qdo.leadNum, payload.getLeadNum());
        }
        if (payload.getPipeline() != null) {
            update.set(qdo.pipeline, payload.getPipeline());
        }
        if (payload.getPlanStatus() != null) {
            update.set(qdo.planStatus, payload.getPlanStatus());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null){
            update.set(qdo.deleteFlag,payload.getDeleteFlag());
        }



        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateDetailByKeyDynamic(CrmActPlanDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoDetail)
                .where(qdoDetail.id.eq(payload.getId()));
        if (payload.getDetailType() != null) {
            update.set(qdoDetail.detailType, payload.getDetailType());
        }
        if (payload.getDetailName() != null) {
            update.set(qdoDetail.detailName, payload.getDetailName());
        }
        if (payload.getPersonMoney() != null) {
            update.set(qdoDetail.personMoney, payload.getPersonMoney());
        }
        if (payload.getPersonSource() != null) {
            update.set(qdoDetail.personSource, payload.getPersonSource());
        }
        if (payload.getClaimMoney() != null) {
            update.set(qdoDetail.claimMoney, payload.getClaimMoney());
        }
        if (payload.getPurchaseMoney() != null) {
            update.set(qdoDetail.purchaseMoney, payload.getPurchaseMoney());
        }
        if (payload.getSundryMoney() != null) {
            update.set(qdoDetail.sundryMoney, payload.getSundryMoney());
        }
        if (payload.getTotalMoney() != null) {
            update.set(qdoDetail.totalMoney, payload.getTotalMoney());
        }
        if (payload.getLeadNum() != null) {
            update.set(qdoDetail.leadNum, payload.getLeadNum());
        }
        if (payload.getPipeline() != null) {
            update.set(qdoDetail.pipeline, payload.getPipeline());
        }
        if (payload.getExtDecimal1() != null) {
            update.set(qdoDetail.extDecimal1, payload.getExtDecimal1());
        }
        if (payload.getExtDecimal2() != null) {
            update.set(qdoDetail.extDecimal2, payload.getExtDecimal2());
        }
        if (payload.getExtString1() != null) {
            update.set(qdoDetail.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdoDetail.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdoDetail.extString3, payload.getExtString3());
        }
        if (payload.getExtString3() != null) {
            update.set(qdoDetail.extString3, payload.getExtString3());
        }
        if (payload.getRemark() != null) {
            update.set(qdoDetail.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
//            if (nullFields.contains("leadsId")) {
//                update.setNull(qdo.leadsId);
//            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.eq(key));
        return update.execute();
    }

    /**
     * 修改流程状态
     *
     * @param key 主键
     * @return
     */
    public long updateStatus(Long key, String planStatus, String procInstId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.planStatus, planStatus);
        if (!procInstId.equals("")) {
            update.set(qdo.procInstId, procInstId);
        }
        update.where(qdo.id.eq(key));
        return update.execute();
    }

    /**
     * 逻辑删除所有
     *
     * @param planId 市场计划id
     * @return 删除的行数
     */
    public long deleteDetailSoft(Long planId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoDetail)
                .set(qdoDetail.deleteFlag, 1)
                .where(qdoDetail.planId.eq(planId));
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param planId 市場计划id
     * @param key    市場计划详情主键id
     * @return 删除的行数
     */
    public long deleteDetailSoft(Long planId, Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdoDetail)
                .set(qdoDetail.deleteFlag, 1)
                .where(qdoDetail.planId.eq(planId))
                .where(qdoDetail.id.eq(key));
        return update.execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActPlanVO> getJpaQuerySelect() {
        JPAQuery<CrmActPlanVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActPlanVO.class,
                qdo.id,
                qdo.planNo,
                qdo.planName,
                qdo.orgId,
                qdoOrg.orgName,
                qdo.planYear,
                qdo.procInstId,
                qdo.budgetMoney,
                qdo.leadNum,
                qdo.pipeline,
                qdo.planStatus,
                qdoEmployee.employeeName.as("createUserName"),
                qdo.createUserId,
                qdo.operateReason,
                qdo.creator,
                qdo.createTime,
                qdo.procInstId,
                qdo.procInstStatus,
                qdo.submitTime,
                qdo.approvedTime
        )).from(qdo).leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdo.orgId.longValue())).leftJoin(qdoEmployee).on(qdoEmployee.userId.longValue().eq(qdo.createUserId.longValue()));
        ;
        return jpaQuery;
    }

    /**
     * @param year  预算年度
     * @param orgId 组织id
     * @return
     * @Description
     **/
    public CrmActPlanDO queryByYearOrOrgId(String year, Long orgId) {
        JPAQuery<CrmActPlanDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.planYear.eq(year));
        jpaQuery.where(qdo.orgId.eq(orgId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param year 预算年度
     * @return
     * @Description 根据年度获取本年所有活动计划
     **/
    public List<CrmActPlanVO> queryList(String year, String status) {
        JPAQuery<CrmActPlanVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.planYear.eq(year)).where(qdo.planStatus.eq(status));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmActPlanVO queryBykey(Long key) {
        JPAQuery<CrmActPlanVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 修改计划status
     *
     * @param key
     * @param status
     * @param reson
     * @return
     */
    public long updatePlanStatus(Long key, String status, String reson) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.planStatus, status)
                .set(qdo.operateReason, reson)
                .where(qdo.id.eq(key));


        return update.execute();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActPlanVO> getJpaQueryWhere(CrmActPlanQuery query, Long userId, List<Long> orgManageIds) {
        JPAQuery<CrmActPlanVO> jpaQuery = getJpaQuerySelect();
        if(!ObjectUtils.isEmpty(query.getPlanIds())){
            jpaQuery.where(qdo.id.in(query.getPlanIds()));
        }
        if (userId != null) {
            jpaQuery.where(qdo.createUserId.eq(userId).or(qdo.orgId.in(orgManageIds)));
        }
        if (!ObjectUtils.isEmpty(query.getPlanName())) {
            jpaQuery.where(qdo.planName.like(SqlUtil.toSqlLikeString(query.getPlanName())));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdo.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getPlanYear())) {
            jpaQuery.where(qdo.planYear.eq(query.getPlanYear()));
        }
        if (!ObjectUtils.isEmpty(query.getPlanStatus())) {
            jpaQuery.where(qdo.planStatus.eq(query.getPlanStatus()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmActPlanVO> queryPaging(CrmActPlanQuery query, Long userId, List<Long> orgManageIds) {
        JPAQuery<CrmActPlanVO> jpaQuery = getJpaQueryWhere(query, userId, orgManageIds);
        QueryResults<CrmActPlanVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<CrmActPlanVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemWorkTypeVO> getJpaQuerySelectWorkType() {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdSystemWorkTypeVO.class,
                qdoWorkType.id,
                qdoWorkType.sysType,
                qdoWorkType.sysWork,
                qdoWorkType.sysLevel,
                qdoWorkType.unitPrice
        )).from(qdoWorkType);
        return jpaQuery;
    }

    /**
     * @param
     * @return
     * @Description 获取所有工种类型
     **/
    public List<PrdSystemWorkTypeVO> queryWorkTypes() {
        JPAQuery<PrdSystemWorkTypeVO> jpaQuery = getJpaQuerySelectWorkType();
        jpaQuery.where(qdoWorkType.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmActPlanDetailVO> getJpaQuerySelectDetail() {
        JPAQuery<CrmActPlanDetailVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmActPlanDetailVO.class,
                qdoDetail.id,
                qdoDetail.planId,
                qdoDetail.detailSeason,
                qdoDetail.detailType,
                qdoDetail.detailName,
                qdoDetail.personMoney,
                qdoDetail.personSource,
                qdoDetail.claimMoney,
                qdoDetail.purchaseMoney,
                qdoDetail.sundryMoney,
                qdoDetail.totalMoney,
                qdoDetail.expenditure,
                qdoDetail.leadNum,
                qdoDetail.pipeline,
                qdoDetail.extString1,
                qdoDetail.extString2,
                qdoDetail.extString3,
                qdoDetail.extDecimal1,
                qdoDetail.extDecimal2,
                qdoDetail.remark

        )).from(qdoDetail);
        return jpaQuery;
    }

    /**
     * @param planId       计划id
     * @param detailSeason 季节
     * @param detailType   活动类型
     * @return
     * @Description 查询计划明细
     **/
    public CrmActPlanDetailDO queryDetail(Long planId, String detailSeason, String detailType) {
        JPAQuery<CrmActPlanDetailDO> jpaQuery = jpaQueryFactory.select(qdoDetail).from(qdoDetail);
        jpaQuery.where(qdoDetail.planId.eq(planId)).where(qdoDetail.detailSeason.eq(detailSeason)).where(qdoDetail.detailType.eq(detailType));
        jpaQuery.where(qdoDetail.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    public CrmActPlanDetailDO queryDetailById(Long id) {
        JPAQuery<CrmActPlanDetailDO> jpaQuery = jpaQueryFactory.select(qdoDetail).from(qdoDetail);
        jpaQuery.where(qdoDetail.id.eq(id));
        jpaQuery.where(qdoDetail.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    /**
     * @param planId
     * @return
     * @Description 根据planid查询所有明细
     **/
    public List<CrmActPlanDetailVO> queryDetailsByPlanId(Long planId, String... detailSeason) {
        JPAQuery<CrmActPlanDetailVO> jpaQuery = getJpaQuerySelectDetail();
        jpaQuery.where(qdoDetail.planId.eq(planId));
        if (detailSeason != null && detailSeason.length > 0 && !detailSeason[0].equals("")) {
            jpaQuery.where(qdoDetail.detailSeason.eq(detailSeason[0]));
        }
        jpaQuery.where(qdoDetail.deleteFlag.eq(0));
        // 动态排序
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("detailSeason"));
        orderse.add(OrderItem.asc("createTime"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoDetail, orderse));
        return jpaQuery.fetch();
    }

    /**
     * @param detailId 预算明细id
     * @return
     * @Description 查询所有活动总金额
     **/
    public List<CrmActActivityDO> queryActivityByDetailId(Long detailId) {
        JPAQuery<CrmActActivityDO> jpaQuery = jpaQueryFactory.select(qdoActivity).from(qdoActivity);
        jpaQuery.where(qdoActivity.detailId.eq(detailId));
        jpaQuery.where(qdoActivity.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

}
