package com.elitesland.tw.tw5.server.prd.humanresources.ability.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdLevelConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;


import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdLevelConfigService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护表
 */

@RestController
@RequestMapping("/api/prdLevelConfig")
@RequiredArgsConstructor
@Api(value = "级别维护表", tags = {"级别维护表"})
public class PrdLevelConfigController{

    private final PrdLevelConfigService prdLevelConfigService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-级别维护表")
    public TwOutputUtil<PrdLevelConfigVO> get(@PathVariable Long id) {

        PrdLevelConfigVO res = prdLevelConfigService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-级别维护表")
    public TwOutputUtil<Long> save(@RequestBody PrdLevelConfigPayload prdLevelConfigPayload) {

        PrdLevelConfigVO res = prdLevelConfigService.save(prdLevelConfigPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-级别维护表")
    public TwOutputUtil<Long> update(@RequestBody PrdLevelConfigPayload prdLevelConfigPayload) {

        PrdLevelConfigVO res = prdLevelConfigService.update(prdLevelConfigPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-级别维护表")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdLevelConfigService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-级别维护表")
    public TwOutputUtil<PagingVO<PrdLevelConfigVO>> page(PrdLevelConfigQuery prdLevelConfigQuery) {

        PagingVO<PrdLevelConfigVO> res = prdLevelConfigService.page(prdLevelConfigQuery);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("/getList")
    @UdcNameClass
    @ApiOperation("列表查询-级别维护表")
    public TwOutputUtil<List<PrdLevelConfigVO>> getList(PrdLevelConfigQuery prdLevelConfigQuery) {

        List<PrdLevelConfigVO> res = prdLevelConfigService.getList(prdLevelConfigQuery);
        return TwOutputUtil.ok(res);

    }

}

