package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdAbilityLevelPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityStructPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityStructQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityStructService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityStructVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdCompositeAbilityDao;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdCompositeAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdCompositeAbilityRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdCompositeAbilityConvert;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdCompositeAbilityServiceImpl implements PrdCompositeAbilityService {


    private final PrdCompositeAbilityDao prdCompositeAbilityDao;

    private final PrdCompositeAbilityRepo prdCompositeAbilityRepo;

    private final PrdAbilityLevelService prdAbilityLevelService;

    private final PrdCompositeAbilityStructService prdCompositeAbilityStructService;

    private final CacheUtil cacheUtil;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdCompositeAbilityVO save(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {

        checkData(prdCompositeAbilityPayload);
        if (null == prdCompositeAbilityPayload.getId()) {
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setJobType1(prdCompositeAbilityPayload.getJobType1());
            prdCompositeAbilityQuery.setJobType2(prdCompositeAbilityPayload.getJobType2());
            // 每个工种只能有一条复合能力
            Long jobTypeCount = prdCompositeAbilityDao.count(prdCompositeAbilityQuery);
            if (jobTypeCount > 0) {
                throw new BusinessException("该工种下已经存在复合能力");
            }
            // 校验编码不能重复
            PrdCompositeAbilityQuery prdCompositeAbilityQuery1 = new PrdCompositeAbilityQuery();
            if (StringUtils.isNotBlank(prdCompositeAbilityQuery.getDocNo())) {
                prdCompositeAbilityQuery1.setDocNo(prdCompositeAbilityPayload.getDocNo());
                Long count = prdCompositeAbilityDao.count(prdCompositeAbilityQuery1);
                if (count > 0) {
                    throw new BusinessException("编码重复，请检查");
                }
            }
        }
        // 级别明细不能重复
        if (CollUtil.isNotEmpty(prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList())) {
            List<Long> levelList = prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList().stream().map(x -> x.getLevelDtlId()).collect(Collectors.toList());
            Set<Long> levelSet = new HashSet<>(levelList);
            if (levelList.size() != levelSet.size()) {
                throw new BusinessException("级别定义明细不能重复");
            }
        }

        PrdCompositeAbilityDO prdCompositeAbilityDO = new PrdCompositeAbilityDO();
        prdCompositeAbilityDO = PrdCompositeAbilityConvert.INSTANCE.p2d(prdCompositeAbilityPayload);

        String jobType1Desc = cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityPayload.getJobType1());
        String jobType2Desc = cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityPayload.getJobType2());
        // 名称保存
        prdCompositeAbilityDO.setName(jobType1Desc + "-" + jobType2Desc);
        PrdCompositeAbilityDO res = prdCompositeAbilityRepo.save(prdCompositeAbilityDO);
        // 级别定义明细
        if (CollUtil.isNotEmpty(prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList())) {
            for (PrdAbilityLevelPayload prdAbilityLevelPayload : prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList()) {
                prdAbilityLevelPayload.setAbilityId(res.getId());
                prdAbilityLevelPayload.setType(2);
                PrdAbilityLevelVO prdAbilityLevelVO = prdAbilityLevelService.save(prdAbilityLevelPayload);
            }

        }
        // 能力构成
        if (CollUtil.isNotEmpty(prdCompositeAbilityPayload.getPrdCompositeAbilityStructPayloadList())) {
            for (PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload : prdCompositeAbilityPayload.getPrdCompositeAbilityStructPayloadList()) {
                // 级别明细校验
                prdCompositeAbilityStructPayload.setAbilityId(res.getId());
                prdCompositeAbilityStructService.save(prdCompositeAbilityStructPayload);
            }
        }
        return PrdCompositeAbilityConvert.INSTANCE.d2v(res);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdCompositeAbilityVO update(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {

        Assert.notNull(prdCompositeAbilityPayload.getId(), "id is null");
        // 级别定义明细
        prdAbilityLevelService.delByAbilitId(prdCompositeAbilityPayload.getId());
        prdCompositeAbilityStructService.delByAbilitId(prdCompositeAbilityPayload.getId());
        PrdCompositeAbilityVO res = save(prdCompositeAbilityPayload);
        return res;

    }


    @Override
    public PrdCompositeAbilityVO get(Long id) {

        Assert.notNull(id, "id不能为空");
        PrdCompositeAbilityVO res = prdCompositeAbilityDao.get(id);
        if (null == res) {
            return null;
        }
        res.setLevelFlag(null != res.getLevelId());
        // 查询级别定义明细
        PrdAbilityLevelQuery prdAbilityLevelQuery = new PrdAbilityLevelQuery();
        prdAbilityLevelQuery.setType(2);
        prdAbilityLevelQuery.setAbilityId(id);

        List<PrdAbilityLevelVO> levelDtl = prdAbilityLevelService.getList(prdAbilityLevelQuery);
        res.setPrdAbilityLevelVOList(levelDtl);
        // 能力构成
        PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery = new PrdCompositeAbilityStructQuery();
        prdCompositeAbilityStructQuery.setAbilityId(id);
        List<PrdCompositeAbilityStructVO> structVOList = prdCompositeAbilityStructService.getList(prdCompositeAbilityStructQuery);
        res.setPrdCompositeAbilityStructVOList(structVOList);
        return res;

    }


    @Override
    public PagingVO<PrdCompositeAbilityVO> page(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        PagingVO<PrdCompositeAbilityVO> res = prdCompositeAbilityDao.page(prdCompositeAbilityQuery);
        res.getRecords().forEach(x -> {

            x.setJobType1Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));

            StringBuilder stringBuilder = new StringBuilder(x.getJobType1Desc());
            stringBuilder.append("-");
            stringBuilder.append(x.getJobType2Desc());
            x.setJobName(stringBuilder.toString());
        });
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdCompositeAbilityDao.del(ids);
        return res;

    }

    @Override
    public List<PrdCompositeAbilityVO> getList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        List<PrdCompositeAbilityVO> res = prdCompositeAbilityDao.getList(prdCompositeAbilityQuery);
        res.forEach(x -> {

            x.setJobType1Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));

            StringBuilder stringBuilder = new StringBuilder(x.getJobType1Desc());
            stringBuilder.append("-");
            stringBuilder.append(x.getJobType2Desc());
            x.setJobName(stringBuilder.toString());
        });
        return res;

    }

    @Override
    @Transactional
    public Long updateState(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {
        Assert.notNull(prdCompositeAbilityPayload.getId(), "id不能为空");
        Assert.notNull(prdCompositeAbilityPayload.getState(), "state不能为空");
        Long res = prdCompositeAbilityDao.updateState(prdCompositeAbilityPayload);
        return res;
    }


    @Override
    public PagingVO<PrdCompositeAbilityVO> levelPage(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {
        prdCompositeAbilityQuery.setState(1);
        PagingVO<PrdCompositeAbilityVO> res = prdCompositeAbilityDao.levelPage(prdCompositeAbilityQuery);
        res.getRecords().forEach(x -> {
            x.setJobType1Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));
        });
        return res;
    }

    /**
     * 数据校验
     *
     * @param prdCompositeAbilityPayload
     */
    private void checkData(PrdCompositeAbilityPayload prdCompositeAbilityPayload) {

//        if (StringUtils.isBlank(prdCompositeAbilityPayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }

        List<String> resTemList = prdCompositeAbilityPayload.getPrdCompositeAbilityStructPayloadList().stream().map(x -> x.getLevelDtlId()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<String> resList = new ArrayList<>(resTemList);

        resTemList.forEach(x -> {
            if (x.contains(",")) {
                List<String> list = Stream.of(x.split(",")).collect(Collectors.toList());
                resList.addAll(list);

            }

        });
        // 能力构成
        if (CollUtil.isNotEmpty(prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList())) {
            prdCompositeAbilityPayload.getPrdAbilityLevelPayloadList().forEach(x -> {
                if (!resList.contains(x.getLevelDtlId().toString())) {
                    throw new BusinessException("各级别至少需要一个能力构成");
                }
            });
        }

    }

    @Override
    public List<PrdCompositeAbilityVO> levelList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {
        prdCompositeAbilityQuery.setState(1);
        List<PrdCompositeAbilityVO> res = prdCompositeAbilityDao.levelList(prdCompositeAbilityQuery);
        res.forEach(x -> {
            x.setJobType1Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType1()));
            x.setJobType2Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", x.getJobType2()));
        });
        return res;
    }

    @Override
    public PrdCompositeAbilityVO findByAbilityLevelId(Long abilityLevelId) {
        PrdCompositeAbilityVO prdCompositeAbilityVO = prdCompositeAbilityDao.findByAbilityLevelId(abilityLevelId);
        prdCompositeAbilityVO.setJobType1Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityVO.getJobType1()));
        prdCompositeAbilityVO.setJobType2Desc(cacheUtil.transferSystemSelection("org:employee:multiCapacity", prdCompositeAbilityVO.getJobType2()));
        return prdCompositeAbilityVO;
    }

    @Override
    @Transactional
    public Boolean changeName(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        List<PrdCompositeAbilityVO> list = getList(new PrdCompositeAbilityQuery());
        for (PrdCompositeAbilityVO prdCompositeAbilityVO : list) {
            prdCompositeAbilityVO.setName(prdCompositeAbilityVO.getJobName());
            prdCompositeAbilityDao.updateByName(prdCompositeAbilityVO);

        }

        return null;
    }

}

