package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonAccountDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonAccountDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonAccountRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PersonAccountDAO {

    private final PersonAccountRepo personAccountRepo;
    private final JPAQueryFactory jpaQueryFactory;

    private final QPersonAccountDO personAccountDO = QPersonAccountDO.personAccountDO;

    public List<PersonAccountDO> findAllByPersonId(Long personId) {
        return personAccountRepo.findAllByPersonId(personId);
    }

    public void deleteAllByPersonId(Long personId) {
        jpaQueryFactory.update(personAccountDO)
                .set(personAccountDO.deleteFlag, 1)
                .where(personAccountDO.personId.eq(personId))
                .execute();
    }

    public void saveAll(List<PersonAccountDO> personAccountDOList) {
        personAccountRepo.saveAll(personAccountDOList);
    }

}
