package com.elitesland.tw.tw5.server.prd.humanresources.resource.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeIndividAbilityQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeIndividAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeIndividAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeIndividAbilityVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-单项能力
 */

@RestController
@RequestMapping("/api/prdEmployeIndividAbility")
@RequiredArgsConstructor
@Api(value = "员工-单项能力", tags = {"员工-单项能力"})
public class PrdEmployeIndividAbilityController {

    private final PrdEmployeIndividAbilityService prdEmployeIndividAbilityService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-员工-单项能力")
    public TwOutputUtil<PrdEmployeIndividAbilityVO> get(@PathVariable Long id) {

        PrdEmployeIndividAbilityVO res = prdEmployeIndividAbilityService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-员工-单项能力")
    public TwOutputUtil<Long> save(@RequestBody PrdEmployeIndividAbilityPayload prdEmployeIndividAbilityPayload) {

        PrdEmployeIndividAbilityVO res = prdEmployeIndividAbilityService.save(prdEmployeIndividAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("batchSave")
    @ApiOperation("批量新增-员工-单项能力")
    public TwOutputUtil<Boolean> batchSave(@RequestBody List<PrdEmployeIndividAbilityPayload> prdEmployeIndividAbilityPayload) {

        Boolean res = prdEmployeIndividAbilityService.batchSave(prdEmployeIndividAbilityPayload);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("update")
    @ApiOperation("修改-员工-单项能力")
    public TwOutputUtil<Long> update(@RequestBody PrdEmployeIndividAbilityPayload prdEmployeIndividAbilityPayload) {

        PrdEmployeIndividAbilityVO res = prdEmployeIndividAbilityService.update(prdEmployeIndividAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-员工-单项能力")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdEmployeIndividAbilityService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-员工-单项能力")
    public TwOutputUtil<PagingVO<PrdEmployeIndividAbilityVO>> page(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        PagingVO<PrdEmployeIndividAbilityVO> res = prdEmployeIndividAbilityService.page(prdEmployeIndividAbilityQuery);
        return TwOutputUtil.ok(res);

    }


}

