package com.elitesland.tw.tw5.server.prd.my.constant;

import lombok.Getter;

/**
 * 工时状态
 *
 * @author Jeff.ni
 * @since 18/11/19
 */
public enum TimesheetStatus {

    CREATE("CREATE", "新建"),
    BEFOREAPPROVE("BEFOREAPPROVE", "未审批"),//还未审批到当前节点
    APPROVING("APPROVING", "审批中"),
    AFTERAPPROVE("AFTERAPPROVE", "已审批"),//当前节点已经审批完成
    APPROVED("APPROVED", "已审批"),//最后一个节点的已审批，区别其它节点
    REJECTED("REJECTED", "已退回"),
    SETTLED("SETTLED", "已结算"),


    APPROVED_TO_CREATE("APPROVED_TO_CREATE", "已审批通过工时，被撤回情况（管理员特殊操作，不能直接改数据库了 ）");

    /**
     * 状态
     */
    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    TimesheetStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
