package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

@Entity
@Table(name = "reward_leave_apply_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "reward_leave_apply_detail", comment = "奖励假申请详情表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class RewardLeaveApplyDetailDO extends BaseModel {

    @Comment("申请单id")
    @Column
    private Long applyId;

    @Comment("资源userId")
    @Column
    private Long userId;

    @Comment("职级")
    @Column
    private String jobGrade;

    @Comment("管理职级")
    @Column
    private String jobGrade2;

    @Comment("资源组织Id")
    @Column
    private Long orgId;

    @Comment("工作日期")
    @Column
    private LocalDate workDate;

    /**
     * 11上午、22下午、33全天
     */
    @Comment("工作类型")
    @Column
    private String workType;

    @Comment("奖励假天数")
    @Column
    private BigDecimal days;

    @Comment("理论当量")
    @Column
    private BigDecimal eqva;

    @Comment("已申请天数")
    @Column
    private BigDecimal appliedDays;

    public void copy(RewardLeaveApplyDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
