package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.ProjectDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
* 工时用-项目表
*
* @author duwh
* @date 2022-12-09
*/
public interface ProjectRepo extends JpaRepository<ProjectDO, Long>, JpaSpecificationExecutor<ProjectDO> {

    List<ProjectDO> queryByProjIdV4In(List<Long> v4ProjectIds);

    @Query("select p.id from ProjectDO p where p.projIdV4=?1 and p.deleteFlag=0")
    Long queryProjectIdByV4(Long reasonId);

    @Query("select p.projIdV4 from ProjectDO p where p.id=?1 and p.deleteFlag=0")
    Long queryByProjectIdV4(Long reasonId);

    Optional<ProjectDO> findByProjIdV4(Long projIdV4);

    @Query("select id as projectId,projIdV4 as projectIdV4 from ProjectDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5ProjectIds();




    ProjectDO getByProjIdV4(Long projIdV4);

    @Query(value = "select c.work_type from t_project t left join sale_con_contract c on t.contract_id=c.id and c.delete_flag=0 where (t.proj_id_v4=?1 or t.id=?1)",nativeQuery = true)
    String findWorkTypeById(Long reasonId);
    @Query(value = "select c.work_type from t_project t left join sale_con_contract c on t.contract_id=c.contract_idv4 and c.delete_flag=0 where (t.proj_id_v4=?1 or t.id=?1)",nativeQuery = true)
    String findWorkTypeById1(Long reasonId);


    @Query("update ProjectDO set deleteFlag=1 where id in ?1")
    @Modifying
    void deleteSoft(List<Long> keys);
}
