package com.elitesland.tw.tw5.server.prd.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexModelRefVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexSettingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyIndexSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyIndexSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyModelDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyIndexSettingRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 分级策略指标配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Repository
@RequiredArgsConstructor
public class BusinessStrategyIndexSettingDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyIndexSettingRepo repo;
    private final QBusinessStrategyIndexSettingDO qdo = QBusinessStrategyIndexSettingDO.businessStrategyIndexSettingDO;
    private final QBusinessStrategyModelDO qBusinessStrategyModelDO = QBusinessStrategyModelDO.businessStrategyModelDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyIndexSettingVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessStrategyIndexSettingVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 策略id business_strategy.id
                qdo.strategyId,
                // 指标编号
                qdo.indexNo,
                // 指标名称
                qdo.indexName,
                // 指标权重
                qdo.indexWeight,
                // 模型id business_strategy_model.id
                qdo.modelId,
                // 模型名称
                qdo.modelName,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyIndexSettingVO> getJpaQueryWhere(BusinessStrategyIndexSettingQuery query) {
        JPAQuery<BusinessStrategyIndexSettingVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessStrategyIndexSettingQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessStrategyIndexSettingQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 策略id business_strategy.id 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyId())) {
            list.add(qdo.strategyId.eq(query.getStrategyId()));
        }
        /** 指标编号 精确 */
        if (!ObjectUtils.isEmpty(query.getIndexNo())) {
            list.add(qdo.indexNo.eq(query.getIndexNo()));
        }
        /** 指标名称 精确 */
        if (!ObjectUtils.isEmpty(query.getIndexName())) {
            list.add(qdo.indexName.eq(query.getIndexName()));
        }
        /** 指标权重 精确 */
        if (!ObjectUtils.isEmpty(query.getIndexWeight())) {
            list.add(qdo.indexWeight.eq(query.getIndexWeight()));
        }
        /** 模型id business_strategy_model.id 精确 */
        if (!ObjectUtils.isEmpty(query.getModelId())) {
            list.add(qdo.modelId.eq(query.getModelId()));
        }
        /** 模型名称 精确 */
        if (!ObjectUtils.isEmpty(query.getModelName())) {
            list.add(qdo.modelName.eq(query.getModelName()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessStrategyIndexSettingVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyIndexSettingVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessStrategyIndexSettingVO> queryListDynamic(BusinessStrategyIndexSettingQuery query) {
        JPAQuery<BusinessStrategyIndexSettingVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessStrategyIndexSettingVO> queryPaging(BusinessStrategyIndexSettingQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyIndexSettingVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessStrategyIndexSettingVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessStrategyIndexSettingVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessStrategyIndexSettingDO save(BusinessStrategyIndexSettingDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessStrategyIndexSettingDO> saveAll(List<BusinessStrategyIndexSettingDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessStrategyIndexSettingPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 策略id business_strategy.id
        if (payload.getStrategyId() != null) {
            update.set(qdo.strategyId, payload.getStrategyId());
        }
        // 指标编号
        if (payload.getIndexNo() != null) {
            update.set(qdo.indexNo, payload.getIndexNo());
        }
        // 指标名称
        if (payload.getIndexName() != null) {
            update.set(qdo.indexName, payload.getIndexName());
        }
        // 指标权重
        if (payload.getIndexWeight() != null) {
            update.set(qdo.indexWeight, payload.getIndexWeight());
        }
        // 模型id business_strategy_model.id
        if (payload.getModelId() != null) {
            update.set(qdo.modelId, payload.getModelId());
        }
        // 模型名称
        if (payload.getModelName() != null) {
            update.set(qdo.modelName, payload.getModelName());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 策略id business_strategy.id
            if (nullFields.contains("strategyId")) {
                update.setNull(qdo.strategyId);
            }
            // 指标编号
            if (nullFields.contains("indexNo")) {
                update.setNull(qdo.indexNo);
            }
            // 指标名称
            if (nullFields.contains("indexName")) {
                update.setNull(qdo.indexName);
            }
            // 指标权重
            if (nullFields.contains("indexWeight")) {
                update.setNull(qdo.indexWeight);
            }
            // 模型id business_strategy_model.id
            if (nullFields.contains("modelId")) {
                update.setNull(qdo.modelId);
            }
            // 模型名称
            if (nullFields.contains("modelName")) {
                update.setNull(qdo.modelName);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
    public Long deleteByStrategyId(Long strategyId){
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.strategyId.eq(strategyId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 通过分级策略id(strategyId)查询指标和模型
     *
     * @param strategyId business_strategy.id 分级策略id
     */
    public List<BusinessStrategyIndexModelRefVO> queryIndexModelRef(Long strategyId){
        JPAQuery<BusinessStrategyIndexModelRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessStrategyIndexModelRefVO.class,
                qdo.id,
                qdo.indexName,
                qdo.indexWeight,
                qdo.modelId,
                qdo.strategyId,
                qBusinessStrategyModelDO.standaryFlag,
                qBusinessStrategyModelDO.dateRange,
                qBusinessStrategyModelDO.modelType,
                qBusinessStrategyModelDO.modelName,
                qBusinessStrategyModelDO.RWeight,
                qBusinessStrategyModelDO.FWeight,
                qBusinessStrategyModelDO.MWeight
        )).from(qdo).leftJoin(qBusinessStrategyModelDO).on(qdo.modelId.eq(qBusinessStrategyModelDO.id));
        jpaQuery.where(qdo.strategyId.eq(strategyId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qBusinessStrategyModelDO.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 通过分级策略id(strategyId)查询已经被删除的模型数量
     *
     * @param strategyIdList business_strategy.id 分级策略id
     */
    public Long quertDeleteModelCountByStrategyIds(List<Long> strategyIdList){
       return jpaQueryFactory.select(qdo.count()).from(qdo).
                leftJoin(qBusinessStrategyModelDO).
                on(qdo.modelId.eq(qBusinessStrategyModelDO.id)).
                where(qdo.strategyId.in(strategyIdList)).
                where(qdo.deleteFlag.eq(0)).
                where(qBusinessStrategyModelDO.deleteFlag.eq(1)).fetchOne();
    }
}

