package com.elitesland.tw.tw5.server.prd.pms.controller;


import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistBroadcastPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistBroadcastQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistBroadcastService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistBroadcastVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 广播
 *
 * @author xxb
 * @date 2023-10-07
 */
@Api(tags = "广播")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsDistBroadcast")
@Slf4j
public class PmsDistBroadcastController {

    private final PmsDistBroadcastService pmsDistBroadcastService;

    /**
     * 取消广播
     *
     * @param distId
     * @return
     */
    @GetMapping("/deleteSoft")
    @ApiOperation("广播-删除")
    public TwOutputUtil cancelBroadcast(Long distId){
        pmsDistBroadcastService.cancelBroadcast(distId);
        return TwOutputUtil.ok();
    }


//    /**
//     * 广播-分页
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("广播任务-分页")
//    public TwOutputUtil<PagingVO<PmsDistBroadcastVO>> paging(PmsDistBroadcastQuery query) {
//        return TwOutputUtil.ok(pmsDistBroadcastService.queryPaging(query));
//    }
//
//    /**
//     * 广播-新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("广播-新增")
//    public TwOutputUtil<PmsDistBroadcastVO> insert(@RequestBody PmsDistBroadcastPayload payload){
//        return TwOutputUtil.ok(pmsDistBroadcastService.insert(payload));
//    }
//
//    /**
//     * 广播-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("广播-更新")
//    public TwOutputUtil<PmsDistBroadcastVO> update(@RequestBody PmsDistBroadcastPayload payload){
//        return TwOutputUtil.ok(pmsDistBroadcastService.update(payload));
//    }
//
//    /**
//     * 广播-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("广播-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsDistBroadcastPayload payload){
//        return TwOutputUtil.ok(pmsDistBroadcastService.updateByKeyDynamic(payload));
//    }
//
//    /**
//     * 广播-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("广播-主键查询")
//    public TwOutputUtil<PmsDistBroadcastVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(pmsDistBroadcastService.queryByKey(key));
//    }
//
//
//
//    /**
//     * 广播-查询列表
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/list")
//    // @UdcNameClass
//    @ApiOperation("广播-查询列表")
//    public TwOutputUtil<List<PmsDistBroadcastVO>> queryList(PmsDistBroadcastQuery query) {
//        return TwOutputUtil.ok(pmsDistBroadcastService.queryListDynamic(query));
//    }
//
//    /**
//     * 广播-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("广播-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        pmsDistBroadcastService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}
