package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Api(tags = "项目活动")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectActivity")
@Slf4j
public class PmsProjectActivityController {

    private final PmsProjectActivityService pmsProjectActivityService;

    /**
     * 项目活动-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("项目活动-查询列表")
    public TwOutputUtil<List<PmsProjectActivityVO>> queryList(PmsProjectActivityQuery query) {
        return TwOutputUtil.ok(pmsProjectActivityService.queryListDynamic(query));
    }

    @GetMapping("/listForTimesheet")
    // @UdcNameClass
    @ApiOperation("根据项目拉取所有阶段")
    public TwOutputUtil<List<PmsProjectActivityVO>> listForTimesheet(PmsProjectActivityQuery query) {
        return TwOutputUtil.ok(pmsProjectActivityService.listForTimesheet(query));
    }

    /**
     * 项目活动-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目活动-新增或修改")
    public TwOutputUtil<PmsProjectActivityVO> insert(@RequestBody PmsProjectActivityPayload payload) {
        return TwOutputUtil.ok(pmsProjectActivityService.insertOrUpdate(payload));
    }

    /**
     * 项目活动-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目活动-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectActivityService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 活动管理 文件导入
     *
     * @return result
     */
    @ApiOperation("活动管理 文件导入")
    @PostMapping(value = "/importFile", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil importFile(MultipartFile file, Long projId) {
        pmsProjectActivityService.importFile(file, projId);
        return TwOutputUtil.ok();
    }

    /**
     * 活动管理模板导出
     *
     * @return result
     */
    @ApiOperation("活动管理模板导出")
    @GetMapping("/downloadFile")
    public void downloadFile(HttpServletResponse response) {
        pmsProjectActivityService.downloadFile(response);
    }


    /**
     * 项目活动-查询是否已经做过项目活动
     *
     * @param projId 项目主键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/getActivityStatus")
    @ApiOperation("项目活动-查询是否已经做过项目活动")
    public TwOutputUtil<List<PmsProjectActivityVO>> getActivityStatus(Long projId) {
        return TwOutputUtil.ok(pmsProjectActivityService.getActivityStatus(projId));
    }

    ////////////////////////////////////////////////////////////////////////////////////


//    /**
//     * 项目活动-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("项目活动-更新")
//    public TwOutputUtil<PmsProjectActivityVO> update(@RequestBody PmsProjectActivityPayload payload) {
//        pmsProjectActivityService.updateByKeyDynamic(payload);
//        return TwOutputUtil.ok();
//    }

//    /**
//     * 项目活动-分页
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("项目活动-分页")
//    public TwOutputUtil<PagingVO<PmsProjectActivityVO>> paging(PmsProjectActivityQuery query) {
//        return TwOutputUtil.ok(pmsProjectActivityService.queryPaging(query));
//    }


//    /**
//     * 项目活动流程待办详情-主键查询
//     *
//     * @param activityProcessID 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/byActivityProcessID")
//    @UdcNameClass
//    @ApiOperation("项目活动流程待办详情-主键查询")
//    public TwOutputUtil<PmsProjectActivityProcessVO> byActivityProcessID(Long activityProcessID) {
//        return TwOutputUtil.ok(pmsProjectActivityService.byActivityProcessID(activityProcessID));
//    }


}
