package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

;

/**
 * 结项检查项配置
 *
 * @author xxb
 * @date 2023-11-27
 */
@Entity
@Table(name = "pms_inspection_item_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_inspection_item_config", comment = "结项检查项配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsInspectionItemConfigDO extends BaseModel implements Serializable {
    /**
     * 工作类型编号
     */
    @Comment("工作类型编号")
    @Column()
    private String workTypeCodes;
    /**
     * 工作类型名称
     */
    @Comment("工作类型名称")
    @Column()
    private String workTypeNames;
    /**
     * 检查事项
     */
    @Comment("检查事项")
    @Column()
    private String checkItem;
    /**
     * 检查方式
     */
    @Comment("检查方式")
    @Column()
    private String checkMethod;
    /**
     * 检查说明
     */
    @Comment("检查说明")
    @Column()
    private String checkDescription;
    /**
     * 结项审批节点
     */
    @Comment("结项审批节点")
    @Column()
    private String approvalNodes;

    @Comment("结项审批节点名称")
    @Column()
    private String approvalNodeNames;

    /**
     * 排序号
     */
    @Comment("排序号")
    @Column()
    private Integer sortNo;

    public void copy(PmsInspectionItemConfigDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
