package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

;

/**
 * 项目
 *
 * @author carl
 * @date 2023-08-07
 */
@Entity
@Table(name = "pms_project", indexes = {
        @Index(name = "contract_index", columnList = "contract_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project", comment = "项目")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectDO extends BaseModel implements Serializable {
    /**
     * 项目重要度
     */
    @Comment("项目重要度")
    @Column(columnDefinition = "varchar(20)")
    private String projectImportance;
    /**
     * 预算总人天
     */
    @Comment("预算总人天")
    @Column()
    private BigDecimal totalDays;
    /**
     * 费用总成本
     */
    @Comment("费用总成本")
    @Column()
    private BigDecimal totalCost;
    /**
     * 工时结算周期
     */
    @Comment("工时结算周期")
    @Column(columnDefinition = "varchar(40)")
    private String timesheetPeriod;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column(columnDefinition = "varchar(40)")
    private String projName;
    /**
     * 项目状态
     */
    @Comment("项目状态")
    @Column(columnDefinition = "varchar(20)")
    private String projStatus;
    /**
     * 合同id
     */
    @Comment("合同id")
    @Column(name = "contract_id")
    private Long contractId;
    /**
     * 项目模板id
     */
    @Comment("项目模板id")
    @Column()
    private Long projTempId;
    /**
     * 客户行业
     */
    @Comment("客户行业")
    @Column(columnDefinition = "varchar(20)")
    private String custIdst;
    /**
     * 客户区域
     */
    @Comment("客户区域")
    @Column(columnDefinition = "varchar(20)")
    private String custRegion;
    /**
     * 预计开始日期
     */
    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;
    /**
     * 实际开始日期
     */
    @Comment("实际开始日期")
    @Column()
    private LocalDate startDate;
    /**
     * 实际结束日期
     */
    @Comment("实际结束日期")
    @Column()
    private LocalDate endDate;
    /**
     * 项目经理资源id
     */
    @Comment("项目经理资源id")
    @Column()
    private Long pmResId;
    /**
     * 督导资源id
     */
    @Comment("督导资源id")
    @Column()
    private Long superResId;
    /**
     * 项目风险等级
     */
    @Comment("项目风险等级")
    @Column()
    private String riskLevel;

    /**
     * 预计上线日期
     */
    @Comment("预计上线日期")
    @Column()
    private LocalDate planOnlineDate;
    /**
     * 项目经理当量系数
     */
    @Comment("项目经理当量系数")
    @Column()
    private BigDecimal pmEqvaRatio;
    /**
     * pmo资源负责人id
     */
    @Comment("pmo资源负责人id")
    @Column()
    private Long pmoResId;
    /**
     * pmo助理资源负责人id
     */
    @Comment("pmo助理资源负责人id")
    @Column()
    private Long pmoDeputyResId;

    /**
     * 预计总当量
     */
    @Comment("预计总当量")
    @Column()
    private BigDecimal totalEqva;
    /**
     * 派发当量（交付负责人-项目经理）
     */
    @Comment("派发当量（交付负责人-项目经理）")
    @Column()
    private BigDecimal distEqva;
    /**
     * 派发费用（交付负责人-项目经理）
     */
    @Comment("派发费用（交付负责人-项目经理）")
    @Column()
    private BigDecimal distCost;
    /**
     * 预计总费用
     */
    @Comment("预计总费用")
    @Column()
    private BigDecimal totalReimbursement;
    /**
     * 当量预估单价
     */
    @Comment("当量预估单价")
    @Column()
    private BigDecimal eqvaPrice;
    /**
     * 允许外包
     */
    @Comment("允许外包")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer epibolyPermitFlag;
    /**
     * 允许转包
     */
    @Comment("允许转包")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer subcontractPermitFlag;
    /**
     * 非结算活动需要审批
     */
    @Comment("非结算活动需要审批")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer finishApproveFlag;
    /**
     * 最低保证金
     */
    @Comment("最低保证金")
    @Column()
    private BigDecimal deposit;
    /**
     * 关联项目
     */
    @Comment("关联项目")
    @Column()
    private Long relatedProjId;
    /**
     * 关联项目编号
     */
    @Comment("关联项目编号")
    @Column(columnDefinition = "varchar(20)")
    private String relatedProjNo;
    /**
     * 绩效规则
     */
    @Comment("绩效规则")
    @Column(columnDefinition = "varchar(40)")
    private String performanceDesc;
    /**
     * 关闭原因
     */
    @Comment("关闭原因")
    @Column()
    private String closeReason;

    /**
     * 差旅餐补限额
     */
    @Comment("差旅餐补限额")
    @Column()
    private BigDecimal maxTravelFee;
    /**
     * 项目编号
     */
    @Comment("项目编号")
    @Column(columnDefinition = "varchar(40)")
    private String projNo;
    /**
     * 完工百分比
     */
    @Comment("完工百分比")
    @Column()
    private BigDecimal compPercent;
    /**
     * 允许一人多任务包
     */
    @Comment("允许一人多任务包")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer muiltiTaskFlag;
    /**
     * 项目进度状态
     */
    @Comment("项目进度状态")
    @Column()
    private String projProcessStatus;
    /**
     * 最新汇报时间时间
     */
    @Comment("最新汇报时间时间")
    @Column()
    private LocalDateTime reportTime;
    /**
     * 自动汇报标识
     */
    @Comment("自动汇报标识")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer autoReportFlag;
    /**
     * 每期确认金额
     */
    @Comment("每期确认金额")
    @Column()
    private BigDecimal reportPeriodAmt;
    /**
     * 汇报开始期间
     */
    @Comment("汇报开始期间")
    @Column()
    private LocalDate reportStartDate;
    /**
     * 汇报期间数
     */
    @Comment("汇报期间数")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer reportQty;
    /**
     * 包含客户承担费用标志
     */
    @Comment("包含客户承担费用标志")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer containsCustomerFlag;
    /**
     * 项目难度
     */
    @Comment("项目难度")
    @Column(columnDefinition = "varchar(20)")
    private String projectDifficult;
    /**
     * 项目预算总开关标志 0:否 1:是
     */
    @Comment("项目预算总开关标志 0:否 1:是")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer budgetSwitchFlag;
    /**
     * 项目活动状态
     */
    @Comment("项目活动状态 ")
    @Column(columnDefinition = "varchar(20)")
    private String projActivityStatus;
    /**
     * 项目活动审批状态
     */
    @Comment("项目活动审批状态 ")
    @Column(columnDefinition = "varchar(20)")
    private String projActivityApprStatus;

    /**
     * 产品编号
     */
    @Comment("产品编号")
    @Column(columnDefinition = "varchar(20)")
    private String productNo;
    /**
     * 易道壳项目过程文档itemid
     */
    @Comment("易道壳项目过程文档itemid")
    @Column()
    private String processDocItemId;
    /**
     * 易道壳项目验收文档itemid
     */
    @Comment("易道壳项目验收文档itemid")
    @Column()
    private String acceptanceDocItemId;
    /**
     * 易道壳项目总结文档itemid
     */
    @Comment("易道壳项目总结文档itemid")
    @Column()
    private String summaryDocItemId;
    /**
     * 研发补贴金额
     */
    @Comment("研发补贴金额")
    @Column()
    private BigDecimal subsidyAmt;
    /**
     * 直接改为周末现场有补助（原字段：折旧月数）
     */
    @Comment("直接改为周末现场有补助")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer depreciationMonths;
    /**
     * 折旧开始时间
     */
    @Comment("折旧开始时间")
    @Column()
    private LocalDateTime depreciationStartDate;

    /**
     * sow节选
     */
    @Comment("sow节选")
    @Column()
    private String sowFiles;
    /**
     * 预算附件
     */
    @Comment("预算附件")
    @Column()
    private String budgetFiles;
    /**
     * 绩效附件
     */
    @Comment("绩效附件")
    @Column()
    private String performanceFiles;
    /**
     * 附件
     */
    @Comment("附件")
    @Column()
    private String projectFiles;
    /**
     * 扩展字段1 项目类型
     */
    @Comment("扩展字段1 项目类型")
    @Column()
    private String ext1;
    /**
     * 项目收入确认备注
     */
    @Comment("项目收入确认备注")
    @Column()
    private String ext2;
    /**
     * 扩展字段3
     */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /**
     * 扩展字段4
     */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /**
     * 扩展字段5
     */
    @Comment("扩展字段5")
    @Column()
    private String ext5;
    /**
     * 帮我吧项目名称
     */
    @Comment("帮我吧项目名称")
    @Column()
    private String bangwo8ProjName;

    /**
     * 研发立项附件
     */
    @Comment("研发立项附件")
    @Column()
    private String researchFiles;

    /**
     * 变更中标志 0:否 1:是
     */
    @Comment("变更中标志 0:否 1:是")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer changeFlag = 0;
    /**
     * 0:不需要提示 1:需要无合同项目激活后代办提示，2:需要预算变更代办提示
     */
    @Comment("0:不需要提示 1:需要无合同项目激活后代办提示，2:需要预算变更代办提示")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer noContractFlag = 0;


    @Comment("主交付BU_ID")
    @Column()
    private Long deliBuId;
    /**
     * 交付用户id
     */
    @Comment("交付用户id")
    @Column()
    private Long deliUserId;
    /**
     * 销售负责人ID
     */
    @Comment("销售负责人ID")
    @Column()
    private Long saleManUserId;
    /**
     * 签单buid
     */
    @Comment("签单buid")
    @Column()
    private Long signBuId;

    /**
     * 科目模板id
     */
    @Comment("科目模板id")
    @Column()
    private Long subjectTempId;

    /**
     * 资源规划更新日期
     */
    @Comment("资源规划更新日期")
    @Column()
    private LocalDateTime planUpdateDate;

    /**
     * 成本级别
     */
    @Comment("成本级别")
    @Column()
    private String costLevel;

    public void copy(PmsProjectDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }


    /**
     * JDE凭证号
     */
    @Comment("JDE凭证号")
    @Column()
    private String jdeDocNo;

    /**
     * JDE凭证状态
     */
    @Comment("JDE凭证状态")
    @Column()
    private String jdeDocState;

    /**
     * JDE凭证失败原因
     */
    @Comment("JDE凭证失败原因")
    @Column(length = 3000)
    private String jdeErrMsg;

    /**
     * JDE提交确认时间
     */
    @Comment("JDE提交确认时间")
    @Column()
    private LocalDateTime jdeConfirmTime;


    /**
     * 摘要
     */
    @Comment("摘要")
    @Column()
    private String jdeSummary;

    /**
     * 凭证日期
     */
    @Comment("凭证日期")
    @Column()
    private String jdeDocTime;
}
