package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Api(tags = "采购协议")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/purchaseAgreement")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.PUR_AGREEMENT)
public class PurchaseAgreementController {

private final PurchaseAgreementService purchaseAgreementService;

    /**
     * 采购协议-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("采购协议-新增")
    public TwOutputUtil<PurchaseAgreementVO> insert(@RequestBody PurchaseAgreementPayload payload){
         return TwOutputUtil.ok(purchaseAgreementService.insert(payload));
    }

    /**
     * 采购协议-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("采购协议-更新")
    public TwOutputUtil<PurchaseAgreementVO> update(@RequestBody PurchaseAgreementPayload payload){
        return TwOutputUtil.ok(purchaseAgreementService.update(payload));
    }

    /**
     * 采购协议-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("采购协议-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PurchaseAgreementPayload payload){
        return TwOutputUtil.ok(purchaseAgreementService.updateByKeyDynamic(payload));
    }

    /**
     * 采购协议-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("采购协议-主键查询")
    public TwOutputUtil<PurchaseAgreementVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(purchaseAgreementService.queryByKey(key));
    }

    /**
     * 采购协议-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("采购协议-分页")
    public TwOutputUtil<PagingVO<PurchaseAgreementVO>> paging(PurchaseAgreementQuery query) {
        return TwOutputUtil.ok(purchaseAgreementService.queryPaging(query));
    }

    /**
     * 采购协议-权限分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/permission/paging")
    @UdcNameClass
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.PCN_PURCHASE_LIST_DATA_POWER, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    @ApiOperation("采购协议-权限分页")
    public TwOutputUtil<PagingVO<PurchaseAgreementVO>> permissionPaging(@RequestBody PurchaseAgreementQuery query) {
        return TwOutputUtil.ok(purchaseAgreementService.permissionPaging(query));
    }


    /**
     * 采购协议-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("采购协议-查询列表")
    public TwOutputUtil<List<PurchaseAgreementVO>> queryList(PurchaseAgreementQuery query) {
        return TwOutputUtil.ok(purchaseAgreementService.queryListDynamic(query));
    }

//    /**
//     * 签约公司/供应商-列表查询
//     * @return result
//     */
//    @GetMapping("/ab/queryList/{relateType}")
//    public TwOutputUtil<List<PrdAbVO>> abQueryList(@PathVariable String relateType) {
//        return TwOutputUtil.ok(purchaseAgreementService.abQueryList(relateType));
//    }

    /**
     * 采购协议-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("采购协议-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         purchaseAgreementService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 采购协议-激活
     *
     * @param id 主键id
     * @return result
     */
    @PatchMapping("/active")
    @ApiOperation("采购协议-激活")
    @GlobalTransactional
    public TwOutputUtil active(Long id) {
        purchaseAgreementService.active(id);
        return TwOutputUtil.ok();
    }

    /**
     * 采购协议暂挂
     *
     * @param ids 采购协议ID集合
     * @return result
     */
    @ApiOperation(value = "采购协议-暂挂")
    @PatchMapping("/pending")
    public TwOutputUtil pending(@RequestParam List<Long> ids) {
        purchaseAgreementService.pending(ids);
        return TwOutputUtil.ok();
    }
    /**
     * 采购协议终止
     *
     * @param ids 采购协议ID集合
     * @return result
     */
    @ApiOperation(value = "采购协议-终止")
    @PatchMapping("/break")
    public TwOutputUtil purAgreementBreak(@RequestParam List<Long> ids, @RequestParam String overReason) {
        purchaseAgreementService.purAgreementBreak(ids, overReason);
        return TwOutputUtil.ok();
    }

    /**
     * 批量导出协议excel
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/download")
    @ApiOperation(value = "采购协议-导出")
    public void download(HttpServletResponse response, PurchaseAgreementQuery query) {
        purchaseAgreementService.download(response, query);
    }

    /**
     * 采购协议-批量导出协议excel
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/permission/download")
    @UdcNameClass
    @ApiOperation("采购协议-批量导出协议excel")
    public void permissionDownload(@RequestBody PurchaseAgreementQuery query, HttpServletResponse response) {
        purchaseAgreementService.permissionDownload(query, response);
    }

    /**
     * 根据采购协议Id获取费率
     * @param agreementId 采购协议Id
     * @param amt 总金额
     * @return 费率
     */
    @GetMapping("/getRate/{agreementId}/{amt}")
    @ApiOperation("根据采购协议Id获取费率")
    public TwOutputUtil<BigDecimal> getRateByAgreementId(@PathVariable("agreementId") Long agreementId, @PathVariable("amt") BigDecimal amt){
        return TwOutputUtil.ok(purchaseAgreementService.getRateByAgreementId(agreementId, amt));
    }
}

