package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivableDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableDService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivableDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivableDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivableDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 合同收款明细
 *
 * @author lemon
 * @date 2023-09-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConReceivableDServiceImpl extends BaseServiceImpl implements ConReceivableDService {

    private final ConReceivableDRepo conReceivableDRepo;
    private final ConReceivableDDAO conReceivableDDAO;
    private final ConReceivablePlanRepo conReceivablePlanRepo;
    private final PrdOrgEmployeeService employeeService;


    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
//    @Value("${tw4.url}")
//    private String tw4_url;

    @Value("${tw4.sale.conReceivabled}")
    private String conReceivabled;


    @Override
    public PagingVO<ConReceivableDVO> queryPaging(ConReceivableDQuery query) {
        return conReceivableDDAO.queryPaging(query);
    }

    @Override
    public List<ConReceivableDVO> queryListDynamic(ConReceivableDQuery query) {
        return conReceivableDDAO.queryListDynamic(query);
    }

    @Override
    public ConReceivableDVO queryByKey(Long key) {
        ConReceivableDDO entity = conReceivableDRepo.findById(key).orElseGet(ConReceivableDDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConReceivableDVO vo = ConReceivableDConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConReceivableDVO insert(ConReceivableDPayload payload) {
        ConReceivableDDO entityDo = ConReceivableDConvert.INSTANCE.toDo(payload);
        return ConReceivableDConvert.INSTANCE.toVo(conReceivableDRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConReceivableDVO update(ConReceivableDPayload payload) {
        ConReceivableDDO entity = conReceivableDRepo.findById(payload.getId()).orElseGet(ConReceivableDDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConReceivableDDO entityDo = ConReceivableDConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConReceivableDConvert.INSTANCE.toVo(conReceivableDRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(ConReceivableDPayload payload) {
        ConReceivableDDO entity = conReceivableDRepo.findById(payload.getId()).orElseGet(ConReceivableDDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = conReceivableDDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conReceivableDDAO.deleteSoft(keys);
        }
    }

    /**
     * 同步4.0
     *
     * @param param
     */
    @Override
    public void syncConReceivableDTo4(String param) {
        String syncType = "con_receivabled_to4";
        LocalDateTime syncTime;
        if (StringUtils.hasText(param)) {
            syncTime = LocalDateTime.parse(param);
        } else {
            syncTime = daoLog.queryOrgSyncLog(syncType);
            if (syncTime == null) {
                syncTime = LocalDateTime.of(2023, 11, 1, 0, 0);
            } else {
                //将同步时间提前30秒，防止拉数据遗漏
                syncTime = syncTime.minusSeconds(30);
            }
        }
        XxlJobLogger.log("合同收款明细同步到4.0开始...");
        XxlJobLogger.log("syncContractInvBatchTo4 localDateTime：" + syncTime);

        // 查询待同步数据
        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
        List<ConReceivableDDO> conReceivableDDOS = conReceivableDRepo.findByModifyTimeStart(format);
        // 同步内容
        String syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(conReceivableDDOS)) {
            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConReceivableDDO temDo : conReceivableDDOS) {
                Long planIdV4 = conReceivablePlanRepo.queryV4Id(temDo.getRecvplanId());
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag", temDo.getDeleteFlag());
                    if(planIdV4==null){
                        map.put("recvplanIdV5",temDo.getRecvplanId());
                        map.put("recvplanId",null);
                    }else{
                        map.put("recvplanIdV5",null);
                        map.put("recvplanId",planIdV4);
                    }
                    // 翻译创建人与更新人
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
//                    String resultMain = httpUtil.sendPost(tw4_url + conReceivabled, map);
//                    Map<String, Object> data = (Map) JSON.parse(resultMain);
                    Map<String, Object> data = new HashMap<>();
                    if ((data.get("ok") + "").equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        conReceivableDRepo.updateConReceivableDIdV4(idV4, temDo.getId());
                    } else {
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "合同收款明细id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + data.get("datum"), null);
                        //更新该条合同的更新时间，下一次处理;
                        conReceivableDRepo.updateRemark(temDo.getId());
                        failNum++;
                    }
                } catch (Exception e) {
                    XxlJobLogger.log("合同收款明细" + temDo.getId() + "同步异常......" + e);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "合同收款明细id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
                    failNum++;
                    //更新该条合同的更新时间，下一次处理;
                    conReceivableDRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "更新了" + (conReceivableDDOS.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
        } else {
            syncData = "合同收款明细数据未变化";
        }
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步合同收款明细结束..." + logDO);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

}
