package com.elitesland.tw.tw5.server.prd.system.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionTableFieldsPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionTableFieldsQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionTableFieldsService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionTableFieldsVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemPermissionTableFieldsConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionTableFieldsDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionTableFieldsDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionTableFieldsRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @date 2023-06-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemPermissionTableFieldsServiceImpl extends BaseServiceImpl implements PrdSystemPermissionTableFieldsService {

    private final PrdSystemPermissionTableFieldsRepo businessTableFieldsRepo;
    private final PrdSystemPermissionTableFieldsDAO businessTableFieldsDAO;
    @PersistenceContext
    private EntityManager em;

    @Override
    public PagingVO<PrdSystemPermissionTableFieldsVO> queryPaging(PrdSystemPermissionTableFieldsQuery query) {
        return businessTableFieldsDAO.queryPaging(query);
    }


    /**
     * 查询数据库的表字段数据数据
     *
     * @param tableName 表名
     * @return {@link List}<{@link PrdSystemPermissionTableFieldsVO}>
     */
    @Override
    public List<PrdSystemPermissionTableFieldsVO> query(String tableName) {
        // 使用预编译防止sql注入
        String sql = "select column_name, is_nullable, data_type, column_comment, column_key, extra,column_default,column_type  from information_schema.columns " +
            "where table_name = ? and table_schema = (select database()) order by ordinal_position";
        Query query = em.createNativeQuery(sql);
        query.setParameter(1, tableName);
        List result = query.getResultList();
        List<PrdSystemPermissionTableFieldsVO> columnInfos = new ArrayList<>();
        for (Object obj : result) {
            Object[] arr = (Object[]) obj;
            columnInfos.add(
                new PrdSystemPermissionTableFieldsVO(
                    tableName,
                    arr[0].toString(),
                    "NO".equals(arr[1]),
                    arr[2].toString(),
                    ObjectUtil.isNotNull(arr[3]) ? arr[3].toString() : null,
                    ObjectUtil.isNotNull(arr[4]) ? arr[4].toString() : null,
                    ObjectUtil.isNotNull(arr[5]) ? arr[5].toString() : null,
                    ObjectUtil.isNotNull(arr[6]) ? arr[6].toString() : null
                )
            );
        }

//        columnInfos.forEach(businessTableFieldsVO -> businessTableFieldsVO.setTableId(tableId));
        // 过滤无用字段
        columnInfos = getColumnInfos(columnInfos);
        return columnInfos;
    }

    public List<PrdSystemPermissionTableFieldsVO> queryList(PrdSystemPermissionTableFieldsQuery query) {
        Long tableId = query.getTableId();
        if (tableId == null) {
            throw TwException.error("", "tableId不能为空");
        }
        List<PrdSystemPermissionTableFieldsVO> businessTableFieldsVOS = businessTableFieldsDAO.queryListDynamic(query);
        return businessTableFieldsVOS;
    }


    private List<PrdSystemPermissionTableFieldsVO> getColumnInfos(List<PrdSystemPermissionTableFieldsVO> columnInfos) {
        columnInfos = columnInfos.stream().filter(columnInfo -> !(
            columnInfo.getField().equals("tenant_id")
                //|| columnInfo.getColumnName().equals("id")
//                || columnInfo.getField().equals("remark")
//                || columnInfo.getField().equals("create_user_id")
//                || columnInfo.getField().equals("creator")
//                || columnInfo.getField().equals("create_time")
//                || columnInfo.getField().equals("modify_user_id")
//                || columnInfo.getField().equals("updater")
//                || columnInfo.getField().equals("modify_time")
                || columnInfo.getField().equals("delete_flag")
                || columnInfo.getField().equals("audit_data_version")
                || columnInfo.getField().equals("sec_bu_id")
                || columnInfo.getField().equals("sec_user_id")
                || columnInfo.getField().equals("tenant_org_id")
                || columnInfo.getField().equals("belong_org_id")
                || columnInfo.getField().equals("sec_ou_id"))
        ).collect(Collectors.toList());
        return columnInfos;
    }

    @Override
    public PrdSystemPermissionTableFieldsVO queryByKey(Long key) {
        PrdSystemPermissionTableFieldsDO entity = businessTableFieldsRepo.findById(key).orElseGet(PrdSystemPermissionTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemPermissionTableFieldsVO vo = PrdSystemPermissionTableFieldsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemPermissionTableFieldsVO insert(PrdSystemPermissionTableFieldsPayload payload) {
        PrdSystemPermissionTableFieldsDO entityDo = PrdSystemPermissionTableFieldsConvert.INSTANCE.toDo(payload);
        return PrdSystemPermissionTableFieldsConvert.INSTANCE.toVo(businessTableFieldsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemPermissionTableFieldsVO update(PrdSystemPermissionTableFieldsPayload payload) {
        PrdSystemPermissionTableFieldsDO entity = businessTableFieldsRepo.findById(payload.getId()).orElseGet(PrdSystemPermissionTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemPermissionTableFieldsDO entityDo = PrdSystemPermissionTableFieldsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdSystemPermissionTableFieldsConvert.INSTANCE.toVo(businessTableFieldsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdSystemPermissionTableFieldsPayload payload) {
        PrdSystemPermissionTableFieldsDO entity = businessTableFieldsRepo.findById(payload.getId()).orElseGet(PrdSystemPermissionTableFieldsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessTableFieldsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessTableFieldsDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<PrdSystemPermissionTableFieldsVO> queryListDynamic(PrdSystemPermissionTableFieldsQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.asc("createTime");
        query.setOrders(Arrays.asList(orderItem));
        Long tableId = query.getTableId();
        if (tableId == null) {
            throw TwException.error("", "tableId不能为空");
        }
        List<PrdSystemPermissionTableFieldsVO> businessTableFieldsVOS = businessTableFieldsDAO.queryListDynamic(query);
        return businessTableFieldsVOS;
    }

}
