/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import java.util.concurrent.Callable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class TransactionUtilServiceImpl
implements TransactionUtilService {
    private final PlatformTransactionManager transactionManager;
    private ThreadLocal<TransactionStatus> threadLocal = new ThreadLocal();

    @Override
    public void begin() {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        this.threadLocal.set(this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition));
    }

    @Override
    public void commit() {
        this.transactionManager.commit(this.threadLocal.get());
        this.threadLocal.remove();
    }

    @Override
    public void rollback() {
        this.transactionManager.rollback(this.threadLocal.get());
        this.threadLocal.remove();
    }

    @Override
    public <V> V executeWithCallable(Callable<V> callable) {
        try {
            this.begin();
            V result = callable.call();
            this.commit();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rollback();
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    public void executeWithRunnable(Runnable runnable) {
        try {
            this.begin();
            runnable.run();
            this.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rollback();
            throw e;
        }
    }

    public TransactionUtilServiceImpl(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

