/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTaxPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTaxQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTaxService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTaxVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimTaxConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimTaxDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimTaxDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimTaxRepo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class AccReimTaxServiceImpl
extends BaseServiceImpl
implements AccReimTaxService {
    private static final Logger log = LoggerFactory.getLogger(AccReimTaxServiceImpl.class);
    private final AccReimTaxRepo repo;
    private final AccReimTaxDAO dao;
    private final InvInvoiceService invInvoiceService;

    public PagingVO<AccReimTaxVO> queryPaging(AccReimTaxQuery query) {
        PagingVO<AccReimTaxVO> paging = this.dao.queryPaging(query);
        if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
            Set reimDtlId = paging.getRecords().stream().map(AccReimTaxVO::getReimDtlId).collect(Collectors.toSet());
            InvInvoiceQuery invoiceQuery = new InvInvoiceQuery();
            invoiceQuery.setReimDIdList(reimDtlId);
            List invInvoiceVOS = this.invInvoiceService.queryListDynamic(invoiceQuery);
            Map<Long, List<InvInvoiceVO>> invInvoiceGroup = invInvoiceVOS.stream().collect(Collectors.groupingBy(InvInvoiceVO::getReimDId));
            paging.getRecords().forEach(vo -> {
                List invDetails = (List)invInvoiceGroup.get(vo.getReimDtlId());
                if (!ObjectUtils.isEmpty((Object)invDetails)) {
                    vo.setInvInvoiceList(invDetails);
                }
                if (vo.getReimAmt() != null) {
                    BigDecimal taxAmt = ObjectUtils.isEmpty((Object)vo.getTaxAmt()) ? BigDecimal.ZERO : vo.getTaxAmt();
                    BigDecimal noTaxReimAmt = vo.getReimAmt().subtract(taxAmt);
                    vo.setNoTaxReimAmt(noTaxReimAmt);
                }
            });
        }
        return paging;
    }

    public List<AccReimTaxVO> queryListDynamic(AccReimTaxQuery query) {
        List<AccReimTaxVO> accReimTaxVOS = this.dao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(accReimTaxVOS)) {
            Set reimDtlId = accReimTaxVOS.stream().map(AccReimTaxVO::getReimDtlId).collect(Collectors.toSet());
            InvInvoiceQuery invoiceQuery = new InvInvoiceQuery();
            invoiceQuery.setReimDIdList(reimDtlId);
            List invInvoiceVOS = this.invInvoiceService.queryListDynamic(invoiceQuery);
            Map<Long, List<InvInvoiceVO>> invInvoiceGroup = invInvoiceVOS.stream().collect(Collectors.groupingBy(InvInvoiceVO::getReimDId));
            accReimTaxVOS.forEach(vo -> {
                List invDetails = (List)invInvoiceGroup.get(vo.getReimDtlId());
                if (!ObjectUtils.isEmpty((Object)invDetails)) {
                    vo.setInvInvoiceList(invDetails);
                }
                if (vo.getReimAmt() != null) {
                    BigDecimal taxAmt = ObjectUtils.isEmpty((Object)vo.getTaxAmt()) ? BigDecimal.ZERO : vo.getTaxAmt();
                    BigDecimal noTaxReimAmt = vo.getReimAmt().subtract(taxAmt);
                    vo.setNoTaxReimAmt(noTaxReimAmt);
                }
            });
        }
        return accReimTaxVOS;
    }

    public AccReimTaxVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    @Transactional
    public AccReimTaxVO insert(AccReimTaxPayload payload) {
        AccReimTaxDO entityDo = AccReimTaxConvert.INSTANCE.toDo(payload);
        return AccReimTaxConvert.INSTANCE.toVo((AccReimTaxDO)this.repo.save(entityDo));
    }

    @Transactional
    public long batchInsert(List<AccReimTaxPayload> payloadList) {
        List<AccReimTaxDO> dos = AccReimTaxConvert.INSTANCE.payloads2Dos(payloadList);
        List<AccReimTaxDO> saveDOs = this.dao.saveAll(dos);
        return saveDOs.size();
    }

    @Transactional
    public AccReimTaxVO update(AccReimTaxPayload payload) {
        AccReimTaxQuery query = new AccReimTaxQuery();
        query.setId(payload.getId());
        long count = this.dao.count(query);
        if (count <= 0L) {
            log.warn("\u5f53\u524did:[{}]\u5bf9\u5e94\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object)payload.getId());
            return null;
        }
        AccReimTaxDO entity = AccReimTaxConvert.INSTANCE.toDo(payload);
        return AccReimTaxConvert.INSTANCE.toVo((AccReimTaxDO)this.repo.save(entity));
    }

    @Transactional
    public long updateByKeyDynamic(AccReimTaxPayload payload) {
        AccReimTaxDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimTaxDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.dao.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.dao.deleteSoft(keys);
        }
    }

    @Transactional
    public void delByReimId(Long reimId) {
        this.dao.delByReimId(reimId);
    }

    public List<AccReimExportVO> getExportTaxData(Set<Long> idList) {
        return this.dao.getExportTaxData(idList);
    }

    public AccReimTaxServiceImpl(AccReimTaxRepo repo, AccReimTaxDAO dao, InvInvoiceService invInvoiceService) {
        this.repo = repo;
        this.dao = dao;
        this.invInvoiceService = invInvoiceService;
    }
}

