/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPotentialCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActReportVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActActivityConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActDynamicConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActReportConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActPlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActDynamicDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActReportDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActPlanDetailRepo;
import com.elitesland.tw.tw5.server.prd.crm.service.CrmLeadsServiceImpl;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.QueryResults;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CrmActActivityServiceImpl
extends BaseServiceImpl
implements CrmActActivityService {
    private static final Logger log = LoggerFactory.getLogger(CrmActActivityServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO projectDAO;
    private final CrmActActivityDAO dao;
    private final PrdSystemRoleDAO daoRole;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final CrmActPlanDAO daoPlan;
    private final FileUtil fileUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final TransactionTemplate transactionTemplate;
    private final PrdOrgOrganizationDAO daoOrg;
    private final TransactionUtilService transactionUtilService;
    private final PrdSystemBusinessChangeService changeService;
    private final PrdSystemBusinessChangeDAO changeDAO;
    private final PrdMessageConfigService messageConfigService;
    private final PrdMessageConfigRepo repoMessage;
    private final WorkflowUtil workflowUtil;
    private final CrmActPlanDetailRepo actPlanDetailRepo;
    @Value(value="${tw5.user_default.user_id}")
    private Long default_user_id;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Transactional
    public void activityUnReleaseJobHandler() {
        List<CrmActActivityVO> activitys = this.dao.findActivityUnReleases();
        if (!ObjectUtils.isEmpty(activitys)) {
            List<Long> activityIds = activitys.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            PrdSystemRoleVO roleVO = this.daoRole.queryByCode("MARKET-MANAGE");
            ArrayList messageConfigDOS = new ArrayList();
            activitys.forEach(activity -> {
                String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
                String content = "\u6d3b\u52a8 {" + activity.getProjectNo() + "--" + activity.getProjectName() + "}\uff0c\u5ba1\u6279\u7ed3\u675f\u5df2\u8d853\u4e2a\u81ea\u7136\u65e5\uff0c{" + this.cacheUtil.getUserName(activity.getCreateUserId()) + "} \u6682\u672a\u53d1\u5e03\u516c\u544a/\u90ae\u4ef6\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
                PrdMessageConfigDO ado = new PrdMessageConfigDO();
                ado.setMessageCode(code);
                ado.setMessageTitle("\u201c\u6d3b\u52a8\u5f85\u53d1\u5e03\u201d\u903e\u671f\u901a\u77e5");
                ado.setMessageContent(content);
                ado.setCreateUserId(this.default_user_id);
                ado.setContentBigType("companyMessage");
                ado.setContentType("systemMessage");
                ado.setCreateSource("\u7cfb\u7edf\u7ba1\u7406\u5458");
                ado.setIsEnable(0);
                ado.setMessageType(2);
                ado.setNoticeScope("appoint_role");
                ado.setNoticeSource("" + roleVO.getId());
                ado.setNoticeWay("email");
                ado.setTenantId(activity.getTenantId());
                ado.setReleaseSource("profileMessage");
                ado.setReleaseStatus(3);
                ado.setTriggerTime(LocalDateTime.now());
                messageConfigDOS.add(ado);
            });
            List messageConfigDOS1 = this.repoMessage.saveAll(messageConfigDOS);
            List messageConfigVOS = messageConfigDOS1.stream().map(PrdMessageConfigConvert.INSTANCE::toVo).collect(Collectors.toList());
            this.messageConfigService.releaseMessage(messageConfigVOS);
            this.dao.updateEmailRemind(activityIds);
        }
    }

    public PagingVO<CrmActActivityVO> queryPagingUnReleased(CrmActActivityQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        query.setIsRelease(Integer.valueOf(0));
        query.setCreateUserId(userId);
        PagingVO<CrmActActivityVO> activityVOPagingVO = this.dao.queryPagingUnReleased(query);
        List activityVOS = activityVOPagingVO.getRecords();
        activityVOS.forEach(activityVO -> this.transferSystemSelection((CrmActActivityVO)activityVO));
        return activityVOPagingVO;
    }

    public Map<String, Object> findActivityUnReleaseByUserId(long userId) {
        QueryResults<CrmActActivityDO> activityRelease = this.dao.findActivityReleaseByUserId(userId);
        long total = activityRelease.getTotal();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("num", total);
        if (total > 0L) {
            CrmActActivityDO crmActActivityDO = (CrmActActivityDO)((Object)activityRelease.getResults().get(0));
            long actSecond = crmActActivityDO.getApprovedTime().toEpochSecond(ZoneOffset.of("+8")) + 259200L - LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
            map.put("time", actSecond);
        }
        return map;
    }

    @Transactional
    public void refuseRelease(Long id) {
        this.dao.updataReleaseByIds(List.of(id), 1);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public CrmActActivityVO insert(CrmActActivityPayload payload) {
        CrmActPlanVO planVO = this.daoPlan.queryBykey(payload.getPlanId());
        if (!planVO.getPlanStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u8be5\u8ba1\u5212\u6682\u672a\u6fc0\u6d3b");
        }
        List<CrmActActivityDO> actActivityDOS = this.dao.queryActivityByDetailId(payload.getDetailId());
        BigDecimal totalMoney = new BigDecimal("0");
        for (CrmActActivityDO actActivityDO : actActivityDOS) {
            totalMoney = totalMoney.add(actActivityDO.getTotalMoney());
        }
        totalMoney = totalMoney.add(payload.getTotalMoney());
        Optional planDetailOptional = this.actPlanDetailRepo.findById(payload.getDetailId());
        if (planDetailOptional.isEmpty()) {
            log.error("\u6839\u636eid{}\u672a\u67e5\u5230\u8ba1\u5212\u660e\u7ec6", (Object)payload.getDetailId());
            throw new BusinessException("\u672a\u67e5\u5230\u8be5\u6d3b\u52a8\u5bf9\u5e94\u7684\u8ba1\u5212\u660e\u7ec6");
        }
        CrmActPlanDetailDO planDetailDO = (CrmActPlanDetailDO)((Object)planDetailOptional.get());
        planDetailDO.setExpenditure(totalMoney);
        this.actPlanDetailRepo.save((Object)planDetailDO);
        String code = this.generateSeqNum("ACT_PROJECT_NO", new String[0]);
        this.transactionTemplate.setPropagationBehavior(3);
        CrmActActivityVO execute = (CrmActActivityVO)this.transactionTemplate.execute(transactionStatus -> {
            PrjProjectDO ado = CrmActActivityConvert.INSTANCE.toProjectDo(payload);
            ado.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            ado.setProjectType(CrmFollowObjectEnum.Activity.getCode());
            ado.setProjectNo(code);
            ado = this.projectDAO.save(ado);
            CrmActActivityDO crmActActivityDO = CrmActActivityConvert.INSTANCE.toDo(payload);
            crmActActivityDO.setProjectId(ado.getId());
            this.dao.save(crmActActivityDO);
            CrmActActivityVO crmActActivityVO = CrmActActivityConvert.INSTANCE.toVo(crmActActivityDO);
            crmActActivityVO.setOrgId(ado.getOrgId());
            if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
                this.submitProc(crmActActivityVO);
                this.sendEmail(ado.getProjectName(), crmActActivityDO.getTotalMoney(), planVO, planDetailDO);
            }
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(ado.getCreateUserId());
            userIds.add(ado.getManageUserId());
            this.addProjectMember(ado.getId(), userIds);
            return crmActActivityVO;
        });
        return execute;
    }

    private void sendEmail(String projectName, BigDecimal actTotalMoney, CrmActPlanVO planVO, CrmActPlanDetailDO planDetailDO) {
        try {
            BigDecimal balanceMoney = planDetailDO.getTotalMoney().subtract(planDetailDO.getExpenditure());
            log.info("\u5b63\u5ea6\u9884\u7b97\u4f59\u989d:{}", (Object)balanceMoney);
            if (balanceMoney.signum() != -1) {
                return;
            }
            log.info("\u5f00\u59cb\u53d1\u90ae\u4ef6\u903b\u8f91");
            ArrayList<Long> receiveUserIds = new ArrayList<Long>();
            PrdOrgOrganizationVO organizationVO = this.orgOrganizationDAO.queryOrgById(planVO.getOrgId());
            if (organizationVO != null && organizationVO.getManageId() != null) {
                receiveUserIds.add(organizationVO.getManageId());
            }
            PrdOrgOrganizationDO orgOrganizationDO = this.orgOrganizationDAO.queryByName("\u5e02\u573a\u90e8");
            receiveUserIds.add(orgOrganizationDO.getManageId());
            String noticeSource = String.join((CharSequence)",", receiveUserIds.stream().map(String::valueOf).collect(Collectors.toList()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("actName", projectName);
            data.put("actTotalMoney", actTotalMoney);
            data.put("planName", planVO.getPlanName());
            data.put("budgetTotalMoney", planDetailDO.getTotalMoney());
            data.put("budgetBalanceMoney", planDetailDO.getTotalMoney().subtract(planDetailDO.getExpenditure()));
            data.put("buName", planVO.getOrgName());
            PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20230208181400");
            this.messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
            log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u90ae\u4ef6\u53d1\u9001\u51fa\u73b0\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public boolean changeManger(Long key, Long userId, Integer opeStatus) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        this.checkUpdate(project);
        Long nUserId = GlobalUtil.getLoginUserId();
        if (project.getCreateUserId() == null || project.getCreateUserId().longValue() != nUserId.longValue()) {
            throw TwException.error("", "\u65e0\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650");
        }
        if (project.getManageUserId().longValue() != userId.longValue()) {
            this.deleteProjectMember(project.getId(), Arrays.asList(project.getManageUserId()));
            this.addProjectMember(project.getId(), Arrays.asList(userId));
            this.projectDAO.updateProjectManger(project.getId(), userId);
        }
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Long update(CrmActActivityPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getId());
        CrmActActivityVO crmActActivityVO = this.dao.queryBykey(payload.getId());
        if (payload.getProjectStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode()) || payload.getDoSave() != null && payload.getDoSave().booleanValue()) {
            if (payload.getDoSave() == null || !payload.getDoSave().booleanValue()) {
                this.checkUpdate(project);
            }
            CrmActPlanDetailDO curPlanDetailDO = this.updatePlan(project, payload);
            this.dao.updateActivityByKeyDynamic(payload);
            this.dao.updateProjectByKeyDynamic(payload, project.getId());
            if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
                this.submitProc(crmActActivityVO);
                CrmActPlanVO planVO = this.daoPlan.queryBykey(payload.getPlanId());
                this.sendEmail(payload.getProjectName(), payload.getTotalMoney(), planVO, curPlanDetailDO);
            }
        } else {
            this.checkUpdate(project);
            this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), (TwCommonPayload)payload, null, null);
            if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
                this.submitChangeProc(crmActActivityVO);
                CrmActPlanVO planVO = this.daoPlan.queryBykey(payload.getPlanId());
                CrmActPlanDetailDO curPlanDetailDO = this.getCurPlanDetailDO(project, payload);
                this.sendEmail(payload.getProjectName(), payload.getTotalMoney(), planVO, curPlanDetailDO);
            }
        }
        if (project.getManageUserId().longValue() != payload.getManageUserId().longValue()) {
            this.deleteProjectMember(project.getId(), Arrays.asList(project.getManageUserId()));
            this.addProjectMember(project.getId(), Arrays.asList(payload.getManageUserId()));
        }
        return 0L;
    }

    public CrmActPlanDetailDO updatePlan(CrmActProjectVO project, CrmActActivityPayload payload) {
        Optional planDetailOptional = this.actPlanDetailRepo.findById(payload.getDetailId());
        if (planDetailOptional.isEmpty()) {
            log.error("\u6839\u636eid{}\u672a\u67e5\u5230\u8ba1\u5212\u660e\u7ec6", (Object)payload.getDetailId());
            throw new BusinessException("\u672a\u67e5\u5230\u8be5\u6d3b\u52a8\u5bf9\u5e94\u7684\u8ba1\u5212\u660e\u7ec6");
        }
        CrmActPlanDetailDO planDetailDO = (CrmActPlanDetailDO)((Object)planDetailOptional.get());
        if (project.getDetailId().longValue() == payload.getDetailId().longValue()) {
            if (payload.getTotalMoney().compareTo(project.getTotalMoney()) != 0) {
                List<CrmActActivityDO> actActivityDOS = this.dao.queryActivityByDetailId(payload.getDetailId());
                BigDecimal totalMoney = new BigDecimal("0");
                for (CrmActActivityDO activityDO : actActivityDOS) {
                    if (activityDO.getId().longValue() == payload.getId().longValue()) continue;
                    totalMoney = totalMoney.add(activityDO.getTotalMoney());
                }
                totalMoney = totalMoney.add(payload.getTotalMoney());
                planDetailDO.setExpenditure(totalMoney);
                this.actPlanDetailRepo.save((Object)planDetailDO);
            }
        } else {
            List<CrmActActivityDO> actActivityDOS = this.dao.queryActivityByDetailId(payload.getDetailId());
            BigDecimal totalMoney = new BigDecimal("0");
            for (CrmActActivityDO activityDO : actActivityDOS) {
                totalMoney = totalMoney.add(activityDO.getTotalMoney());
            }
            totalMoney = totalMoney.add(payload.getTotalMoney());
            planDetailDO.setExpenditure(totalMoney);
            this.actPlanDetailRepo.save((Object)planDetailDO);
            List<CrmActActivityDO> OldActActivityDOS = this.dao.queryActivityByDetailId(project.getDetailId());
            BigDecimal oldTotalMoney = new BigDecimal("0");
            for (CrmActActivityDO activityDO : OldActActivityDOS) {
                if (activityDO.getId().longValue() == payload.getId().longValue()) continue;
                oldTotalMoney = oldTotalMoney.add(activityDO.getTotalMoney());
            }
            this.dao.updatePlanDetail(project.getDetailId(), oldTotalMoney);
        }
        return planDetailDO;
    }

    public CrmActPlanDetailDO getCurPlanDetailDO(CrmActProjectVO project, CrmActActivityPayload payload) {
        Optional planDetailOptional = this.actPlanDetailRepo.findById(payload.getDetailId());
        if (planDetailOptional.isEmpty()) {
            log.error("\u6839\u636eid{}\u672a\u67e5\u5230\u8ba1\u5212\u660e\u7ec6", (Object)payload.getDetailId());
            throw new BusinessException("\u672a\u67e5\u5230\u8be5\u6d3b\u52a8\u5bf9\u5e94\u7684\u8ba1\u5212\u660e\u7ec6");
        }
        CrmActPlanDetailDO planDetailDO = (CrmActPlanDetailDO)((Object)planDetailOptional.get());
        if (project.getDetailId().longValue() == payload.getDetailId().longValue()) {
            if (payload.getTotalMoney().compareTo(project.getTotalMoney()) != 0) {
                List<CrmActActivityDO> actActivityDOS = this.dao.queryActivityByDetailId(payload.getDetailId());
                BigDecimal totalMoney = new BigDecimal("0");
                for (CrmActActivityDO activityDO : actActivityDOS) {
                    if (activityDO.getId().longValue() == payload.getId().longValue()) continue;
                    totalMoney = totalMoney.add(activityDO.getTotalMoney());
                }
                totalMoney = totalMoney.add(payload.getTotalMoney());
                planDetailDO.setExpenditure(totalMoney);
            }
        } else {
            List<CrmActActivityDO> actActivityDOS = this.dao.queryActivityByDetailId(payload.getDetailId());
            BigDecimal totalMoney = new BigDecimal("0");
            for (CrmActActivityDO activityDO : actActivityDOS) {
                totalMoney = totalMoney.add(activityDO.getTotalMoney());
            }
            totalMoney = totalMoney.add(payload.getTotalMoney());
            planDetailDO.setExpenditure(totalMoney);
        }
        return planDetailDO;
    }

    public boolean deleteSoft(List<Long> keys) {
        return false;
    }

    public PagingVO<CrmActActivityVO> paging(CrmActActivityQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> orgManageIds = this.orgOrganizationDAO.queryByManageIdOrgIds(userId);
        List<Object> actUserIds = new ArrayList();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            actUserIds = null;
        } else {
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId);
            if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.orgOrganizationDAO.queryEmployeeList(orgId);
                actUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            } else {
                actUserIds = Collections.singletonList(userId);
            }
        }
        PagingVO<CrmActActivityVO> activityVOPagingVO = this.dao.queryPaging(query, actUserIds, orgManageIds);
        List activityVOS = activityVOPagingVO.getRecords();
        activityVOS.forEach(activityVO -> this.transferSystemSelection((CrmActActivityVO)activityVO));
        return activityVOPagingVO;
    }

    public void downloadActivitys(HttpServletResponse response, CrmActActivityQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmActivityBatch.xlsx");
        PagingVO<CrmActActivityVO> evo = this.paging(query);
        List list = evo.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u5e02\u573a\u6d3b\u52a8");
            if (!CollectionUtils.isEmpty((Collection)list) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmActActivityVO dataPayload : list) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, dataPayload.getProjectNo());
                    this.excelUtil.setCellValue((Row)row, 2, dataPayload.getProjectName());
                    this.excelUtil.setCellValue((Row)row, 3, dataPayload.getPlanName());
                    this.excelUtil.setCellValue((Row)row, 4, dataPayload.getDetailTypeName());
                    this.excelUtil.setCellValue((Row)row, 5, dataPayload.getProjectStatusName());
                    this.excelUtil.setCellValue((Row)row, 6, dataPayload.getManageUserName());
                    this.excelUtil.setCellValue((Row)row, 7, dataPayload.getOrgName());
                    this.excelUtil.setCellValue((Row)row, 8, dataPayload.getStartTime());
                    this.excelUtil.setCellValue((Row)row, 9, dataPayload.getEndTime());
                    this.excelUtil.setCellValue((Row)row, 10, dataPayload.getPlanDetailTotalMoney());
                    this.excelUtil.setCellValue((Row)row, 11, dataPayload.getBalanceMoney());
                    this.excelUtil.setCellValue((Row)row, 12, dataPayload.getTotalMoney());
                    this.excelUtil.setCellValue((Row)row, 13, dataPayload.getActivityScale());
                    this.excelUtil.setCellValue((Row)row, 14, dataPayload.getActivityAddr());
                    this.excelUtil.setCellValue((Row)row, 15, dataPayload.getActivityTarget());
                    this.excelUtil.setCellValue((Row)row, 16, dataPayload.getCreator());
                    this.excelUtil.setCellValue((Row)row, 17, dataPayload.getCreateTime());
                    this.excelUtil.setCellValue((Row)row, 18, dataPayload.getPurchaseMoney());
                    this.excelUtil.setCellValue((Row)row, 19, dataPayload.getClaimMoney());
                    this.excelUtil.setCellValue((Row)row, 20, dataPayload.getSundryMoney());
                    this.excelUtil.setCellValue((Row)row, 21, dataPayload.getBudgetMoney());
                    this.excelUtil.setCellValue((Row)row, 22, dataPayload.getPersonSource());
                    this.excelUtil.setCellValue((Row)row, 23, dataPayload.getPersonNum());
                    this.excelUtil.setCellValue((Row)row, 24, dataPayload.getPersonMoney());
                    this.excelUtil.setCellValue((Row)row, 25, dataPayload.getPotentialCustomer());
                    this.excelUtil.setCellValue((Row)row, 26, dataPayload.getLeadNum());
                    this.excelUtil.setCellValue((Row)row, 27, dataPayload.getBusOps());
                    this.excelUtil.setCellValue((Row)row, 28, dataPayload.getPipeline());
                    ++nextRow;
                }
            }
            String fileName = "\u5e02\u573a\u6d3b\u52a8\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<CrmActProjectVO> queryList(Long planId) {
        return this.dao.queryList(planId);
    }

    public CrmActActivityVO queryByKey(Long key) {
        CrmActActivityVO activityVO = this.dao.queryBykey(key);
        this.transferSystemSelection(activityVO);
        activityVO.setBalanceMoney(activityVO.getPlanDetailTotalMoney().subtract(activityVO.getExpenditure()));
        activityVO.setMemberVOS(this.dao.queryProjectMember(activityVO.getProjectId()));
        List<CrmActDynamicVO> dynamicVOS = this.dao.queryActDynamic(activityVO.getId());
        dynamicVOS.forEach(dynamicVO -> {
            dynamicVO.setDynamicTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType()));
            dynamicVO.setFileDatas(this.fileUtil.getFileDatas(dynamicVO.getFileCodes()));
        });
        activityVO.setDynamicVOS(dynamicVOS);
        activityVO.setFileDatas(this.fileUtil.getFileDatas(activityVO.getFileCodes()));
        return activityVO;
    }

    public List<CrmActDynamicVO> queryDynamicByKey(Long key) {
        List<CrmActDynamicVO> dynamicVOS = this.dao.queryActDynamic(key);
        dynamicVOS.forEach(dynamicVO -> {
            dynamicVO.setDynamicTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType()));
            dynamicVO.setFileDatas(this.fileUtil.getFileDatas(dynamicVO.getFileCodes()));
        });
        return dynamicVOS;
    }

    public List<PrjProjectMemberVO> queryMembersByKey(Long key) {
        CrmActActivityVO activityVO = this.dao.queryBykey(key);
        List<PrjProjectMemberVO> prjProjectMemberVOS = this.dao.queryProjectMember(activityVO.getProjectId());
        return prjProjectMemberVOS;
    }

    public List<CrmActReportVO> queryReportByKey(Long key, Integer reportType) {
        Long activityId = this.dao.queryByReportId(key);
        return this.queryActReportList(activityId, reportType);
    }

    @Transactional
    public boolean changeLockStatus(Long key) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        String status = "";
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            status = WorkFlowStatusEnum.PENDING_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        } else {
            throw TwException.error("", "\u6d3b\u52a8\u72b6\u6001\u4e3a\u6fc0\u6d3b/\u6682\u6302\u624d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        this.dao.updateStatus(project.getId(), status, "");
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u975e\u6fc0\u6d3b\u72b6\u6001\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        ArrayList<Long> nuserIds = new ArrayList<Long>();
        if (project.getCreateUserId() != null) {
            nuserIds.add(project.getCreateUserId());
        }
        if (project.getManageUserId() != null) {
            nuserIds.add(project.getManageUserId());
        }
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        nuserIds.addAll(userIdsByRole);
        Long userId = GlobalUtil.getLoginUserId();
        if (project.getCreateUserId() == null || !nuserIds.contains(userId)) {
            throw TwException.error("", "\u65e0\u6dfb\u52a0\u56e2\u961f\u6210\u5458\u6743\u9650");
        }
        this.addProjectMember(project.getId(), userIds);
        return this.dao.queryProjectMember(project.getId());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void addProjectMember(Long projectId, List<Long> userIds) {
        List<PrjProjectMemberVO> memberVOS = this.dao.queryProjectMember(projectId);
        List<Long> collect = userIds.stream().filter(userId -> memberVOS.stream().noneMatch(memberVO -> memberVO.getUserId().longValue() == userId.longValue())).collect(Collectors.toList());
        List<PrdOrgEmployeeVO> employeeVOS = this.dao.queryEmployee(collect);
        ArrayList<PrjProjectMemberDO> memberDOS = new ArrayList<PrjProjectMemberDO>();
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            PrjProjectMemberDO memberDO = new PrjProjectMemberDO();
            memberDO.setProjectId(projectId);
            memberDO.setUserId(employeeVO.getUserId());
            memberDO.setEmployeeName(employeeVO.getEmployeeName());
            memberDOS.add(memberDO);
        }
        this.projectDAO.saveMemberAll(memberDOS);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteProjectMember(Long projectId, List<Long> userIds) {
        this.projectDAO.deleteMemberByUserId(projectId, userIds);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public boolean deleteMember(Long actId, List<Long> keys) {
        CrmActProjectVO project = this.dao.queryProjectBykey(actId);
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (project.getCreateUserId() != null) {
            userIds.add(project.getCreateUserId());
        }
        if (project.getManageUserId() != null) {
            userIds.add(project.getManageUserId());
        }
        Long userId = GlobalUtil.getLoginUserId();
        if (project.getCreateUserId() == null || !userIds.contains(userId)) {
            throw TwException.error("", "\u65e0\u5220\u9664\u56e2\u961f\u6210\u5458\u6743\u9650");
        }
        List<Long> userMemberIds = this.projectDAO.getUserIds(keys);
        if (userIds.size() > 0 && userIds.contains(userMemberIds.get(0))) {
            throw TwException.error("", "\u521b\u5efa\u4eba\u6216\u8d1f\u8d23\u4eba\u4e0d\u53ef\u5220\u9664");
        }
        this.projectDAO.deleteMemberSoft(keys, userIds);
        return true;
    }

    @Transactional
    public List<CrmActDynamicVO> addDynamic(CrmActDynamicPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getActId());
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u975e\u6fc0\u6d3b\u72b6\u6001\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        List<CrmActDynamicVO> dynamicVOS = this.dao.queryActDynamic(payload.getActId());
        CrmActDynamicDO dynamicDO = CrmActDynamicConvert.INSTANCE.toDo(payload);
        dynamicDO = this.dao.saveDynamic(dynamicDO);
        dynamicVOS.add(CrmActDynamicConvert.INSTANCE.toVo(dynamicDO));
        dynamicVOS.forEach(dynamicVO -> dynamicVO.setDynamicTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType())));
        return dynamicVOS;
    }

    @Transactional
    public boolean updateDynamic(CrmActDynamicPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getActId());
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u975e\u6fc0\u6d3b\u72b6\u6001\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        this.dao.updateDynamic(payload);
        return true;
    }

    public CrmActDynamicVO queryActDynamicDetail(Long key) {
        CrmActDynamicVO dynamicVO = this.dao.queryActDynamicDetail(key);
        dynamicVO.setDynamicTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType()));
        dynamicVO.setFileDatas(this.fileUtil.getFileDatas(dynamicVO.getFileCodes()));
        return dynamicVO;
    }

    @Transactional
    public boolean closeActivity(Long key, String closeReson, String clsoeRemark) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u975e\u6fc0\u6d3b\u72b6\u6001\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        if (closeReson.equals("act_end")) {
            throw TwException.error("", "\u8bf7\u5148\u53d1\u8d77\u6d3b\u52a8\u7ed3\u9879\u62a5\u544a");
        }
        CrmActActivityPayload payload = new CrmActActivityPayload();
        payload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
        payload.setCloseReason(closeReson);
        payload.setClsoeRemark(clsoeRemark);
        this.dao.updateProjectByKeyDynamic(payload, project.getId());
        return true;
    }

    public CrmActReportVO queryActReportData(Long key) {
        CrmLeadsServiceImpl service = (CrmLeadsServiceImpl)((Object)SpringUtil.getBean(CrmLeadsServiceImpl.class));
        CrmPotentialCustomerService customerService = (CrmPotentialCustomerService)SpringUtil.getBean(CrmPotentialCustomerService.class);
        CrmActReportVO reportVO = this.dao.queryActReportData(key);
        Integer marketLeadsNum = service.countMarketLeads(reportVO.getProjectId());
        reportVO.setProjectStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), reportVO.getProjectStatus()));
        reportVO.setLeadNum(marketLeadsNum);
        reportVO.setBusOps(Integer.valueOf((int)this.dao.queryOppoCount(reportVO.getProjectId())));
        reportVO.setLeadsFollowPercent(service.countMarketLeadsFollowPercent(marketLeadsNum, reportVO.getProjectId()));
        reportVO.setLeadsBackPercent(service.countMarketLeadsBackPercent(reportVO.getProjectId()));
        reportVO.setPotentialCustomer(Integer.valueOf((int)customerService.countByActivityId(reportVO.getProjectId())));
        return reportVO;
    }

    @Transactional
    public CrmActReportVO addReport(CrmActReportPayload payload) {
        String code = this.generateSeqNum("ACT_REPORT_NO", new String[0]);
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getActId());
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u975e\u6fc0\u6d3b\u72b6\u6001\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        CrmActReportDO reportDO = CrmActReportConvert.INSTANCE.toDo(payload);
        reportDO.setReportNo(code);
        if (reportDO.getReportType() == 2) {
            this.transactionTemplate.setPropagationBehavior(3);
            CrmActReportDO finalReportDO = reportDO;
            this.transactionTemplate.execute(transactionStatus -> {
                this.dao.saveReport(finalReportDO);
                return null;
            });
            CrmActReportVO crmActReportVO = CrmActReportConvert.INSTANCE.toVo(reportDO);
            this.submitReportProc(crmActReportVO);
        } else {
            reportDO = this.dao.saveReport(reportDO);
        }
        return CrmActReportConvert.INSTANCE.toVo(reportDO);
    }

    public List<CrmActReportVO> queryActReportList(Long actId, Integer reportType) {
        List<CrmActReportVO> reportVOS = this.dao.queryActReportList(actId, reportType);
        reportVOS.forEach(reportVO -> reportVO.setReportStatusDesc(WorkFlowStatusEnum.getByCode(reportVO.getReportStatus()) == null ? "" : WorkFlowStatusEnum.getByCode(reportVO.getReportStatus()).getDesc()));
        return reportVOS;
    }

    public CrmActReportVO queryActReportDetail(Long key) {
        CrmActReportVO reportVO = this.dao.queryActReportDetail(key);
        reportVO.setProjectStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), reportVO.getProjectStatus()));
        return reportVO;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void updateWorkFlowStatus(Long projectId, String status, String procInstId) {
        this.dao.updateStatus(projectId, status, procInstId);
    }

    public Object changeLogList(Long activityId) {
        List result = this.changeService.getChangeLogList(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), activityId.toString());
        for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : result) {
            prdSystemBusinessChangeVO.setCreateUserName(this.cacheUtil.getUserName(prdSystemBusinessChangeVO.getCreateUserId()));
        }
        return result;
    }

    public Map<String, Object> changeLogDetailByActivityId(Long activityId) {
        Long currentVersionId = this.changeService.getCurrentVersionId(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), activityId.toString());
        Map changeLogDetail = this.changeService.getChangeLogDetail(currentVersionId, null);
        return changeLogDetail;
    }

    void checkUpdate(CrmActProjectVO project) {
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error("", "\u8be5\u6d3b\u52a8\u5df2\u6682\u6302");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error("", "\u6b63\u5728\u5ba1\u6279\u4e2d\u3002\u3002\u3002");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "\u6d3b\u52a8\u5df2\u5173\u95ed");
        }
    }

    void transferSystemSelection(CrmActActivityVO vo) {
        vo.setManageUserName(this.cacheUtil.getUserName(vo.getManageUserId()));
        vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
        vo.setBudgetMoney(vo.getTotalMoney().subtract(vo.getPersonMoney()));
        vo.setProjectStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getProjectStatus()));
        vo.setDetailTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), vo.getDetailType()));
        vo.setCompanyName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeCompany.getCode(), "" + vo.getCompanyId()));
    }

    private void submitProc(CrmActActivityVO crmActActivityVO) {
        PrjProjectVO prjProjectVO = this.projectDAO.queryByKey(crmActActivityVO.getProjectId());
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
            Long strategicCenterUserId = this.daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = this.daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = crmActActivityVO.getOrgId();
            Long actOrgManageUserId = null;
            PrdOrgOrganizationVO pvo = this.daoOrg.queryParentOrgById(orgId);
            actOrgManageUserId = pvo != null && pvo.getOrgName().equals("\u9500\u552e\u7ba1\u7406\u4e2d\u5fc3") ? this.daoOrg.queryManageIdById(pvo.getId()) : this.daoOrg.queryManageIdById(orgId);
            variables.put("Activity_1p6ou0f", CollUtil.newArrayList((Object[])new String[]{actOrgManageUserId.toString()}));
            variables.put("Activity_0yu9h7j", CollUtil.newArrayList((Object[])new String[]{strategicCenterUserId.toString()}));
            variables.put("Activity_1fzxus6", CollUtil.newArrayList((Object[])new String[]{marketManageUserId.toString()}));
            BigDecimal purchaseMoney = crmActActivityVO.getPurchaseMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getPurchaseMoney();
            BigDecimal sundryMoney = crmActActivityVO.getSundryMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getSundryMoney();
            BigDecimal claimMoney = crmActActivityVO.getClaimMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getClaimMoney();
            BigDecimal add = purchaseMoney.add(sundryMoney).add(claimMoney);
            variables.put("haveBudget", Boolean.valueOf(add.compareTo(BigDecimal.ZERO) == 1));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.MARKET_ACTIVITY.name(), (String)(prjProjectVO.getProjectName() + "-\u5e02\u573a\u6d3b\u52a8\u5ba1\u6279\u6d41\u7a0b"), (String)("" + crmActActivityVO.getId()), variables), new Long[0]);
        }
        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
        activityPayload.setProcInstId(processInfo.getProcInstId());
        activityPayload.setId(crmActActivityVO.getId());
        activityPayload.setProcInstStatus(processInfo.getProcInstStatus());
        activityPayload.setSubmitTime(LocalDateTime.now());
        activityPayload.setProcDefKey(ProcDefKey.MARKET_ACTIVITY.name());
        this.updateWorkFlowStatus(crmActActivityVO.getProjectId(), status, "");
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateActivityByKeyDynamic(activityPayload));
    }

    private void submitReportProc(CrmActReportVO crmActReportVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
            Long marketManageUserId = this.daoOrg.queryManageIdByCode("P1MKT");
            variables.put("Activity_17yato4", CollUtil.newArrayList((Object[])new String[]{marketManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.MARKET_END_REPORT.name(), (String)(crmActReportVO.getProjectName() + "-\u5e02\u573a\u6d3b\u52a8\u7ed3\u9879\u62a5\u544a\u5ba1\u6279\u6d41\u7a0b"), (String)("" + crmActReportVO.getId()), variables), new Long[0]);
        }
        CrmActReportPayload reportPayload = new CrmActReportPayload();
        reportPayload.setProcInstId(processInfo.getProcInstId());
        reportPayload.setId(crmActReportVO.getId());
        reportPayload.setProcInstStatus(processInfo.getProcInstStatus());
        reportPayload.setSubmitTime(LocalDateTime.now());
        reportPayload.setReportStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateReportyKeyDynamic(reportPayload));
    }

    private void submitChangeProc(CrmActActivityVO crmActActivityVO) {
        PrjProjectVO prjProjectVO = this.projectDAO.queryByKey(crmActActivityVO.getProjectId());
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
            Long strategicCenterUserId = this.daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = this.daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = crmActActivityVO.getOrgId();
            Long actOrgManageUserId = null;
            PrdOrgOrganizationVO pvo = this.daoOrg.queryParentOrgById(orgId);
            actOrgManageUserId = pvo != null && pvo.getOrgName().equals("\u9500\u552e\u7ba1\u7406\u4e2d\u5fc3") ? this.daoOrg.queryManageIdById(pvo.getId()) : this.daoOrg.queryManageIdById(orgId);
            variables.put("Activity_1x8di82", CollUtil.newArrayList((Object[])new String[]{actOrgManageUserId.toString()}));
            variables.put("Activity_1n8w14o", CollUtil.newArrayList((Object[])new String[]{strategicCenterUserId.toString()}));
            variables.put("Activity_1re8zas", CollUtil.newArrayList((Object[])new String[]{marketManageUserId.toString()}));
            BigDecimal purchaseMoney = crmActActivityVO.getPurchaseMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getPurchaseMoney();
            BigDecimal sundryMoney = crmActActivityVO.getSundryMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getSundryMoney();
            BigDecimal claimMoney = crmActActivityVO.getClaimMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getClaimMoney();
            BigDecimal add = purchaseMoney.add(sundryMoney).add(claimMoney);
            variables.put("haveBudget", Boolean.valueOf(add.compareTo(BigDecimal.ZERO) == 1));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.MARKET_ACTIVITY_C.name(), (String)(prjProjectVO.getProjectName() + "-\u5e02\u573a\u6d3b\u52a8\u53d8\u66f4\u6d41\u7a0b"), (String)("" + crmActActivityVO.getId()), variables), new Long[0]);
        }
        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
        activityPayload.setProcInstId(processInfo.getProcInstId());
        activityPayload.setId(crmActActivityVO.getId());
        activityPayload.setProcInstStatus(processInfo.getProcInstStatus());
        activityPayload.setSubmitTime(LocalDateTime.now());
        activityPayload.setProcDefKey(ProcDefKey.MARKET_ACTIVITY_C.name());
        this.updateWorkFlowStatus(crmActActivityVO.getProjectId(), status, "");
        List changeLogList = this.changeService.getChangeLogList(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
        if (changeLogList != null && !changeLogList.isEmpty()) {
            PrdSystemBusinessChangeVO initVersion = new PrdSystemBusinessChangeVO();
            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeLogList) {
                if (prdSystemBusinessChangeVO.getVersionNo() != 0) continue;
                initVersion = prdSystemBusinessChangeVO;
            }
            String versionContent = initVersion.getVersionContent();
            JSONObject versionContentMap = JSON.parseObject((String)versionContent);
            versionContentMap.put("procInsId", processInfo.getProcInstId());
            versionContentMap.put("procInstStatus", processInfo.getProcInstStatus());
            versionContentMap.put("procDefKey", ProcDefKey.MARKET_ACTIVITY_C.name());
            versionContent = JSON.toJSONString((Object)versionContentMap);
            PrdSystemBusinessChangePayload changePayload = new PrdSystemBusinessChangePayload();
            changePayload.setVersionContent(versionContent);
            changePayload.setId(initVersion.getId());
            this.changeDAO.updateByKeyDynamic(changePayload);
        }
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateActivityByKeyDynamic(activityPayload));
    }

    public List<CrmActActivityVO> queryListDynamic(CrmActActivityQuery query) {
        return this.dao.queryList(query);
    }

    public void updateSchedule(Long id, Long scheduleId) {
        this.dao.updateSchedule(id, scheduleId);
    }

    public CrmActActivityServiceImpl(CacheUtil cacheUtil, PrjProjectDAO projectDAO, CrmActActivityDAO dao, PrdSystemRoleDAO daoRole, PrdOrgEmployeeDAO employeeDAO, PrdOrgOrganizationDAO orgOrganizationDAO, CrmActPlanDAO daoPlan, FileUtil fileUtil, ExcelUtil excelUtil, PrdSystemRoleDAO systemRoleDAO, TransactionTemplate transactionTemplate, PrdOrgOrganizationDAO daoOrg, TransactionUtilService transactionUtilService, PrdSystemBusinessChangeService changeService, PrdSystemBusinessChangeDAO changeDAO, PrdMessageConfigService messageConfigService, PrdMessageConfigRepo repoMessage, WorkflowUtil workflowUtil, CrmActPlanDetailRepo actPlanDetailRepo) {
        this.cacheUtil = cacheUtil;
        this.projectDAO = projectDAO;
        this.dao = dao;
        this.daoRole = daoRole;
        this.employeeDAO = employeeDAO;
        this.orgOrganizationDAO = orgOrganizationDAO;
        this.daoPlan = daoPlan;
        this.fileUtil = fileUtil;
        this.excelUtil = excelUtil;
        this.systemRoleDAO = systemRoleDAO;
        this.transactionTemplate = transactionTemplate;
        this.daoOrg = daoOrg;
        this.transactionUtilService = transactionUtilService;
        this.changeService = changeService;
        this.changeDAO = changeDAO;
        this.messageConfigService = messageConfigService;
        this.repoMessage = repoMessage;
        this.workflowUtil = workflowUtil;
        this.actPlanDetailRepo = actPlanDetailRepo;
    }
}

