/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftListPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftListQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmGiftInfoService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmGiftListService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmGiftListVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmGiftListConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmGiftListDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmGiftListDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmGiftListRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class CrmGiftListServiceImpl
extends BaseServiceImpl
implements CrmGiftListService {
    private static final Logger log = LoggerFactory.getLogger(CrmGiftListServiceImpl.class);
    private final CrmGiftListRepo crmGiftListRepo;
    private final CrmGiftListDAO crmGiftListDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO daoOrg;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final CacheUtil cacheUtil;
    private final CrmGiftInfoService crmGiftInfoService;

    public PagingVO<CrmGiftListVO> queryPaging(CrmGiftListQuery query) {
        return this.crmGiftListDAO.queryPaging(query);
    }

    public List<CrmGiftListVO> queryListDynamic(CrmGiftListQuery query) {
        return this.crmGiftListDAO.queryListDynamic(query);
    }

    public CrmGiftListVO queryByKey(Long key) {
        CrmGiftListDO entity = this.crmGiftListRepo.findById(key).orElseGet(CrmGiftListDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmGiftListVO vo = CrmGiftListConvert.INSTANCE.toVo(entity);
        this.transferDatas(vo);
        return vo;
    }

    public List<PrdOrgEmployeeVO> queryUserByGiftRole() {
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.GIFT_REQUEST_SPECIAL_USER.getCode(), RoleEnum.GIFT_APPLY_QUERY_ALL.getCode(), RoleEnum.SALE_RES.getCode()));
        if (ObjectUtils.isEmpty(userIdsByRole)) {
            return new ArrayList<PrdOrgEmployeeVO>();
        }
        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
        query.setUserIds(userIdsByRole);
        return this.employeeDAO.queryList(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmGiftListVO insert(CrmGiftListPayload payload) {
        this.checkData(payload);
        int specialUsersFlag = this.checkRole(payload.getApplyUserId());
        payload.setSpecialUsersFlag(Integer.valueOf(specialUsersFlag));
        CrmGiftListDO entityDo = CrmGiftListConvert.INSTANCE.toDo(payload);
        CrmGiftListVO vo = CrmGiftListConvert.INSTANCE.toVo((CrmGiftListDO)this.crmGiftListRepo.save(entityDo));
        List crmGiftInfoPayloads = payload.getCrmGiftInfoPayloads();
        crmGiftInfoPayloads.forEach(v -> {
            v.setGiftListId(vo.getId());
            v.setSpecialUsersFlag(payload.getSpecialUsersFlag());
        });
        this.crmGiftInfoService.batchInsert(crmGiftInfoPayloads);
        if (payload.getSubmitFlag().booleanValue()) {
            this.submitProc(vo, payload.getApplyUserBuId());
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmGiftListVO create() {
        Long loginUserId = GlobalUtil.getLoginUserId();
        Long createUserBuId = this.cacheUtil.getDefaultOrgIdByUserId(loginUserId);
        CrmGiftListVO vo = new CrmGiftListVO();
        vo.setGiftNo(this.generateSeqNum("GIFT_ACTIVITY", new String[0]));
        vo.setCreateUserId(loginUserId);
        vo.setCreator(this.cacheUtil.getUserName(loginUserId));
        vo.setCreateUserBuId(createUserBuId);
        vo.setCreateTime(LocalDateTime.now());
        vo.setApplyStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        this.transferDatas(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CrmGiftListPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            throw TwException.error("", "\u793c\u54c1\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        this.checkData(payload);
        int specialUsersFlag = this.checkRole(payload.getApplyUserId());
        payload.setSpecialUsersFlag(Integer.valueOf(specialUsersFlag));
        CrmGiftListDO entity = this.crmGiftListRepo.findById(payload.getId()).orElseGet(CrmGiftListDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (!loginUserId.equals(entity.getCreateUserId()) && !loginUserId.equals(entity.getApplyUserId())) {
            throw TwException.error("", "\u975e\u521b\u5efa\u4eba\u548c\u63d0\u4ea4\u4eba \u4e0d\u80fd\u66f4\u6539\u793c\u54c1\u5355");
        }
        long result = this.crmGiftListDAO.updateByKeyDynamic(payload);
        List crmGiftInfoPayloads = payload.getCrmGiftInfoPayloads();
        crmGiftInfoPayloads.forEach(v -> {
            v.setGiftListId(payload.getId());
            v.setSpecialUsersFlag(payload.getSpecialUsersFlag());
        });
        this.crmGiftInfoService.batchUpdate(crmGiftInfoPayloads);
        if (payload.getSubmitFlag().booleanValue()) {
            if (ObjectUtils.isEmpty((Object)entity.getProcInstId())) {
                this.submitProc(CrmGiftListConvert.INSTANCE.toVo(entity), payload.getApplyUserBuId());
            } else {
                payload.setApplyStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                this.crmGiftListDAO.updateByKeyDynamic(payload);
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.crmGiftListDAO.deleteSoft(keys);
        }
    }

    private void submitProc(CrmGiftListVO vo, Long applyUserBuId) {
        HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(vo.getApplyUserId());
        if (prdOrgEmployeeRefVO == null) {
            throw TwException.error("", "\u5458\u5de5\u4fe1\u606f\u67e5\u4e0d\u5230");
        }
        Long parentId = prdOrgEmployeeRefVO.getParentId();
        if (ObjectUtils.isEmpty((Object)parentId)) {
            throw TwException.error("", "\u76f4\u5c5e\u4e0a\u7ea7 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        variables.put("Activity_0i6loqz", CollUtil.newArrayList((Object[])new String[]{parentId.toString()}));
        Long buManageUserId = this.daoOrg.queryManageIdById(applyUserBuId);
        if (ObjectUtils.isEmpty((Object)buManageUserId)) {
            throw TwException.error("", "BU\u8d1f\u8d23\u4eba \u4e0d\u80fd\u4e3a\u7a7a");
        }
        variables.put("Activity_1dg4bha", CollUtil.newArrayList((Object[])new String[]{buManageUserId.toString()}));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.GIFT_SUBMIT.name(), (String)("\u793c\u54c1\u7533\u8bf7\u6d41\u7a0b-" + vo.getGiftNo()), (String)("" + vo.getId()), variables), new Long[0]);
        CrmGiftListPayload payload = new CrmGiftListPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(vo.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setApplyDate(LocalDate.now());
        payload.setApplyStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        this.crmGiftListDAO.updateByKeyDynamic(payload);
    }

    void transferDatas(CrmGiftListVO vo) {
        vo.setGiftTypeName1(this.cacheUtil.transferSystemSelection("GIFT_TYPE", vo.getGiftType1()));
        vo.setGiftTypeName2(this.cacheUtil.transferSystemSelection("GIFT_TYPE:Festival", vo.getGiftType2()));
        vo.setApplyStatusName(this.cacheUtil.transferSystemSelection("gift:status", vo.getApplyStatus()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    private void checkData(CrmGiftListPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getGiftType1())) {
            throw TwException.error("", "\u793c\u54c1\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getApplyUserId())) {
            throw TwException.error("", "\u7533\u8bf7\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
        }
        payload.setApplyUserBuId(this.cacheUtil.getDefaultOrgIdByUserId(payload.getApplyUserId()));
        List crmGiftInfoPayloads = payload.getCrmGiftInfoPayloads();
        if (ObjectUtils.isEmpty((Object)crmGiftInfoPayloads)) {
            throw TwException.error("", "\u8bf7\u5148\u7ef4\u62a4\u793c\u54c1\u4fe1\u606f");
        }
    }

    private int checkRole(Long loginUserId) {
        List<String> roleCodes = this.systemRoleDAO.queryUserRoleCodes(loginUserId);
        if (!(roleCodes.contains(RoleEnum.GIFT_REQUEST_SPECIAL_USER.getCode()) || roleCodes.contains(RoleEnum.GIFT_APPLY_QUERY_ALL.getCode()) || roleCodes.contains(RoleEnum.SALE_RES.getCode()))) {
            throw TwException.error("", "\u4f60\u6682\u65e0\u6743\u9650");
        }
        return roleCodes.contains(RoleEnum.GIFT_REQUEST_SPECIAL_USER.getCode()) ? 1 : 0;
    }

    public CrmGiftListServiceImpl(CrmGiftListRepo crmGiftListRepo, CrmGiftListDAO crmGiftListDAO, PrdOrgEmployeeDAO employeeDAO, PrdOrgOrganizationDAO daoOrg, WorkflowUtil workflowUtil, PrdSystemRoleDAO systemRoleDAO, CacheUtil cacheUtil, CrmGiftInfoService crmGiftInfoService) {
        this.crmGiftListRepo = crmGiftListRepo;
        this.crmGiftListDAO = crmGiftListDAO;
        this.employeeDAO = employeeDAO;
        this.daoOrg = daoOrg;
        this.workflowUtil = workflowUtil;
        this.systemRoleDAO = systemRoleDAO;
        this.cacheUtil = cacheUtil;
        this.crmGiftInfoService = crmGiftInfoService;
    }
}

