/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaAdminPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpenseaService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpenseaConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpenseaDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrmOpenseaServiceImpl
implements CrmOpenseaService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpenseaServiceImpl.class);
    private final CrmOpenseaDAO dao;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;

    public CrmOpenseaVO saveOne(CrmOpenseaPayload payload) {
        CrmOpenseaDO ado = CrmOpenseaConvert.INSTANCE.toDo(payload);
        try {
            ado = this.dao.save(ado);
        }
        catch (Exception e) {
            throw TwException.error("", "\u516c\u6d77\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        return CrmOpenseaConvert.INSTANCE.toVo(ado);
    }

    public List<CrmOpenseaListVO> queryListMy() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0L : userDetails.getUser().getId();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        CrmOpenseaQuery query = new CrmOpenseaQuery();
        if (userIdsByRole == null || userIdsByRole.isEmpty() || !userIdsByRole.contains(userId)) {
            query.setOpenseaAdminId(userId);
        }
        return this.queryList(query);
    }

    public List<CrmOpenseaListVO> queryList(CrmOpenseaQuery query) {
        Specification<CrmOpenseaDO> spec = this.dao.getSpec(query);
        List<CrmOpenseaDO> all = this.dao.findAll(spec);
        return all.stream().map(e -> CrmOpenseaConvert.INSTANCE.toListVo((CrmOpenseaDO)((Object)e))).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public PagingVO<CrmOpenseaListVO> paging(CrmOpenseaQuery query) {
        Specification<CrmOpenseaDO> spec = this.dao.getSpec(query);
        Page<CrmOpenseaDO> all = this.dao.findAll(spec, (Pageable)query.getPageRequest());
        List content = all.getContent();
        List<CrmOpenseaListVO> collect = content.stream().map(e -> CrmOpenseaConvert.INSTANCE.toListVo((CrmOpenseaDO)((Object)e))).collect(Collectors.toList());
        this.transferList(collect);
        all.getTotalPages();
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    @Transactional
    public CrmOpenseaVO queryDetail(Long id) {
        CrmOpenseaDO detail = this.dao.queryById(id);
        CrmOpenseaVO crmOpenseaVO = CrmOpenseaConvert.INSTANCE.toVo(detail);
        this.transferDetail(Collections.singletonList(crmOpenseaVO));
        return crmOpenseaVO;
    }

    public void dynamicUpdate(CrmOpenseaPayload payload) {
        this.dao.updateByKeyDynamic(payload);
    }

    private void transferList(List<CrmOpenseaListVO> list) {
        for (CrmOpenseaListVO vo : list) {
            if (ObjectUtils.isEmpty((Object)vo.getCreateUserId())) continue;
            vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
        }
    }

    private void transferDetail(List<CrmOpenseaVO> list) {
        for (CrmOpenseaVO vo : list) {
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            List openseaAdmins = vo.getOpenseaAdmins();
            List openseaMembers = vo.getOpenseaMembers();
            openseaMembers.stream().map(e -> {
                e.setUserName(this.cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
            openseaAdmins.stream().map(e -> {
                e.setUserName(this.cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
        }
    }

    @Transactional
    public void importOpensea(MultipartFile file) {
        int dataStartRow;
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error(e2.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u516c\u6d77\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        for (int i = dataStartRow = 1; i <= sheet.getLastRowNum(); ++i) {
            List<Long> collect;
            Row row = sheet.getRow(i);
            CrmOpenseaPayload openseaPayload = new CrmOpenseaPayload();
            List<Object> membersPayloads = new ArrayList();
            List<Object> adminPayloads = new ArrayList();
            openseaPayload.setOpenseaName(ExcelUtil.getCellFormatValue(row.getCell(1)));
            String offshoreMembersStr = ExcelUtil.getCellFormatValue(row.getCell(2));
            String offshoreAdminsStr = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText((String)offshoreMembersStr)) {
                String[] members = offshoreMembersStr.split(",");
                collect = Arrays.stream(members).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> memberUserIds = this.employeeDAO.queryUserIdByEmployeeNo(collect);
                membersPayloads = memberUserIds.stream().map(e -> {
                    CrmOpenseaMembersPayload membersPayload = new CrmOpenseaMembersPayload();
                    membersPayload.setUserId(e);
                    return membersPayload;
                }).collect(Collectors.toList());
                openseaPayload.setOpenseaMembers(membersPayloads);
            }
            if (StringUtils.hasText((String)offshoreAdminsStr)) {
                String[] admins = offshoreAdminsStr.split(",");
                collect = Arrays.stream(admins).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> adminUserIds = this.employeeDAO.queryUserIdByEmployeeNo(collect);
                adminPayloads = adminUserIds.stream().map(e -> {
                    CrmOpenseaAdminPayload adminPayload = new CrmOpenseaAdminPayload();
                    adminPayload.setUserId(e);
                    return adminPayload;
                }).collect(Collectors.toList());
                openseaPayload.setOpenseaAdmins(adminPayloads);
            }
            this.saveOne(openseaPayload);
        }
    }

    public void downloadOpensea(HttpServletResponse response, CrmOpenseaQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/openseaBatch.xlsx");
        PagingVO<CrmOpenseaListVO> paging = this.paging(query);
        List records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u516c\u6d77\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)records) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmOpenseaListVO dataPayload : records) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, dataPayload.getOpenseaName());
                    this.excelUtil.setCellValue((Row)row, 3, dataPayload.getCustomerNum());
                    ++nextRow;
                }
            }
            String fileName = "\u8fd1\u6d77\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CrmOpenseaServiceImpl(CrmOpenseaDAO dao, CrmPotentialCustomerDAO potentialCustomerDAO, CacheUtil cacheUtil, PrdOrgEmployeeDAO employeeDAO, ExcelUtil excelUtil, PrdSystemRoleDAO systemRoleDAO) {
        this.dao = dao;
        this.potentialCustomerDAO = potentialCustomerDAO;
        this.cacheUtil = cacheUtil;
        this.employeeDAO = employeeDAO;
        this.excelUtil = excelUtil;
        this.systemRoleDAO = systemRoleDAO;
    }
}

