/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityCompetitorPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityCompetitorService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityCompetitorVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityCompetitorConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityCompetitorDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityCompetitorDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmOpportunityCompetitorServiceImpl
implements CrmOpportunityCompetitorService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityCompetitorServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmOpportunityCompetitorDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityDAO opportunityDAO;
    @Value(value="${tw4.opportunity.competitor_operation}")
    private String competitor_operation;
    @Value(value="${tw4.opportunity.competitor_del}")
    private String competitor_del;

    @Transactional
    public CrmOpportunityCompetitorVO insert(CrmOpportunityCompetitorPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getCompeIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getCompeIdV4()));
        }
        CrmOpportunityCompetitorDO ado = CrmOpportunityCompetitorConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "\u7ade\u4e89\u5bf9\u624b");
        return CrmOpportunityCompetitorConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(CrmOpportunityCompetitorPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getCompeIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getCompeIdV4()));
        }
        CrmOpportunityCompetitorDO ado = CrmOpportunityCompetitorConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "\u7ade\u4e89\u5bf9\u624b");
        return 0L;
    }

    public List<CrmOpportunityCompetitorVO> queryList(Long oppoId) {
        return this.dao.queryList(oppoId);
    }

    @Transactional
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "\u7ade\u4e89\u5bf9\u624b");
        return true;
    }

    public CrmOpportunityCompetitorServiceImpl(CacheUtil cacheUtil, CrmOpportunityCompetitorDAO dao, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, CrmOpportunityDAO opportunityDAO) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.opportunityDAO = opportunityDAO;
    }
}

