/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.recommended.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdRecruitPositionPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdRecruitPositionQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdRecruitPositionService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdRecruitPositionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.convert.PrdRecruitPositionConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.dao.PrdRecruitPositionDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.PrdRecruitPositionDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.repo.PrdRecruitPositionRepo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PrdRecruitPositionServiceImpl
extends BaseServiceImpl
implements PrdRecruitPositionService {
    private static final Logger log = LoggerFactory.getLogger(PrdRecruitPositionServiceImpl.class);
    private final PrdRecruitPositionRepo prdRecruitPositionRepo;
    private final PrdRecruitPositionDAO prdRecruitPositionDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<PrdRecruitPositionVO> queryPaging(PrdRecruitPositionQuery query) {
        PagingVO<PrdRecruitPositionVO> res = this.prdRecruitPositionDAO.queryPaging(query);
        res.getRecords().forEach(x -> {
            x.setJobType1Desc(this.cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType1()));
            x.setJobType2Desc(this.cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType2()));
            x.setBaseRegionName(this.cacheUtil.transferSystemSelection("SYSTEM_BASIC:PCD", x.getBaseRegion()));
            x.setBaseBuName(this.cacheUtil.getOrgName(x.getBaseBuId()));
            x.setManagerUserName(this.cacheUtil.getUserName(x.getManagerUserId()));
        });
        return res;
    }

    public List<PrdRecruitPositionVO> queryListDynamic(PrdRecruitPositionQuery query) {
        return this.prdRecruitPositionDAO.queryListDynamic(query);
    }

    public PrdRecruitPositionVO queryByKey(Long key) {
        PrdRecruitPositionDO entity = this.prdRecruitPositionRepo.findById(key).orElseGet(PrdRecruitPositionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdRecruitPositionVO x = PrdRecruitPositionConvert.INSTANCE.toVo(entity);
        x.setJobType1Desc(this.cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType1()));
        x.setJobType2Desc(this.cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType2()));
        x.setBaseRegionName(this.cacheUtil.transferSystemSelection("SYSTEM_BASIC:PCD", x.getBaseRegion()));
        x.setBaseBuName(this.cacheUtil.getOrgName(x.getBaseBuId()));
        x.setManagerUserName(this.cacheUtil.getUserName(x.getManagerUserId()));
        return x;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdRecruitPositionVO insert(PrdRecruitPositionPayload payload) {
        this.checkData(payload);
        payload.setJobNo(this.generateSeqNum("INTEEIOR_RECOMMEND_NO", new String[0]));
        PrdRecruitPositionDO entityDo = PrdRecruitPositionConvert.INSTANCE.toDo(payload);
        return PrdRecruitPositionConvert.INSTANCE.toVo((PrdRecruitPositionDO)this.prdRecruitPositionRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdRecruitPositionVO update(PrdRecruitPositionPayload payload) {
        this.checkData(payload);
        PrdRecruitPositionDO entity = this.prdRecruitPositionRepo.findById(payload.getId()).orElseGet(PrdRecruitPositionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdRecruitPositionDO entityDo = PrdRecruitPositionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdRecruitPositionConvert.INSTANCE.toVo((PrdRecruitPositionDO)this.prdRecruitPositionRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PrdRecruitPositionPayload payload) {
        PrdRecruitPositionDO entity = this.prdRecruitPositionRepo.findById(payload.getId()).orElseGet(PrdRecruitPositionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.prdRecruitPositionDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdRecruitPositionDAO.deleteSoft(keys);
        }
    }

    private void checkData(PrdRecruitPositionPayload prdRecruitPositionPayload) {
        if (StringUtils.isBlank((CharSequence)prdRecruitPositionPayload.getJobTitle())) {
            throw new BusinessException("\u5c97\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdRecruitPositionPayload.getBaseBuId().toString())) {
            throw new BusinessException("\u62db\u8058\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdRecruitPositionPayload.getJobType1())) {
            throw new BusinessException("\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdRecruitPositionPayload.getRecruitQty().toString())) {
            throw new BusinessException("\u62db\u8058\u4eba\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (prdRecruitPositionPayload.getInternalFlag() == null) {
            throw new BusinessException("\u5185\u90e8\u63a8\u8350\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (prdRecruitPositionPayload.getExternalVisible() == null) {
            throw new BusinessException("\u5916\u90e8\u8d44\u6e90\u53ef\u89c1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (prdRecruitPositionPayload.getRecruitmentStatus() == null) {
            throw new BusinessException("\u62db\u8058\u72b6\u6001\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PrdRecruitPositionServiceImpl(PrdRecruitPositionRepo prdRecruitPositionRepo, PrdRecruitPositionDAO prdRecruitPositionDAO, CacheUtil cacheUtil) {
        this.prdRecruitPositionRepo = prdRecruitPositionRepo;
        this.prdRecruitPositionDAO = prdRecruitPositionDAO;
        this.cacheUtil = cacheUtil;
    }
}

