/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResPortrayalEvalConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateDtlVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEvalScoreVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEvaluateDtlVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEvaluateVO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResPortrayalEvalConfigDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResPortrayalEvalConfigDO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ResEvaluateServiceImpl
implements ResEvaluateService {
    private static final Logger log = LoggerFactory.getLogger(ResEvaluateServiceImpl.class);
    private final PrdEvaluateService prdEvaluateService;
    private final ResPortrayalEvalConfigDAO resPortrayalEvalConfigDAO;

    public ResEvaluateVO getResEvaluateScore(Long userId) {
        ResEvalScoreVO resEvalScoreVO;
        PrdEvaluateQuery prdEvaluateQuery = new PrdEvaluateQuery();
        prdEvaluateQuery.setToEvalUserId(userId);
        List prdEvaluateVOList = this.prdEvaluateService.getList(prdEvaluateQuery);
        if (prdEvaluateVOList == null) {
            return null;
        }
        HashMap<Long, ResEvalScoreVO> evaluateMap = new HashMap<Long, ResEvalScoreVO>();
        for (PrdEvaluateVO prdEvaluateVO : prdEvaluateVOList) {
            List prdEvaluateDtlVOList = prdEvaluateVO.getPrdEvaluateDtlVOList();
            if (prdEvaluateDtlVOList == null || prdEvaluateDtlVOList.size() <= 0) continue;
            for (PrdEvaluateDtlVO prdEvaluateDtlVO : prdEvaluateDtlVOList) {
                if (evaluateMap.containsKey(prdEvaluateDtlVO.getPointId())) {
                    resEvalScoreVO = (ResEvalScoreVO)evaluateMap.get(prdEvaluateDtlVO.getPointId());
                    BigDecimal totalScore = resEvalScoreVO.getTotalScore().add(prdEvaluateDtlVO.getScore());
                    Long size = resEvalScoreVO.getSize() + 1L;
                    ResEvalScoreVO newResEvalScoreVO = new ResEvalScoreVO();
                    newResEvalScoreVO.setTotalScore(totalScore);
                    newResEvalScoreVO.setSize(size);
                    newResEvalScoreVO.setPointId(prdEvaluateDtlVO.getPointId());
                    newResEvalScoreVO.setPointName(prdEvaluateDtlVO.getPointName());
                    evaluateMap.put(prdEvaluateDtlVO.getPointId(), newResEvalScoreVO);
                    continue;
                }
                BigDecimal totalScore = prdEvaluateDtlVO.getScore();
                Long size = 1L;
                ResEvalScoreVO newResEvalScoreVO = new ResEvalScoreVO();
                newResEvalScoreVO.setTotalScore(totalScore);
                newResEvalScoreVO.setSize(size);
                newResEvalScoreVO.setPointId(prdEvaluateDtlVO.getPointId());
                newResEvalScoreVO.setPointName(prdEvaluateDtlVO.getPointName());
                evaluateMap.put(prdEvaluateDtlVO.getPointId(), newResEvalScoreVO);
            }
        }
        ArrayList<ResEvaluateDtlVO> resEvaluateDtlVOList = new ArrayList<ResEvaluateDtlVO>();
        BigDecimal evalTotalScore = new BigDecimal(0);
        BigDecimal resComprehensiveScore = null;
        if (!ObjectUtils.isEmpty(evaluateMap)) {
            for (Long key : evaluateMap.keySet()) {
                resEvalScoreVO = (ResEvalScoreVO)evaluateMap.get(key);
                BigDecimal evalPointTotalScore = resEvalScoreVO.getTotalScore();
                evalTotalScore = evalTotalScore.add(evalTotalScore);
                Long evalSize = resEvalScoreVO.getSize();
                BigDecimal avgScore = evalPointTotalScore.divide(BigDecimal.valueOf(evalSize), 1, RoundingMode.HALF_DOWN);
                ResEvaluateDtlVO resEvaluateDtlVO = new ResEvaluateDtlVO();
                resEvaluateDtlVO.setEvalPointId(key);
                resEvaluateDtlVO.setEvalPoint(resEvalScoreVO.getPointName());
                resEvaluateDtlVO.setEvalScore(avgScore);
                resEvaluateDtlVOList.add(resEvaluateDtlVO);
            }
            BigDecimal allTotalScore = BigDecimal.ZERO;
            for (ResEvaluateDtlVO resEvaluateDtlVO : resEvaluateDtlVOList) {
                allTotalScore = allTotalScore.add(resEvaluateDtlVO.getEvalScore());
            }
            resComprehensiveScore = allTotalScore.divide(BigDecimal.valueOf(resEvaluateDtlVOList.size()), 1, RoundingMode.HALF_DOWN);
        }
        ResEvaluateVO resEvaluateVO = new ResEvaluateVO();
        resEvaluateVO.setEvalDtl(resEvaluateDtlVOList);
        resEvaluateVO.setComprehensiveScore(resComprehensiveScore);
        return resEvaluateVO;
    }

    @Transactional
    public void updateResPortrayalEvalConfig(ResPortrayalEvalConfigPayload payload) {
        Long userId = payload.getUserId();
        String oldResEvalPointIds = this.resPortrayalEvalConfigDAO.getResEvalPointIds(userId);
        String newEvalPointIdList = null;
        StringBuilder evalPointIdList = new StringBuilder();
        for (Long evalPointId : payload.getEvalPointIds()) {
            evalPointIdList.append(',').append(evalPointId);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getEvalPointIds())) {
            newEvalPointIdList = evalPointIdList.substring(1);
        }
        ResPortrayalEvalConfigDO defaultConfigDO = new ResPortrayalEvalConfigDO();
        defaultConfigDO.setUserId(userId);
        defaultConfigDO.setEvalPointIds(newEvalPointIdList);
        if (oldResEvalPointIds != null) {
            this.resPortrayalEvalConfigDAO.updateResConfig(defaultConfigDO);
        } else {
            this.resPortrayalEvalConfigDAO.saveConfig(defaultConfigDO);
        }
    }

    @Transactional
    public void updateResPortrayalEvalDefaultConfig(Long[] evalPointIds) {
        String oldDefaultEvalPointIds = this.resPortrayalEvalConfigDAO.getDefaultEvalPointIds();
        StringBuilder evalPointIdList = new StringBuilder();
        String newEvalPointIdList = null;
        for (Long evalPointId : evalPointIds) {
            evalPointIdList.append(',').append(evalPointId);
        }
        if (!ObjectUtils.isEmpty((Object[])evalPointIds)) {
            newEvalPointIdList = evalPointIdList.substring(1);
        }
        if (oldDefaultEvalPointIds != null) {
            this.resPortrayalEvalConfigDAO.updateDefaultConfig(newEvalPointIdList);
        } else {
            ResPortrayalEvalConfigDO defaultConfigDO = new ResPortrayalEvalConfigDO();
            defaultConfigDO.setDefaultFlag(true);
            defaultConfigDO.setEvalPointIds(newEvalPointIdList);
            this.resPortrayalEvalConfigDAO.saveConfig(defaultConfigDO);
        }
    }

    public List<Long> getResPortrayalEvalPoints(Long userId) {
        String resEvalPoints = this.resPortrayalEvalConfigDAO.getResEvalPointIds(userId);
        if (resEvalPoints == null) {
            return null;
        }
        String[] arr = resEvalPoints.split(",");
        return Arrays.stream(arr).map(Long::parseLong).toList();
    }

    public List<Long> getResPortrayalEvalDefaultConfig() {
        String defaultEvalPoints = this.resPortrayalEvalConfigDAO.getDefaultEvalPointIds();
        if (defaultEvalPoints == null) {
            return null;
        }
        String[] arr = defaultEvalPoints.split(",");
        return Arrays.stream(arr).map(Long::parseLong).toList();
    }

    public List<Long> getResPortrayalEvalConfig(Long userId) {
        String resEvalPoints = this.resPortrayalEvalConfigDAO.getResEvalPointIds(userId);
        if (resEvalPoints == null) {
            String defaultEvalPoints = this.resPortrayalEvalConfigDAO.getDefaultEvalPointIds();
            if (defaultEvalPoints == null) {
                return null;
            }
            String[] arr = defaultEvalPoints.split(",");
            return Arrays.stream(arr).map(Long::parseLong).toList();
        }
        String[] arr = resEvalPoints.split(",");
        return Arrays.stream(arr).map(Long::parseLong).toList();
    }

    public BigDecimal getResProjEvaluateScore(Long userId) {
        PrdEvaluateQuery prdEvaluateQuery = new PrdEvaluateQuery();
        prdEvaluateQuery.setToEvalUserId(userId);
        prdEvaluateQuery.setCate("PROJ");
        BigDecimal projEvalScore = new BigDecimal(0);
        List prdEvaluateVOList = this.prdEvaluateService.getList(prdEvaluateQuery);
        if (prdEvaluateVOList != null && prdEvaluateVOList.size() > 0) {
            BigDecimal totalScore = new BigDecimal(0);
            int size = 0;
            for (PrdEvaluateVO prdEvaluateVO : prdEvaluateVOList) {
                totalScore = totalScore.add(prdEvaluateVO.getAverageScore());
                ++size;
            }
            projEvalScore = totalScore.subtract(BigDecimal.valueOf(size)).setScale(1, RoundingMode.HALF_DOWN);
        }
        return projEvalScore;
    }

    public ResEvaluateServiceImpl(PrdEvaluateService prdEvaluateService, ResPortrayalEvalConfigDAO resPortrayalEvalConfigDAO) {
        this.prdEvaluateService = prdEvaluateService;
        this.resPortrayalEvalConfigDAO = resPortrayalEvalConfigDAO;
    }
}

