/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveConfigService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveConfigVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.server.prd.my.convert.RewardLeaveConfigConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveConfigDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveConfigDO;
import com.elitesland.tw.tw5.server.prd.my.repo.RewardLeaveConfigRepo;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class RewardLeaveConfigServiceImpl
extends BaseServiceImpl
implements RewardLeaveConfigService {
    private static final Logger log = LoggerFactory.getLogger(RewardLeaveConfigServiceImpl.class);
    private final RewardLeaveConfigRepo rewardLeaveConfigRepo;
    private final RewardLeaveConfigDAO rewardLeaveConfigDAO;
    private final PmsProjectService pmsProjectService;

    public PagingVO<RewardLeaveConfigVO> queryPaging(RewardLeaveConfigQuery query) {
        PagingVO<RewardLeaveConfigVO> pagingVO = this.rewardLeaveConfigDAO.queryPaging(query);
        List rewardLeaveConfigVOList = pagingVO.getRecords();
        for (RewardLeaveConfigVO rewardLeaveConfigVO : rewardLeaveConfigVOList) {
            if (rewardLeaveConfigVO.getProjectId() != null) {
                rewardLeaveConfigVO.setProjectName(this.pmsProjectService.querySimpleProjectByKey(rewardLeaveConfigVO.getProjectId()).getProjName());
            }
            if (!ObjectUtils.isEmpty((Object)rewardLeaveConfigVO.getJobGradeList())) {
                List<String> jobGradeList = Arrays.asList(rewardLeaveConfigVO.getJobGradeList().split(","));
                rewardLeaveConfigVO.setJobGrades(jobGradeList);
            }
            if (ObjectUtils.isEmpty((Object)rewardLeaveConfigVO.getJobGrade2List())) continue;
            List<String> jobGrade2List = Arrays.asList(rewardLeaveConfigVO.getJobGrade2List().split(","));
            rewardLeaveConfigVO.setJobGrades2(jobGrade2List);
        }
        pagingVO.setRecords(rewardLeaveConfigVOList);
        return pagingVO;
    }

    public List<RewardLeaveConfigVO> queryListDynamic(RewardLeaveConfigQuery query) {
        return this.rewardLeaveConfigDAO.queryListDynamic(query);
    }

    public RewardLeaveConfigVO queryByKey(Long key) {
        RewardLeaveConfigDO entity = this.rewardLeaveConfigRepo.findById(key).orElseGet(RewardLeaveConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        RewardLeaveConfigVO vo = RewardLeaveConfigConvert.INSTANCE.toVo(entity);
        if (ObjectUtils.isEmpty((Object)entity.getJobGradeList())) {
            List<String> jobGradeList = Arrays.asList(entity.getJobGradeList().split(","));
            vo.setJobGrades(jobGradeList);
        }
        if (!ObjectUtils.isEmpty((Object)entity.getJobGrade2List())) {
            List<String> jobGrade2List = Arrays.asList(entity.getJobGrade2List().split(","));
            vo.setJobGrades2(jobGrade2List);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public RewardLeaveConfigVO insert(RewardLeaveConfigPayload payload) {
        String str;
        RewardLeaveConfigDO entityDo = RewardLeaveConfigConvert.INSTANCE.toDo(payload);
        if (!ObjectUtils.isEmpty((Object)payload.getJobGrades())) {
            str = String.join((CharSequence)",", payload.getJobGrades());
            entityDo.setJobGradeList(str);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getJobGrades2())) {
            str = String.join((CharSequence)",", payload.getJobGrades2());
            entityDo.setJobGrade2List(str);
        }
        return RewardLeaveConfigConvert.INSTANCE.toVo((RewardLeaveConfigDO)((Object)this.rewardLeaveConfigRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public RewardLeaveConfigVO update(RewardLeaveConfigPayload payload) {
        String str;
        RewardLeaveConfigDO entity = this.rewardLeaveConfigRepo.findById(payload.getId()).orElseGet(RewardLeaveConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        RewardLeaveConfigDO entityDo = RewardLeaveConfigConvert.INSTANCE.toDo(payload);
        if (!ObjectUtils.isEmpty((Object)payload.getJobGrades())) {
            str = String.join((CharSequence)",", payload.getJobGrades());
            entityDo.setJobGradeList(str);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getJobGrades2())) {
            str = String.join((CharSequence)",", payload.getJobGrades2());
            entityDo.setJobGrade2List(str);
        }
        entity.copy(entityDo);
        return RewardLeaveConfigConvert.INSTANCE.toVo((RewardLeaveConfigDO)((Object)this.rewardLeaveConfigRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(RewardLeaveConfigPayload payload) {
        String str;
        RewardLeaveConfigDO entity = this.rewardLeaveConfigRepo.findById(payload.getId()).orElseGet(RewardLeaveConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (!ObjectUtils.isEmpty((Object)payload.getJobGrades())) {
            str = String.join((CharSequence)",", payload.getJobGrades());
            payload.setJobGradeList(str);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getJobGrades2())) {
            str = String.join((CharSequence)",", payload.getJobGrades2());
            payload.setJobGrade2List(str);
        }
        long result = this.rewardLeaveConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.rewardLeaveConfigDAO.deleteSoft(keys);
        }
    }

    public List<RewardLeaveConfigVO> queryBuConfig(RewardLeaveConfigQuery query) {
        return this.rewardLeaveConfigDAO.queryBuConfig(query);
    }

    public RewardLeaveConfigServiceImpl(RewardLeaveConfigRepo rewardLeaveConfigRepo, RewardLeaveConfigDAO rewardLeaveConfigDAO, PmsProjectService pmsProjectService) {
        this.rewardLeaveConfigRepo = rewardLeaveConfigRepo;
        this.rewardLeaveConfigDAO = rewardLeaveConfigDAO;
        this.pmsProjectService = pmsProjectService;
    }
}

