/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeEqvaRatioDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeEqvaRatioDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeEqvaRatioRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDate;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdOrgEmployeeEqvaRatioDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdOrgEmployeeEqvaRatioDO qdo = QPrdOrgEmployeeEqvaRatioDO.prdOrgEmployeeEqvaRatioDO;
    private final PrdOrgEmployeeEqvaRatioRepo employeeEqvaRatioRepo;

    private JPAQuery<PrdOrgEmployeeEqvaRatioVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgEmployeeEqvaRatioVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.eqvaRatio, this.qdo.orgId, this.qdo.userId, this.qdo.startDate, this.qdo.endDate})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    public List<PrdOrgEmployeeEqvaRatioVO> getEqvaRatioList(Long userId, Long orgId) {
        JPAQuery<PrdOrgEmployeeEqvaRatioVO> jpaQuery = this.getJpaQuerySelect();
        if (orgId != null) {
            jpaQuery.where((Predicate)this.qdo.orgId.eq((Object)orgId));
        }
        jpaQuery.where((Predicate)this.qdo.userId.eq((Object)userId));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, null));
        return jpaQuery.fetch();
    }

    public List<PrdOrgEmployeeEqvaRatioVO> getEqvaRatioListByDate(PrdOrgEmployeeEqvaRatioQuery query) {
        JPAQuery<PrdOrgEmployeeEqvaRatioVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.userId.eq((Object)query.getUserId()));
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            jpaQuery.where((Predicate)this.qdo.endDate.gt((Comparable)query.getStartDate()).or((Predicate)this.qdo.endDate.isNull()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            jpaQuery.where((Predicate)this.qdo.startDate.lt((Comparable)query.getEndDate()));
        }
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, null));
        return jpaQuery.fetch();
    }

    public void saveGrade(PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO) {
        this.employeeEqvaRatioRepo.save(employeeEqvaRatioDO);
    }

    @Transactional
    public void updateEqvaDate(Long userId, LocalDate date) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.endDate, (Object)date).where(new Predicate[]{this.qdo.userId.eq((Object)userId)}).where(new Predicate[]{this.qdo.endDate.isNull()}).execute();
    }

    public PrdOrgEmployeeEqvaRatioDAO(JPAQueryFactory jpaQueryFactory, PrdOrgEmployeeEqvaRatioRepo employeeEqvaRatioRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.employeeEqvaRatioRepo = employeeEqvaRatioRepo;
    }
}

