/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.OfferEntryApplyProcPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeBlackListQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.OfferEntryApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonAccountService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonCertService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonEduExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonProjectExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonRewardPunishService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonWorkExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeBlackListVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.OfferEntryApplyVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdInternalRecommVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgPersonQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgPersonService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonBSVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonDetailVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.OfferEntryApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.OfferEntryApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.OfferEntryApplyDO;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgPersonConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PrdOrgPersonServiceImpl
implements PrdOrgPersonService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgPersonServiceImpl.class);
    private final PrdOrgPersonDAO prdOrgPersonDAO;
    private final PersonEduExperienceService personEduExperienceService;
    private final PersonWorkExperienceService personWorkExperienceService;
    private final PersonProjectExperienceService personProjectExperienceService;
    private final PersonCertService personCertService;
    private final PersonAccountService personAccountService;
    private final FileUtil fileUtil;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final PrdSystemBusinessChangeService changeService;
    private final PrdSystemBusinessChangeDAO changeDAO;
    private final PrdOrgOrganizationService orgService;
    private final WorkflowService workflowService;
    @Autowired
    private final PrdOrgEmployeeService employeeService;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final OfferEntryApplyDAO offerEntryApplyDAO;
    private BeanSearcher beanSearcher;
    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;
    private final PrdEmployeCompositeAbilityService employeeAbilityService;
    private final PrdCompositeAbilityService abilityService;
    private final CacheUtil cacheUtil;
    private final PersonRewardPunishService personRewardPunishService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;
    @Autowired
    @Lazy
    private PrdInternalRecommService prdInternalRecommService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PRD_ORG_PERSON);
    }

    public PagingVO<PrdOrgPersonVO> paging(PrdOrgPersonQuery query) {
        return this.prdOrgPersonDAO.queryPaging(query);
    }

    @Transactional
    public Long insert(PrdOrgPersonPayload entity) {
        if (!ObjectUtils.isEmpty((Object)entity.getMobile()) && this.prdOrgPersonDAO.queryByMobile(entity.getMobile()) != null) {
            throw TwException.error("", "\u7535\u8bdd\u53f7\u7801\u91cd\u590d");
        }
        if (!ObjectUtils.isEmpty((Object)entity.getIdNo()) && this.prdOrgPersonDAO.queryByIdNo(entity.getIdNo()) != null) {
            throw TwException.error("", "\u8bc1\u4ef6\u53f7\u91cd\u590d");
        }
        if (!ObjectUtils.isEmpty((Object)entity.getEmail()) && this.prdOrgPersonDAO.queryByEmail(entity.getEmail()) != null) {
            throw TwException.error("", "\u90ae\u7bb1\u91cd\u590d");
        }
        PrdOrgPersonDO prdOrgPersonDO = PrdOrgPersonConvert.INSTANCE.toDo(entity);
        prdOrgPersonDO.setEnabled(true);
        Long personId = this.prdOrgPersonDAO.save(prdOrgPersonDO).getId();
        PrdOrgEmployeeDO prdOrgEmployeeDO = new PrdOrgEmployeeDO();
        prdOrgEmployeeDO.setPersonId(personId);
        prdOrgEmployeeDO.setResourceStatus("1");
        return this.employeeDAO.save(prdOrgEmployeeDO).getId();
    }

    @Transactional
    public void update(PrdOrgPersonDetailVO entity) {
        PrdOrgPersonVO personVO = entity.getPersonVO();
        this.prdOrgPersonDAO.save(PrdOrgPersonConvert.INSTANCE.toDo(personVO));
        Long personId = personVO.getId();
        List eduExperienceVOList = entity.getEduExperienceVOList();
        this.personEduExperienceService.saveAll(eduExperienceVOList, personId);
        List workExperienceVOList = entity.getWorkExperienceVOList();
        this.personWorkExperienceService.saveAll(workExperienceVOList, personId);
        List projectExperienceVOList = entity.getProjectExperienceVOList();
        this.personProjectExperienceService.saveAll(projectExperienceVOList, personId);
        List certVOList = entity.getCertVOList();
        this.personCertService.saveAll(certVOList, personId);
        List accountVOList = entity.getAccountVOList();
        this.personAccountService.saveAll(accountVOList, personId);
        List personRewardPunishVOList = entity.getRewardPunishVOList();
        this.personRewardPunishService.saveAll(personRewardPunishVOList, personId);
    }

    public PrdOrgPersonDetailVO findById(Long id) {
        Optional<PrdOrgPersonDO> prdOrgPersonDO = this.prdOrgPersonDAO.findById(id);
        if (prdOrgPersonDO.isEmpty()) {
            return null;
        }
        PrdOrgPersonDO prdOrgPerson = prdOrgPersonDO.get();
        PrdOrgPersonVO prdOrgPersonVO = PrdOrgPersonConvert.INSTANCE.toVo(prdOrgPerson);
        prdOrgPersonVO.setIdValidDatas(this.fileUtil.getFileDatas(prdOrgPersonVO.getIdValidCodes()));
        prdOrgPersonVO.setHeadDatas(this.fileUtil.getFileDatas(prdOrgPersonVO.getHeadCodes()));
        prdOrgPersonVO.setSelfIntroVideoDatas(this.fileUtil.getFileDatas(prdOrgPersonVO.getSelfIntroVideoCodes()));
        prdOrgPersonVO.setResumeDatas(this.fileUtil.getFileDatas(prdOrgPersonVO.getResumeCodes()));
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.prdOrgPersonDAO.findEmployeeByPersonId(id);
        prdOrgPersonVO.setResourceStatus(prdOrgEmployeeDO.getResourceStatus());
        PrdOrgPersonDetailVO prdOrgPersonDetailVO = new PrdOrgPersonDetailVO();
        prdOrgPersonDetailVO.setPersonVO(prdOrgPersonVO);
        List eduExperienceVOList = this.personEduExperienceService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setEduExperienceVOList(eduExperienceVOList);
        List workExperienceVOList = this.personWorkExperienceService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setWorkExperienceVOList(workExperienceVOList);
        List projectExperienceVOList = this.personProjectExperienceService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setProjectExperienceVOList(projectExperienceVOList);
        List certVOList = this.personCertService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setCertVOList(certVOList);
        List accountVOList = this.personAccountService.findAllByPersonId(id);
        prdOrgPersonDetailVO.setAccountVOList(accountVOList);
        PrdInternalRecommVO prdInternalRecommVO = this.prdInternalRecommService.getByPersonId(prdOrgPerson.getPersonName(), id);
        if (null != prdInternalRecommVO) {
            prdOrgPersonDetailVO.setIsJobInternalRecomm(Boolean.valueOf(true));
            prdOrgPersonDetailVO.setJobInternalRecommId(prdInternalRecommVO.getManagerUserId());
        }
        return prdOrgPersonDetailVO;
    }

    @Transactional
    public void deleteById(Long id) {
        this.prdOrgPersonDAO.deleteById(id);
        this.personCertService.deleteAllByPersonId(id);
        this.personProjectExperienceService.deleteAllByPersonId(id);
        this.personWorkExperienceService.deleteAllByPersonId(id);
        this.personEduExperienceService.deleteAllByPersonId(id);
        this.personAccountService.deleteAllByPersonId(id);
        this.personRewardPunishService.deleteAllByPersonId(id);
    }

    @Transactional
    public void personEntry(PrdOrgEmployeePayload entity) {
        List<OfferEntryApplyDO> offerEntryApplyDOList = this.offerEntryApplyDAO.queryByPersonId(entity.getPersonId());
        if (!ObjectUtils.isEmpty(offerEntryApplyDOList)) {
            for (OfferEntryApplyDO offerEntryApplyDO : offerEntryApplyDOList) {
                if (!offerEntryApplyDO.getProcInstStatus().equals((Object)ProcInstStatus.APPROVING)) continue;
                throw TwException.error("", "\u8be5\u8d44\u6e90\u6709\u5ba1\u6279\u4e2d\u7684\u5165\u804c\u6d41\u7a0b\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
        }
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        Long personId = entity.getPersonId();
        entity.setId(personId);
        HashMap<String, Object> variables = this.setWorkFlowVar(entity);
        String procInstName = "A30.offer\u5165\u804c\u53d1\u653e\u6d41\u7a0b-" + entity.getPersonName();
        OfferEntryApplyDO offerEntryApplyDO = OfferEntryApplyConvert.INSTANCE.payloadToDO(entity);
        offerEntryApplyDO.setProcInstName(procInstName);
        offerEntryApplyDO.setCreateUserId(GlobalUtil.getLoginUserId());
        OfferEntryApplyDO offerEntryApplySaveDO = this.offerEntryApplyDAO.save(offerEntryApplyDO);
        processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OFFER_ENTRY.name(), (String)procInstName, (String)("" + offerEntryApplySaveDO.getId()), variables), new Long[0]);
        OfferEntryApplyProcPayload offerEntryApplyProcPayload = new OfferEntryApplyProcPayload();
        offerEntryApplyProcPayload.setProcInstId(processInfo.getProcInstId());
        offerEntryApplyProcPayload.setProcInstStatus(processInfo.getProcInstStatus());
        offerEntryApplyProcPayload.setId(offerEntryApplySaveDO.getId());
        this.offerEntryApplyDAO.updateProcStatus(offerEntryApplyProcPayload);
        this.prdOrgPersonDAO.updateApprStatus(personId, "APPROVING");
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.prdOrgPersonDAO.findEmployeeByPersonId(personId);
        Long employeeId = prdOrgEmployeeDO.getId();
        this.employeeDAO.updateResStatus(employeeId, "2");
        PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
        prdOrgEmployeePayload.setId(employeeId);
        prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.APPROVING);
        this.employeeDAO.updateProcessDate(prdOrgEmployeePayload);
        PrdOrgPersonPayload prdOrgPersonPayload = new PrdOrgPersonPayload();
        prdOrgPersonPayload.setProcInstId(processInfo.getProcInstId());
        prdOrgPersonPayload.setId(entity.getPersonId());
        prdOrgPersonPayload.setProcInstStatus(processInfo.getProcInstStatus());
        prdOrgPersonPayload.setSubmitTime(LocalDateTime.now());
        this.prdOrgPersonDAO.updateProcessDate(prdOrgPersonPayload);
        String userName = entity.getPersonName();
        String title = "offer\u53d1\u653e\u53ca\u5165\u804c\u7533\u8bf7-" + userName;
        String content = "offer\u53d1\u653e\u53ca\u5165\u804c\u7533\u8bf7-" + userName + "\uff0c\u8bf7\u76f8\u5173\u8d1f\u8d23\u4eba\u53ca\u65f6\u67e5\u770b";
        this.sendMessage(offerEntryApplySaveDO.getId(), title, content);
    }

    @Transactional
    public void personEntryUpdate(PrdOrgEmployeePayload payload) {
        OfferEntryApplyDO offerEntryApplyDO = this.offerEntryApplyDAO.queryByProcId(payload.getProcInstId());
        OfferEntryApplyDO saveEntryApplyDO = OfferEntryApplyConvert.INSTANCE.payloadToDO(payload);
        saveEntryApplyDO.setProcInstName(offerEntryApplyDO.getProcInstName());
        saveEntryApplyDO.setCreateUserId(offerEntryApplyDO.getCreateUserId());
        this.offerEntryApplyDAO.save(saveEntryApplyDO);
        WorkflowResult taskInfo = this.workflowService.currentTaskInfo(payload.getProcInstId());
        if (((TaskInfo)taskInfo.getData()).getTaskDefKey().equals("Activity_1fnq5fx")) {
            BigDecimal eqvaRatio = BigDecimal.ONE;
            PrdOrgEmployeeVO oldPrdOrgEmployeeVO = this.findEmployeeByPersonId(payload.getPersonId());
            payload.setId(oldPrdOrgEmployeeVO.getId());
            payload.setHrStatus("ACTIVE");
            payload.setResourceStatus("3");
            payload.setEqvaRatio(eqvaRatio);
            payload.setEnabled(Boolean.valueOf(true));
            payload.setUserId(oldPrdOrgEmployeeVO.getUserId());
            PrdOrgEmployeeVO prdOrgEmployeeVO = this.employeeService.insertNew(payload);
            Long userId = prdOrgEmployeeVO.getUserId();
            if (!ObjectUtils.isEmpty((Object)payload.getCapasetLevelId())) {
                PrdCompositeAbilityVO compositeAbilityVO = this.abilityService.findByAbilityLevelId(Long.valueOf(payload.getCapasetLevelId()));
                PrdEmployeCompositeAbilityPayload abilityPayload = new PrdEmployeCompositeAbilityPayload();
                String abilityName = compositeAbilityVO.getJobType1Desc() + "-" + compositeAbilityVO.getJobType2Desc() + "-" + compositeAbilityVO.getLevelDtlName();
                abilityPayload.setAbilityId(compositeAbilityVO.getId());
                abilityPayload.setDlRatio(compositeAbilityVO.getDlRatio());
                abilityPayload.setMainFlag(Boolean.valueOf(true));
                abilityPayload.setUserId(userId);
                abilityPayload.setAbilityName(abilityName);
                abilityPayload.setDocNo(compositeAbilityVO.getDocNo());
                abilityPayload.setAbilityLevelId(compositeAbilityVO.getAbilityLevelId());
                this.employeeAbilityService.save(abilityPayload);
            }
            payload.setUserId(userId);
            PrdOrgEmployeeEqvaRatioPayload employeeEqvaRatioPayload = new PrdOrgEmployeeEqvaRatioPayload();
            employeeEqvaRatioPayload.setEqvaRatio(eqvaRatio);
            employeeEqvaRatioPayload.setStartDate(LocalDate.now());
            employeeEqvaRatioPayload.setUserId(userId);
            this.employeeEqvaRatioService.upsertEqvaRatio(employeeEqvaRatioPayload);
        }
        this.updateWorkFlowVar(payload);
    }

    public PrdOrgEmployeePayload personEntryQuery(String procId) {
        OfferEntryApplyDO offerEntryApplyDO = this.offerEntryApplyDAO.queryByProcId(procId);
        PrdOrgEmployeePayload payload = OfferEntryApplyConvert.INSTANCE.doToPayload(offerEntryApplyDO);
        payload.setHeadDatas(this.fileUtil.getFileDatas(payload.getHeadCodes()));
        return payload;
    }

    public HashMap<String, Object> setWorkFlowVar(PrdOrgEmployeePayload entity) {
        Long orgId;
        PrdOrgOrganizationVO prdOrgOrganizationVO;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (entity.getCeoApprFlag() != null) {
            variables.put("ceoApprFlag", entity.getCeoApprFlag());
        }
        if (entity.getDeliverOffer() != null) {
            variables.put("deliverOffer", entity.getDeliverOffer());
        }
        if ((prdOrgOrganizationVO = this.orgService.queryDetailSimpleByOrgId(orgId = entity.getOrgId())) == null) {
            throw TwException.error("", "\u6240\u9009\u90e8\u95e8\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728");
        }
        variables.put("Activity_17afndn", CollUtil.newArrayList((Object[])new Long[]{prdOrgOrganizationVO.getManageId()}));
        List<Long> hrdUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode());
        variables.put("Activity_1ljpo8r", hrdUserIds);
        List<Long> empRelIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(CollUtil.newArrayList((Object[])new String[]{RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()}));
        variables.put("Activity_1nxxl7l", empRelIds);
        List<Long> itUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode());
        variables.put("Activity_1fnq5fx", itUserIds);
        variables.put("Activity_1nwpb6u", empRelIds);
        if (entity.getUserId() != null) {
            variables.put("Activity_1mr3mor", CollUtil.newArrayList((Object[])new Long[]{entity.getUserId()}));
        }
        return variables;
    }

    public void updateWorkFlowVar(PrdOrgEmployeePayload entity) {
        HashMap<String, Object> variables = this.setWorkFlowVar(entity);
        SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
        setVariablesPayload.setProcInstId(entity.getProcInstId());
        setVariablesPayload.setVariables(variables);
        this.workflowUtil.setVaribales(setVariablesPayload);
    }

    @Transactional
    public void inBlackList(Long id) {
        this.prdOrgPersonDAO.inBlackList(id);
    }

    @Transactional
    public void outBlackList(Long id) {
        this.prdOrgPersonDAO.outBlackList(id);
    }

    public PagingVO<EmployeeBlackListVO> queryBlackList(EmployeeBlackListQuery query) {
        List blackList;
        PagingVO<EmployeeBlackListVO> pagingVO = this.prdOrgPersonDAO.queryBlackListPaging(query);
        if (pagingVO != null && !ObjectUtils.isEmpty((Object)(blackList = pagingVO.getRecords()))) {
            for (EmployeeBlackListVO vo : blackList) {
                vo.setExtString6Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeType.getCode(), vo.getExtString6()));
                vo.setResourceStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
                if (vo.getResourceStatus() == null) {
                    vo.setResourceStatus(vo.getPersonStatus());
                    vo.setResourceStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getPersonStatus()));
                }
                if (Objects.equals(vo.getExtString6(), "INTERNAL_RES")) {
                    vo.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), vo.getExtString9()));
                    continue;
                }
                if (!Objects.equals(vo.getExtString6(), "EXTERNAL_RES")) continue;
                vo.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), vo.getExtString9()));
            }
        }
        return pagingVO;
    }

    public PagingVO<OfferEntryApplyVO> offerApplyPage(OfferEntryApplyQuery offerEntryApplyQuery) {
        List offerEntryApplyVOList;
        PagingVO<OfferEntryApplyVO> page = this.offerEntryApplyDAO.queryPaging(offerEntryApplyQuery);
        if (page != null && (offerEntryApplyVOList = page.getRecords()) != null) {
            for (OfferEntryApplyVO offerEntryApplyVO : offerEntryApplyVOList) {
                offerEntryApplyVO.setApplyUser(this.cacheUtil.getUserName(offerEntryApplyVO.getCreateUserId()));
            }
        }
        return page;
    }

    public PagingVO<PrdOrgPersonBSVO> permissionPaging(PrdOrgPersonQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PrdOrgPersonBSVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List employeeDepartApplyVOList = this.beanSearcher.searchList(PrdOrgPersonBSVO.class, mapBuilder.build());
        return PagingVO.builder().records(employeeDepartApplyVOList).total(((Long)totalNum).longValue()).build();
    }

    public PrdOrgPersonVO getByMobile(String recommPhone) {
        List<PrdOrgPersonVO> res = this.prdOrgPersonDAO.getByMobile(recommPhone);
        if (CollUtil.isNotEmpty(res)) {
            return res.get(0);
        }
        return null;
    }

    private MapBuilder pageWhereBuilder(PrdOrgPersonQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (StringUtils.isNotBlank((CharSequence)query.getPersonName())) {
            ((MapBuilder)builder.field(PrdOrgPersonBSVO::getPersonName, new Object[]{query.getPersonName()})).op((FieldOp)FieldOps.Contain);
        }
        if (StringUtils.isNotBlank((CharSequence)query.getSex())) {
            ((MapBuilder)builder.field(PrdOrgPersonBSVO::getSex, new Object[]{query.getSex()})).op((FieldOp)FieldOps.Equal);
        }
        if (StringUtils.isNotBlank((CharSequence)query.getApprStatus())) {
            ((MapBuilder)builder.field(PrdOrgPersonBSVO::getApprStatus, new Object[]{query.getApprStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart()) && !ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            ((MapBuilder)builder.field(PrdOrgPersonBSVO::getCreateTime, new FieldFns.FieldFn[0])).sql(" $1 > ? and $1 < ?", new Object[]{query.getCreateTimeStart(), query.getCreateTimeEnd()});
        }
        if (!ObjectUtils.isEmpty((Object)query.getResourceStatus())) {
            ((MapBuilder)builder.field(PrdOrgPersonBSVO::getResourceStatus, new Object[]{query.getResourceStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtDate1Start()) && !ObjectUtils.isEmpty((Object)query.getExtDate1End())) {
            ((MapBuilder)builder.field(PrdOrgPersonBSVO::getExtDate1, new FieldFns.FieldFn[0])).sql(" $1 > ? and $1 < ?", new Object[]{query.getExtDate1Start(), query.getExtDate1End()});
        }
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public PrdOrgEmployeeVO findEmployeeByPersonId(Long personId) {
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.prdOrgPersonDAO.findEmployeeByPersonId(personId);
        if (prdOrgEmployeeDO != null) {
            return PrdOrgEmployeeConvert.INSTANCE.toVo(prdOrgEmployeeDO);
        }
        return null;
    }

    public OfferEntryApplyVO queryOfferByKey(Long applyId) {
        return this.offerEntryApplyDAO.queryByKey(applyId);
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERM.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERS.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    public PrdOrgPersonServiceImpl(PrdOrgPersonDAO prdOrgPersonDAO, PersonEduExperienceService personEduExperienceService, PersonWorkExperienceService personWorkExperienceService, PersonProjectExperienceService personProjectExperienceService, PersonCertService personCertService, PersonAccountService personAccountService, FileUtil fileUtil, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, PrdSystemBusinessChangeService changeService, PrdSystemBusinessChangeDAO changeDAO, PrdOrgOrganizationService orgService, WorkflowService workflowService, PrdOrgEmployeeService employeeService, PrdSystemRoleDAO prdSystemRoleDAO, OfferEntryApplyDAO offerEntryApplyDAO, PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService, PrdEmployeCompositeAbilityService employeeAbilityService, PrdCompositeAbilityService abilityService, CacheUtil cacheUtil, PersonRewardPunishService personRewardPunishService, PrdOrgEmployeeDAO employeeDAO, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService) {
        this.prdOrgPersonDAO = prdOrgPersonDAO;
        this.personEduExperienceService = personEduExperienceService;
        this.personWorkExperienceService = personWorkExperienceService;
        this.personProjectExperienceService = personProjectExperienceService;
        this.personCertService = personCertService;
        this.personAccountService = personAccountService;
        this.fileUtil = fileUtil;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.changeService = changeService;
        this.changeDAO = changeDAO;
        this.orgService = orgService;
        this.workflowService = workflowService;
        this.employeeService = employeeService;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.offerEntryApplyDAO = offerEntryApplyDAO;
        this.employeeEqvaRatioService = employeeEqvaRatioService;
        this.employeeAbilityService = employeeAbilityService;
        this.abilityService = abilityService;
        this.cacheUtil = cacheUtil;
        this.personRewardPunishService = personRewardPunishService;
        this.employeeDAO = employeeDAO;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
    }
}

