/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.sale.convert.SaleContractConvert;
import com.elitesland.tw.tw5.server.prd.sale.entity.SaleContractDO;
import com.elitesland.tw.tw5.server.prd.sale.repo.SaleContractRepo;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SaleContractServiceImpl
implements SaleContractService {
    private static final Logger log = LoggerFactory.getLogger(SaleContractServiceImpl.class);
    private final SaleContractRepo saleContractRepo;

    @Transactional(rollbackFor={Exception.class})
    public SaleContractVO insert(SaleContractPayload payload) {
        SaleContractDO entityDo = SaleContractConvert.INSTANCE.toDo(payload);
        this.saleContractRepo.save(entityDo);
        return SaleContractConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleContractVO update(SaleContractPayload payload) {
        SaleContractDO entity = this.saleContractRepo.findById(payload.getId()).orElseGet(SaleContractDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5408\u540c\u4e0d\u5b58\u5728");
        SaleContractDO entityDo = SaleContractConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleContractConvert.INSTANCE.toVo((SaleContractDO)this.saleContractRepo.save(entity));
    }

    public SaleContractVO queryByKey(Long key) {
        SaleContractDO entity = this.saleContractRepo.findById(key).orElseGet(SaleContractDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5408\u540c\u4e0d\u5b58\u5728");
        return SaleContractConvert.INSTANCE.toVo(entity);
    }

    public List<SaleContractVO> queryList(SaleContractQuery query) {
        return SaleContractConvert.INSTANCE.toVoList(this.saleContractRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public PagingVO<SaleContractVO> paging(SaleContractQuery query) {
        Page page = this.saleContractRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(SaleContractConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.saleContractRepo.deleteSoft(keys);
        }
    }

    public SaleContractServiceImpl(SaleContractRepo saleContractRepo) {
        this.saleContractRepo = saleContractRepo;
    }
}

