/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.shorturl.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlConfPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlConfQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlConfService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlConfVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.shorturl.convert.ShortUrlConfConvert;
import com.elitesland.tw.tw5.server.prd.shorturl.dao.ShortUrlConfDAO;
import com.elitesland.tw.tw5.server.prd.shorturl.entity.ShortUrlConfDO;
import com.elitesland.tw.tw5.server.prd.shorturl.repo.ShortUrlConfRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ShortUrlConfServiceImpl
extends BaseServiceImpl
implements ShortUrlConfService {
    private static final Logger log = LoggerFactory.getLogger(ShortUrlConfServiceImpl.class);
    private final ShortUrlConfRepo shortUrlConfRepo;
    private final ShortUrlConfDAO shortUrlConfDAO;

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public PagingVO<ShortUrlConfVO> queryPaging(ShortUrlConfQuery query) {
        return this.shortUrlConfDAO.queryPaging(query);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<ShortUrlConfVO> queryListDynamic(ShortUrlConfQuery query) {
        return this.shortUrlConfDAO.queryListDynamic(query);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public long count(ShortUrlConfQuery query) {
        return this.shortUrlConfDAO.count(query);
    }

    public ShortUrlConfVO queryByKey(Long key) {
        ShortUrlConfDO entity = this.shortUrlConfRepo.findById(key).orElseGet(ShortUrlConfDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ShortUrlConfVO vo = ShortUrlConfConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlConfVO insert(ShortUrlConfPayload payload) {
        this.check(payload);
        ShortUrlConfQuery query = new ShortUrlConfQuery();
        query.setShortUrlPre(payload.getShortUrlPre());
        query.setLongUrlPre(payload.getLongUrlPre());
        Long tenantId = GlobalUtil.getTenantId();
        query.setSecTenantId(tenantId);
        long count = this.count(query);
        if (count > 0L) {
            throw TwException.error("", "\u91cd\u590d\u6dfb\u52a0");
        }
        ShortUrlConfDO entityDo = ShortUrlConfConvert.INSTANCE.toDo(payload);
        entityDo.setSecTenantId(tenantId);
        return ShortUrlConfConvert.INSTANCE.toVo((ShortUrlConfDO)this.shortUrlConfRepo.save(entityDo));
    }

    private void check(ShortUrlConfPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getShortUrlPre())) {
            throw TwException.error("", "shortUrlPre\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getLongUrlPre())) {
            throw TwException.error("", "longUrlPre\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlConfVO update(ShortUrlConfPayload payload) {
        ShortUrlConfDO entity = this.shortUrlConfRepo.findById(payload.getId()).orElseGet(ShortUrlConfDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ShortUrlConfDO entityDo = ShortUrlConfConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ShortUrlConfConvert.INSTANCE.toVo((ShortUrlConfDO)this.shortUrlConfRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.shortUrlConfDAO.deleteSoft(keys);
        }
    }

    public ShortUrlConfServiceImpl(ShortUrlConfRepo shortUrlConfRepo, ShortUrlConfDAO shortUrlConfDAO) {
        this.shortUrlConfRepo = shortUrlConfRepo;
        this.shortUrlConfDAO = shortUrlConfDAO;
    }
}

