package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 通用文档-文档上传标记
 *
 * @author duwh
 * @date 2023-12-22
 */
@Entity
@Table(name = "prd_business_doc_type_upload_record", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_upload_record", comment = "通用文档-文档上传标记")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypeUploadRecordDO extends BaseModel implements Serializable  {
    /** 单据类型 */
    @Comment("单据类型")
    @Column()
    private String docType;
    /** 单据主键 */
    @Comment("单据主键")
    @Column()
    private Long docId;
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @Comment("文档类型配置主键 prd_business_doc_type_config.id")
    @Column()
    private Long configId;

    public void copy(BusinessDocTypeUploadRecordDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
