package com.elitesland.tw.tw5.server.openapi.sso;

import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 帮我吧
 *
 * @author zoey
 * @date 2023/03/03
 */
@Api("帮我吧SSO")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/bangwo8/sso")
@Slf4j
public class BangWo8SsoController {

    private final PrdUserService prdUserService;

    /**
     * 根据密钥获取签名
     *
     */
    @GetMapping({"/getSign"})
    public TwOutputUtil getTicket() {
        return TwOutputUtil.ok(prdUserService.getBangwo8Sign());
    }

    /**
     * 根据获取免登录动态签名
     *
     */
    @GetMapping({"/getBangwo8LoginFreeSign"})
    public TwOutputUtil getBangwo8LoginFreeSign() {
        return TwOutputUtil.ok(prdUserService.getBangwo8LoginFreeSign());
    }

}
