package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccFinancialSubjectPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccFinancialSubjectQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccFinancialSubjectService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccFinancialSubjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 会计科目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Api(tags = "会计科目管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accFinancialSubject")
@Slf4j
public class AccFinancialSubjectController {

    private final AccFinancialSubjectService accFinancialSubjectService;

    /**
     * 会计科目管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("会计科目管理-新增")
    public TwOutputUtil<AccFinancialSubjectVO> insert(@RequestBody AccFinancialSubjectPayload payload) {
        return TwOutputUtil.ok(accFinancialSubjectService.insert(payload));
    }

    /**
     * 会计科目管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("会计科目管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccFinancialSubjectPayload payload) {
        return TwOutputUtil.ok(accFinancialSubjectService.updateByKeyDynamic(payload));
    }

    /**
     * 会计科目管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("会计科目管理-主键查询")
    public TwOutputUtil<AccFinancialSubjectVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accFinancialSubjectService.queryByKey(key));
    }

    /**
     * 会计科目管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("会计科目管理-分页")
    public TwOutputUtil<PagingVO<AccFinancialSubjectVO>> paging(AccFinancialSubjectQuery query) {
        return TwOutputUtil.ok(accFinancialSubjectService.queryPaging(query));
    }

    /**
     * 会计科目管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("会计科目管理-查询列表")
    public TwOutputUtil<List<AccFinancialSubjectVO>> queryList(AccFinancialSubjectQuery query) {
        return TwOutputUtil.ok(accFinancialSubjectService.queryListDynamic(query));
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/batchExport")
    public void batchExport(HttpServletResponse response, AccFinancialSubjectQuery query) {
        accFinancialSubjectService.downloadPlus(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(MultipartFile file) {
        accFinancialSubjectService.batchImport(file);
        return TwOutputUtil.ok();
    }
//    /**
//     * 会计科目管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("会计科目管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        accFinancialSubjectService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}

