package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author sunxw
 * @description 报销科目配置与核算项目关联表
 * @Date 2023/12/15
 */
@Entity
@Table(name = "acc_reim_item_config_ref", indexes = {
        @Index(name = "idx_reim_item_config_id", columnList = "reim_item_config_id")
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_item_config_ref", comment = "报销科目配置与核算项目关联表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimItemConfigRefDO extends BaseModel implements Serializable {

    @Comment("报销科目配置ID")
    @Column(name = "reim_item_config_id")
    private Long reimItemConfigId;

    @Comment("核算项目")
    @Column()
    private Long busAccItemId;

    @Comment("扩展字段1")
    @Column()
    private String extString1;

    @Comment("扩展字段2")
    @Column()
    private String extString2;

    @Comment("扩展字段3")
    @Column()
    private String extString3;

    public void copy(AccReimItemConfigRefDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
