package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractManagerQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.PurchaseDemandTypeEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailDAO;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetControlType;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetSubjectDetailDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskSettleTimesheetDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus.*;

@Service
@RequiredArgsConstructor
@Slf4j
public class BudgetCommonServiceImpl extends BaseServiceImpl implements BudgetCommonService {
    private final BudgetDAO budgetDAO;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final BudgetSubjectDetailDAO budgetSubjectDetailDAO;
    private final TransactionUtilService transactionUtilService;
    private final ConReceivablePlanService conReceivablePlanService;

    private final PrdSystemRoleDAO daoRole;

    private final PrdMessageConfigService messageConfigService;

    private final ComChangeService changeService;

    private final PmsProjectService pmsProjectService;

    private final BuProjectService buProjectService;

    private final PurchaseContractManagerDAO purchaseContractManagerDAO;

    private final AccSubjectTemplateService accSubjectTemplateService;
    private final TaskInfoDAO taskInfoDAO;
    private final AccReimDAO accReimDAO;
    private final AccReimDetailDAO detailDAO;
    private final TaskSettleTimesheetDAO taskSettleTimesheetDAO;
    private final CacheUtil cacheUtil;

    private final ConPurchaseDemandDService conPurchaseDemandDService;

    private final TimesheetDAO timesheetDAO;

    @Override
    public BudgetVO querySimpleBySource(Long sourceId, String sourceType) {
        if (ObjectUtils.isEmpty(sourceId)) {
            throw TwException.error("", "预算类型ID不能为空 !");
        }
        if (ObjectUtils.isEmpty(sourceType)) {
            throw TwException.error("", "预算类型不能为空 !");
        }
        // 判断预算类型 是否符合要求
        if (!PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(sourceType)
                && !PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(sourceType)
                && !PmsReasonTypeEnum.PROJ_BU.getCode().equals(sourceType)) {
            throw TwException.error("", "预算类型不符合要求 !");
        }
        return budgetDAO.querySimpleBySource(sourceId, sourceType);
    }

    @Override
    public BudgetVO initBudget(Long sourceId, String sourceType) {
        BudgetVO budgetVO = new BudgetVO();
        // 公共信息
        budgetVO.setCreateUserId(GlobalUtil.getLoginUserId());
        budgetVO.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        budgetVO.setVersionNo(0);
        budgetVO.setControlType(BudgetControlType.STIFFNESS.getCode());
        budgetVO.setPlanAmt(BigDecimal.ZERO);
        budgetVO.setPlanEqva(BigDecimal.ZERO);
        budgetVO.setPlanEqvaAmt(BigDecimal.ZERO);
        budgetVO.setTotalAmt(BigDecimal.ZERO);
        // 费用归属Id
        budgetVO.setSourceId(sourceId);
        // 费用归属类型
        budgetVO.setSourceType(sourceType);
        // 添加项目信息
        addProjectInfo(budgetVO);
        return budgetVO;
    }


    @Override
    public void addProjectInfo(BudgetVO budgetVO) {
        Long sourceId = budgetVO.getSourceId();
        String sourceType = budgetVO.getSourceType();
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(sourceType)) {
            PmsProjectVO projectVO = pmsProjectService.querySimpleProjectByKey(sourceId);
            // 费用归属编号
            budgetVO.setSourceCode(projectVO.getProjNo());
            // 费用归属名称
            budgetVO.setSourceName(projectVO.getProjName());
            // 交付部门ID
            budgetVO.setDeliBuId(projectVO.getDeliBuId());
            //签单bu
            budgetVO.setSignBuId(projectVO.getSignBuId());
            // 当量预估单价
            if (ObjectUtils.isEmpty(budgetVO.getEqvaPrice())) {
                budgetVO.setEqvaPrice(projectVO.getEqvaPrice() == null ? new BigDecimal(2000) : projectVO.getEqvaPrice());
            }
            if (budgetVO.getSubjectTempId() == null) {
                // 科目模板ID
                budgetVO.setSubjectTempId(projectVO.getSubjectTempId());
            }
            // 总当量
            budgetVO.setTotalEqva(projectVO.getTotalEqva());
            // 费用总预算
            budgetVO.setTotalReimbursement(projectVO.getTotalReimbursement());
            // 交付负责人ID
            budgetVO.setDeliUserId(projectVO.getDeliUserId());
            // 如果财务年度为空，则设置财务年度为计划开始日期的年份
            if (ObjectUtils.isEmpty(budgetVO.getFinYear())) {
                budgetVO.setFinYear(projectVO.getPlanStartDate() == null ? null : projectVO.getPlanStartDate().getYear() + "");
            }
            // 合同ID
            budgetVO.setContractId(projectVO.getContractId());
            // 合同状态
            budgetVO.setContractStatus(projectVO.getContractStatus());
            // 合同总金额
            budgetVO.setAmt(projectVO.getSumAmt());
            //合同税率
            budgetVO.setTaxRate(projectVO.getTaxRate());
            //平台提成百分比
            budgetVO.setPercentage(projectVO.getPercentage());
            // 有效合同金额
            budgetVO.setEffectiveAmt(projectVO.getEffectiveAmt());
            // 销售负责人ID
            budgetVO.setSaleManUserId(projectVO.getSaleManUserId());
            // 平台类型
            budgetVO.setPlatType(projectVO.getPlatType());
            // 工作类型
            budgetVO.setWorkType(projectVO.getWorkType());
            // PMO资源ID
            budgetVO.setPmoResId(projectVO.getPmoResId());
            //实时获取项目盈亏平衡最大成本
            queryTotalLastCost(budgetVO);

        } else if (PmsReasonTypeEnum.PROJ_BU.getCode().equals(sourceType)) {
            BuProjectVO projectVO = buProjectService.queryByKey(sourceId);
            // 费用归属编号
            budgetVO.setSourceCode(projectVO.getProjNo());
            // 费用归属名称
            budgetVO.setSourceName(projectVO.getProjName());
            // 交付部门ID
            budgetVO.setDeliBuId(projectVO.getDeliBuId());
            // 总当量
            budgetVO.setTotalEqva(projectVO.getTotalEqva());
            // 费用总预算
            budgetVO.setTotalReimbursement(projectVO.getTotalReimbursement());
            // 交付负责人ID
            budgetVO.setDeliUserId(projectVO.getDeliUserId());
            // 如果财务年度为空，则设置财务年度为计划开始日期的年份
            if (ObjectUtils.isEmpty(budgetVO.getFinYear())) {
                budgetVO.setFinYear(projectVO.getPlanStartDate() == null ? null : projectVO.getPlanStartDate().getYear() + "");
            }
        }
        if (ObjectUtils.isEmpty(budgetVO.getBudgetName())) {
            budgetVO.setBudgetName(budgetVO.getSourceName());
        }
        if (ObjectUtils.isEmpty(budgetVO.getEqvaPrice())) {
            budgetVO.setEqvaPrice(new BigDecimal(2000));
        }
    }

    /**
     * 实时获取项目盈亏平衡最大成本
     *
     * @param budgetVO
     */
    void queryTotalLastCost(BudgetVO budgetVO) {
        /**
         * (合同额/(1+税率)-(采购需求金额(待采购)-代理费金额 (合同扣除项)))*(1-平台提成百分比)
         */
        List<ConPurchaseDemandDVO> conPurchaseDemandDVOS = conPurchaseDemandDService.queryListBySaleConIds(Arrays.asList(budgetVO.getContractId()));
        if (!ObjectUtils.isEmpty(conPurchaseDemandDVOS)) {
            List<String> types = Arrays.asList(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode(), PurchaseDemandTypeEnum.AGENCY_FEE.getCode());
            //采购需求 含税总额
            BigDecimal taxAmt = conPurchaseDemandDVOS.stream().filter(vo -> StringUtils.hasText(vo.getDemandType()) && types.contains(vo.getDemandType()))
                    .map(ConPurchaseDemandDVO::getTaxAmt)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal::add)
                    .orElse(BigDecimal.ZERO);

            // 不含税金额= 含税总金额/(1+税率)
            BigDecimal amt = budgetVO.getAmt() == null ? BigDecimal.ZERO : budgetVO.getAmt();   //合同总金额
            BigDecimal taxRate = budgetVO.getTaxRate() == null ? BigDecimal.ZERO : budgetVO.getTaxRate();   //税率
            BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);

            //平台提成百分比
            BigDecimal percentage = budgetVO.getPercentage() == null ? BigDecimal.ZERO : budgetVO.getPercentage().divide(BigDecimal.valueOf(100));
            //项目盈亏平衡最大成本=（合同额/(1+税率)-（代采购+代理费））*（1-平台提成百分比）
            BigDecimal totalLastCost = (notTaxAmt.subtract(taxAmt)).multiply(BigDecimal.ONE.subtract(percentage));
            budgetVO.setTotalLastCost(totalLastCost);
        }

    }

    @Override

    public List<BudgetSubjectDetailVO> queryBySubjectTemplateId(String sourceType, Long subjectTemplateId) {
        if (ObjectUtils.isEmpty(sourceType) || ObjectUtils.isEmpty(subjectTemplateId)) {
            throw TwException.error("", "参数不能为空！");
        }
        // 根据模板 获取科目列表
        List<BudgetSubjectDetailVO> subjectDetailVOS = new ArrayList<>();
        List<AccBudgetItemVO> accTmpldVOS = accSubjectTemplateService.queryBudgetItemList(subjectTemplateId);
        for (AccBudgetItemVO accTmpldVO : accTmpldVOS) {
            BudgetSubjectDetailVO subjectDetailVO = new BudgetSubjectDetailVO();
            subjectDetailVO.setAccId(accTmpldVO.getId());
            subjectDetailVO.setAccParentId(accTmpldVO.getParentId());
            subjectDetailVO.setAccName(accTmpldVO.getBudgetName());
            subjectDetailVO.setBudgetAmt(BigDecimal.ZERO);
            subjectDetailVO.setDetailControlFlag(false);
            subjectDetailVOS.add(subjectDetailVO);
        }
        return subjectDetailVOS;
    }

    @Override
    public List<BudgetCommonVO> queryBudgetEqvaAndAmts(List<String> reasonTypes, List<Long> reasonIds) {
        List<BudgetCommonVO> commonVOList = new ArrayList<>();
        //处理当量相关
        List<TaskSettleTimesheetVO> taskTimesheetVOS = taskSettleTimesheetDAO.queryTaskByReasons(reasonTypes, reasonIds);
        Map<String, List<TaskSettleTimesheetVO>> infoVOSMap = new HashMap<>();
        if (!ObjectUtils.isEmpty(taskTimesheetVOS)) {
            taskTimesheetVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                List<TaskSettleTimesheetVO> taskimesheetVOS1 = infoVOSMap.get(key);
                if (taskimesheetVOS1 == null) {
                    taskimesheetVOS1 = new ArrayList<>();
                }
                taskimesheetVOS1.add(vo);
                infoVOSMap.put(key, taskimesheetVOS1);
            });
            infoVOSMap.forEach((key, taskimesheetVOS2) -> {
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                //当量处理
                queryBudgetEqva(commonVO, taskimesheetVOS2);
                commonVOList.add(commonVO);
            });
        }
        // 批量获取报销费用占用及使用
        queryBudgetBatchReimAmt(reasonTypes, reasonIds, commonVOList);
        // 批量获取工时项目补贴费用占用及使用
        queryhBudgetBatchTimeSheetAmt(reasonTypes, reasonIds, commonVOList);
        //批量获取销售合同采购需求：外包费用占用及使用
        quertyBatchPurchaseDemandAmt(reasonTypes, reasonIds, commonVOList);
        //批量获取采购合同：项目房租&项目成本
        queryBatchPurchaseContractAmt(reasonTypes, reasonIds, commonVOList);
        return commonVOList;
    }

    /**
     * 批量处理华为智通出差申请
     *
     * @param commonVO
     */
    void queryBatchBusitripApplyAmt(BudgetCommonVO commonVO) {

    }

    /**
     * 批量获取采购合同：项目房租&项目成本
     *
     * @param reasonTypes
     * @param reasonIds
     * @param commonVOList
     */
    void queryBatchPurchaseContractAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {
        if (reasonTypes.contains(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
            query.setRelatedProjectIdList(reasonIds);
            List<PurchaseContractManagerVO> purchaseContractManagerVOS = purchaseContractManagerDAO.queryPurContractInfo(query);
            if (!ObjectUtils.isEmpty(purchaseContractManagerVOS)) {
                Map<String, List<PurchaseContractManagerVO>> purchaseContractManagerMap = new HashMap<>();
                purchaseContractManagerVOS.forEach(vo -> {
                    String key = PmsReasonTypeEnum.PROJ_CONTRACT.getCode() + "-" + vo.getRelatedProjectId();
                    List<PurchaseContractManagerVO> purchaseContractManagerVOS1 = purchaseContractManagerMap.get(key);
                    if (purchaseContractManagerVOS1 == null) {
                        purchaseContractManagerVOS1 = new ArrayList<>();
                    }
                    purchaseContractManagerVOS1.add(vo);
                    purchaseContractManagerMap.put(key, purchaseContractManagerVOS1);
                });
                purchaseContractManagerMap.forEach((key, purchaseDemandDVOS1) -> {
                    String[] split = key.split("-");
                    String reasonType = split[0];
                    Long reasonId = Long.valueOf(split[1]);
                    Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                    BudgetCommonVO commonVO;
                    if (first.isPresent()) {
                        commonVO = first.get();
                    } else {
                        commonVO = new BudgetCommonVO();
                        commonVO.setReasonId(reasonId);
                        commonVO.setReasonType(reasonType);
                        commonVOList.add(commonVO);
                    }
                    //金额处理
                    queryPurchaseContractAmt(commonVO, purchaseDemandDVOS1);
                });
            }
        }
    }

    /**
     * 批量获取销售合同采购需求：外包费用占用及使用
     *
     * @param reasonTypes
     * @param reasonIds
     */
    void quertyBatchPurchaseDemandAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {

        if (reasonTypes.contains(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            //只有合同项目有外包采购
            List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryByKeysSimple(reasonIds);
            //合同id-项目id
            Map<Long, Long> conProjIdMap = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, PmsProjectVO::getId));
            if (!conProjIdMap.isEmpty()) {
                //获取项目合同对应的采购数据
                List<ConPurchaseDemandDVO> demandDVOS = conPurchaseDemandDService.queryListBySaleConIds(new ArrayList<>(conProjIdMap.keySet()));
                if (!ObjectUtils.isEmpty(demandDVOS)) {
                    Map<String, List<ConPurchaseDemandDVO>> purchaseDemandDMap = new HashMap<>();
                    demandDVOS.forEach(vo -> {
                        Long reasonId = conProjIdMap.get(vo.getSaleConId());
                        String key = PmsReasonTypeEnum.PROJ_CONTRACT.getCode() + "-" + reasonId;
                        List<ConPurchaseDemandDVO> purchaseDemandDVOS1 = purchaseDemandDMap.get(key);
                        if (purchaseDemandDVOS1 == null) {
                            purchaseDemandDVOS1 = new ArrayList<>();
                        }
                        purchaseDemandDVOS1.add(vo);
                        purchaseDemandDMap.put(key, purchaseDemandDVOS1);
                    });
                    purchaseDemandDMap.forEach((key, purchaseDemandDVOS1) -> {
                        String[] split = key.split("-");
                        String reasonType = split[0];
                        Long reasonId = Long.valueOf(split[1]);
                        Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                        //获取项目对应的合同id
                        PmsProjectVO pmsProjectVO = pmsProjectVOS.stream().filter(vo -> vo.getId().equals(reasonId)).findFirst().get();
                        BudgetCommonVO commonVO;
                        if (first.isPresent()) {
                            commonVO = first.get();
                        } else {
                            commonVO = new BudgetCommonVO();
                            commonVO.setReasonId(reasonId);
                            commonVO.setReasonType(reasonType);
                            commonVOList.add(commonVO);
                        }
                        commonVO.setContractId(pmsProjectVO.getContractId());
                        //金额处理
                        quertyPurchaseDemandAmt(commonVO, purchaseDemandDVOS1);
                    });
                }


            }

        }

    }

    /**
     * 批量获取工时项目补贴费用占用及使用
     *
     * @param reasonTypes
     * @param reasonIds
     */
    void queryhBudgetBatchTimeSheetAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {
        //处理费用金额相关（要考虑当量未占用及使用，但是费用有的情况）
        TimesheetQuery query = new TimesheetQuery();
        query.setReasonTypes(reasonTypes);
        query.setReasonIdList(reasonIds);
        query.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
        List<TimesheetVO> timesheetVOS = timesheetDAO.queryList(query);

        if (!ObjectUtils.isEmpty(timesheetVOS)) {
            Map<String, List<TimesheetVO>> timesheetMap = new HashMap<>();

            timesheetVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                List<TimesheetVO> timesheetVOS1 = timesheetMap.get(key);
                if (timesheetVOS1 == null) {
                    timesheetVOS1 = new ArrayList<>();
                }
                timesheetVOS1.add(vo);
                timesheetMap.put(key, timesheetVOS1);
            });
            timesheetMap.forEach((key, timesheetVOS1) -> {
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                BudgetCommonVO commonVO;
                if (first.isPresent()) {
                    commonVO = first.get();
                } else {
                    commonVO = new BudgetCommonVO();
                    commonVO.setReasonId(reasonId);
                    commonVO.setReasonType(reasonType);
                    commonVOList.add(commonVO);
                }
                //金额处理
                queryBudgetTimeSheetAmt(commonVO, timesheetVOS1);
            });
        }
    }

    /**
     * 批量获取报销费用占用及使用
     *
     * @param reasonTypes
     * @param reasonIds
     */
    void queryBudgetBatchReimAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {
        //处理费用金额相关（要考虑当量未占用及使用，但是费用有的情况）
        AccReimQuery query = new AccReimQuery();
        query.setReasonIdList(reasonIds);
        query.setReasonTypeList(reasonTypes);
        List<AccReimVO> accReimVOS = accReimDAO.queryListDynamic(query);
        Map<String, List<AccReimVO>> accReimVOSMap = new HashMap<>();
        if (!ObjectUtils.isEmpty(accReimVOS)) {
            accReimVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                List<AccReimVO> accReimVOS1 = accReimVOSMap.get(key);
                if (accReimVOS1 == null) {
                    accReimVOS1 = new ArrayList<>();
                }
                accReimVOS1.add(vo);
                accReimVOSMap.put(key, accReimVOS1);
            });
            accReimVOSMap.forEach((key, accReimVOS1) -> {
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                BudgetCommonVO commonVO;
                if (first.isPresent()) {
                    commonVO = first.get();
                } else {
                    commonVO = new BudgetCommonVO();
                    commonVO.setReasonId(reasonId);
                    commonVO.setReasonType(reasonType);
                    commonVOList.add(commonVO);
                }
                //金额处理
                queryBudgetReimAmt(commonVO, accReimVOS1);
            });
        }
    }


    @Override
    public BudgetCommonVO queryBudgetEqvaAndAmt(BudgetCommonVO commonVO) {
        //计算当量占用及使用
        queryBudgetEqva(commonVO, null);
        //获取报销费用占用及使用
        queryBudgetReimAmt(commonVO, null);
        //工时项目补贴费用占用及使用
        queryBudgetTimeSheetAmt(commonVO, null);
        //合同采购需求：外包费用占用及使用
        quertyPurchaseDemandAmt(commonVO, null);
        //采购合同：项目房租&项目成本费用占用及使用
        queryPurchaseContractAmt(commonVO, null);
        //华为智通出差申请费用占用及使用
        queryBusitripApplyAmt(commonVO);
        return commonVO;
    }

    /**
     * 华为智通出差申请
     *
     * @param commonVO
     */
    void queryBusitripApplyAmt(BudgetCommonVO commonVO) {

    }

    /**
     * 采购合同：项目房租&项目成本
     *
     * @param commonVO
     * @param purchaseContractManagerVOS
     */
    void queryPurchaseContractAmt(BudgetCommonVO commonVO, List<PurchaseContractManagerVO> purchaseContractManagerVOS, Long... purchaseContractId) {
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(commonVO.getReasonType())) {
            //合同项目要获取该项值
            if (ObjectUtils.isEmpty(purchaseContractManagerVOS)) {
                PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
                query.setRelatedProjectId(commonVO.getReasonId());
                purchaseContractManagerVOS = purchaseContractManagerDAO.queryPurContractInfo(query);
                if (purchaseContractId != null && purchaseContractId.length > 0) {
                    purchaseContractManagerVOS = purchaseContractManagerVOS.stream().filter(vo -> !vo.getId().equals(purchaseContractId[0])).collect(Collectors.toList());
                }
            }
            if (!ObjectUtils.isEmpty(purchaseContractManagerVOS)) {

                log.info("采购合同：项目房租&项目成本占用及使用-前：{}", commonVO);
                //占用金额=非新建和报销完成的和
                BigDecimal occupyAmt = commonVO.getOccupyAmt();
                //科目占用金额
                Map<Long, BigDecimal> accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
                //已使用金额=报销完成和
                BigDecimal usedAmt = commonVO.getUsedAmt();
                //科目使用金额
                Map<Long, BigDecimal> accUsedAmtMap = commonVO.getAccUsedAmtMap();
                //排除新建，作废，驳回
                List<String> status = Arrays.asList("reject", "invalid", "create");
                //房屋租赁
                List<PurchaseContractManagerVO> rents = purchaseContractManagerVOS.stream().filter(vo ->
                        !status.contains(vo.getContractStatus()) &&
                                vo.getBusinessType().equals(PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode())

                ).collect(Collectors.toList());

                //---- 房屋租赁占用和使用
                if (!ObjectUtils.isEmpty(rents)) {
                    //项目房租
                    PrdSystemSelectionVO systemSelection3 = cacheUtil.getSystemSelection("ACC:SUBJECT:REF3");
                    Long budgetItemId3 = 0L;
                    if (systemSelection3 != null && StringUtils.hasText(systemSelection3.getExtString1())) {
                        budgetItemId3 = Long.valueOf(systemSelection3.getExtString1());
                    }

                    //房屋租赁占用
                    BigDecimal amt = rents.stream()
                            .map(PurchaseContractManagerVO::getAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);

                    //房屋租赁使用金额（付款记录付款金额）
                    BigDecimal useAmt = rents.stream()
                            .map(PurchaseContractManagerVO::getPaymentAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);
                    //占用
                    occupyAmt = occupyAmt.add(amt);
                    //使用
                    usedAmt = usedAmt.add(useAmt);

                    BigDecimal accUsedAmt = accUsedAmtMap.get(budgetItemId3);
                    if (accUsedAmt == null) {
                        accUsedAmt = BigDecimal.ZERO;
                    }
                    accUsedAmtMap.put(budgetItemId3, accUsedAmt.add(useAmt));

                    BigDecimal accOccupyAmt = accOccupyAmtMap.get(budgetItemId3);
                    if (accOccupyAmt == null) {
                        accOccupyAmt = BigDecimal.ZERO;
                    }
                    accOccupyAmtMap.put(budgetItemId3, accOccupyAmt.add(amt));

                }
                //--- 项目成本
                List<PurchaseContractManagerVO> costs = purchaseContractManagerVOS.stream().filter(vo ->
                        !status.contains(vo.getContractStatus()) &&
                                vo.getBusinessType().equals(PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode())
                ).collect(Collectors.toList());
                // 项目成本占用和使用
                if (!ObjectUtils.isEmpty(costs)) {
                    //项目房租
                    PrdSystemSelectionVO systemSelection4 = cacheUtil.getSystemSelection("ACC:SUBJECT:REF4");
                    Long budgetItemId4 = 0L;
                    if (systemSelection4 != null && StringUtils.hasText(systemSelection4.getExtString1())) {
                        budgetItemId4 = Long.valueOf(systemSelection4.getExtString1());
                    }
                    //房屋租赁占用
                    BigDecimal amt = rents.stream()
                            .map(PurchaseContractManagerVO::getAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);

                    //房屋租赁使用金额（付款记录付款金额）
                    BigDecimal useAmt = rents.stream()
                            .map(PurchaseContractManagerVO::getPaymentAmt)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal::add)
                            .orElse(BigDecimal.ZERO);
                    //占用
                    occupyAmt = occupyAmt.add(amt);
                    //使用
                    usedAmt = usedAmt.add(useAmt);

                    BigDecimal accUsedAmt = accUsedAmtMap.get(budgetItemId4);
                    if (accUsedAmt == null) {
                        accUsedAmt = BigDecimal.ZERO;
                    }
                    accUsedAmtMap.put(budgetItemId4, accUsedAmt.add(useAmt));

                    BigDecimal accOccupyAmt = accOccupyAmtMap.get(budgetItemId4);
                    if (accOccupyAmt == null) {
                        accOccupyAmt = BigDecimal.ZERO;
                    }
                    accOccupyAmtMap.put(budgetItemId4, accOccupyAmt.add(amt));
                }

                commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
                commonVO.setAccUsedAmtMap(accUsedAmtMap);
                commonVO.setOccupyAmt(occupyAmt);
                commonVO.setUsedAmt(usedAmt);
                log.info("采购合同：项目房租&项目成本占用及使用-后：{}", commonVO);
            }
        }

    }

    /**
     * 销售合同采购需求：外包
     *
     * @param commonVO
     * @param conPurchaseDemandDVOS
     */
    void quertyPurchaseDemandAmt(BudgetCommonVO commonVO, List<ConPurchaseDemandDVO> conPurchaseDemandDVOS) {

        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(commonVO.getReasonType())) {

            if (ObjectUtils.isEmpty(conPurchaseDemandDVOS)) {
                //合同项目要获取该项值
                conPurchaseDemandDVOS = conPurchaseDemandDService.queryListBySaleConIds(Arrays.asList(commonVO.getContractId()));
            }
            log.info("销售合同采购需求：外包占用及使用-前：{}", commonVO);
            //占用金额=非新建和报销完成的和
            BigDecimal occupyAmt = commonVO.getOccupyAmt();
            //科目占用金额
            Map<Long, BigDecimal> accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
            //已使用金额=报销完成和
            BigDecimal usedAmt = commonVO.getUsedAmt();
            //科目使用金额
            Map<Long, BigDecimal> accUsedAmtMap = commonVO.getAccUsedAmtMap();
            if (!ObjectUtils.isEmpty(conPurchaseDemandDVOS)) {
                PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("ACC:SUBJECT:REF2");
                Long budgetItemId = 0L;
                if (systemSelection != null && StringUtils.hasText(systemSelection.getExtString1())) {
                    budgetItemId = Long.valueOf(systemSelection.getExtString1());
                }

                //采购需求外包 含税总额
                BigDecimal taxAmt = conPurchaseDemandDVOS.stream().filter(vo -> StringUtils.hasText(vo.getDemandType()) && PurchaseDemandTypeEnum.OUTSOURCING.getCode().equals(vo.getDemandType()))
                        .map(ConPurchaseDemandDVO::getTaxAmt)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal::add)
                        .orElse(BigDecimal.ZERO);

                usedAmt = usedAmt.add(taxAmt);
                occupyAmt = occupyAmt.add(taxAmt);

                BigDecimal accUsedAmt = accUsedAmtMap.get(budgetItemId);
                if (accUsedAmt == null) {
                    accUsedAmt = BigDecimal.ZERO;
                }
                accUsedAmtMap.put(budgetItemId, accUsedAmt.add(taxAmt));
                BigDecimal accOccupyAmt = accOccupyAmtMap.get(budgetItemId);
                if (accOccupyAmt == null) {
                    accOccupyAmt = BigDecimal.ZERO;
                }
                accOccupyAmtMap.put(budgetItemId, accOccupyAmt.add(taxAmt));

                commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
                commonVO.setAccUsedAmtMap(accUsedAmtMap);
                commonVO.setOccupyAmt(occupyAmt);
                commonVO.setUsedAmt(usedAmt);
                log.info("销售合同采购需求：外包占用及使用-后：{}", commonVO);
            }
        }

    }

    //工时项目补贴预算
    void queryBudgetTimeSheetAmt(BudgetCommonVO commonVO, List<TimesheetVO> timesheetVOS) {
        if (ObjectUtils.isEmpty(timesheetVOS)) {
            TimesheetQuery query = new TimesheetQuery();
            query.setReasonType(commonVO.getReasonType());
            query.setReasonId(commonVO.getReasonId());
            query.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
            timesheetVOS = timesheetDAO.queryList(query);

        }
        log.info("获工时项目补贴占用及使用-前：{}", commonVO);
        //占用金额=非新建和报销完成的和
        BigDecimal occupyAmt = commonVO.getOccupyAmt();
        //科目占用金额
        Map<Long, BigDecimal> accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
        //已使用金额=报销完成和
        BigDecimal usedAmt = commonVO.getUsedAmt();
        //科目使用金额
        Map<Long, BigDecimal> accUsedAmtMap = commonVO.getAccUsedAmtMap();
        if (!ObjectUtils.isEmpty(timesheetVOS)) {
            PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("ACC:SUBJECT:REF1");
            Long budgetItemId = 0L;
            if (systemSelection != null && StringUtils.hasText(systemSelection.getExtString1())) {
                budgetItemId = Long.valueOf(systemSelection.getExtString1());
            }
            BigDecimal taxAmt = timesheetVOS.stream()
                    .map(TimesheetVO::getSubsidyAmt)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal::add)
                    .orElse(BigDecimal.ZERO);

            usedAmt = usedAmt.add(taxAmt);
            occupyAmt = occupyAmt.add(taxAmt);

            BigDecimal accUsedAmt = accUsedAmtMap.get(budgetItemId);
            if (accUsedAmt == null) {
                accUsedAmt = BigDecimal.ZERO;
            }
            accUsedAmtMap.put(budgetItemId, accUsedAmt.add(taxAmt));
            BigDecimal accOccupyAmt = accOccupyAmtMap.get(budgetItemId);
            if (accOccupyAmt == null) {
                accOccupyAmt = BigDecimal.ZERO;
            }
            accOccupyAmtMap.put(budgetItemId, accOccupyAmt.add(taxAmt));

            commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
            commonVO.setAccUsedAmtMap(accUsedAmtMap);
            commonVO.setOccupyAmt(occupyAmt);
            commonVO.setUsedAmt(usedAmt);
            log.info("获工时项目补贴占用及使用-后：{}", commonVO);

        }

    }

    /**
     * 获取报销费用占用及使用
     *
     * @param commonVO
     */
    void queryBudgetReimAmt(BudgetCommonVO commonVO, List<AccReimVO> accReimVOS, Long... reimId) {
        if (ObjectUtils.isEmpty(accReimVOS)) {

            AccReimQuery query = new AccReimQuery();
            query.setReasonId(commonVO.getReasonId());
            query.setReasonType(commonVO.getReasonType());
            if (reimId != null && reimId.length > 0) {
                query.setNotId(reimId[0]);
            }
            query.setNotReimStatusList(Arrays.asList(AccReimDocStatusEnum.CREATE.getCode()));
            accReimVOS = accReimDAO.queryListDynamic(query);
        }
        log.info("获取报销费用占用及使用-前：{}", commonVO);
        //占用金额=非新建和报销完成的和
        BigDecimal occupyAmt = commonVO.getOccupyAmt();
        //科目占用金额
        Map<Long, BigDecimal> accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
        //已使用金额=报销完成和
        BigDecimal usedAmt = commonVO.getUsedAmt();
        //科目使用金额
        Map<Long, BigDecimal> accUsedAmtMap = commonVO.getAccUsedAmtMap();

        if (!ObjectUtils.isEmpty(accReimVOS)) {
            List<Long> reimIds = accReimVOS.stream().filter(vo -> !vo.getReimStatus().equals(AccReimDocStatusEnum.CREATE.getCode())).map(AccReimVO::getId).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(reimIds)) {
                List<AccReimDetailVO> accReimDetailVOS = detailDAO.queryByMasIds(reimIds);
                //使用明细
                List<AccReimDetailVO> usedDetails = new ArrayList<>();
                //占用明细
                List<AccReimDetailVO> occupyDetails = new ArrayList<>();

                accReimVOS.forEach(vo -> {
                    List<AccReimDetailVO> details = accReimDetailVOS.stream().filter(detailVO -> detailVO.getMasId().equals(vo.getId())).collect(Collectors.toList());
                    //占用=所有产生的报销
                    occupyDetails.addAll(details);
                    if (vo.getReimStatus().equals(AccReimDocStatusEnum.APPROVED.getCode())) {
                        usedDetails.addAll(details);
                    }
//                    else {
//                        occupyDetails.addAll(details);
//                    }
                });
                for (AccReimDetailVO infoVO : usedDetails) {
                    BigDecimal amt = infoVO.getReimAmt();
                    if (infoVO.getAdjustAmt() != null) {
                        amt = infoVO.getAdjustAmt();
                    }
                    usedAmt = usedAmt.add(amt);
                    if (infoVO.getBudgetItemId() != null) {
                        BigDecimal accUsedAmt = accUsedAmtMap.get(infoVO.getBudgetItemId());
                        if (accUsedAmt == null) {
                            accUsedAmt = BigDecimal.ZERO;
                        }
                        accUsedAmtMap.put(infoVO.getBudgetItemId(), accUsedAmt.add(amt));
                    }
                }

                for (AccReimDetailVO infoVO : occupyDetails) {
                    BigDecimal amt = infoVO.getReimAmt();
                    if (infoVO.getAdjustAmt() != null) {
                        amt = infoVO.getAdjustAmt();
                    }

                    occupyAmt = occupyAmt.add(amt);
                    if (infoVO.getBudgetItemId() != null) {
                        BigDecimal accOccupyAmt = accOccupyAmtMap.get(infoVO.getBudgetItemId());
                        if (accOccupyAmt == null) {
                            accOccupyAmt = BigDecimal.ZERO;
                        }
                        accOccupyAmtMap.put(infoVO.getBudgetItemId(), accOccupyAmt.add(amt));
                    }
                }
            }

        }
        commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
        commonVO.setAccUsedAmtMap(accUsedAmtMap);
        commonVO.setOccupyAmt(occupyAmt);
        commonVO.setUsedAmt(usedAmt);

        log.info("获取报销费用占用及使用-后：{}", commonVO);
    }

    /**
     * 获取当量占用及使用
     *
     * @param commonVO
     */
    @Override
    public void queryBudgetEqva(BudgetCommonVO commonVO, List<TaskSettleTimesheetVO> taskTimesheetVOS) {
        if (taskTimesheetVOS == null) {
            taskTimesheetVOS = taskSettleTimesheetDAO.queryTaskByReason(commonVO.getReasonType(), commonVO.getReasonId());
        }
        //占用当量=任务总当量
        BigDecimal occupyEqva = BigDecimal.ZERO;
        //已使用当量=已使用量和
        BigDecimal usedEqva = BigDecimal.ZERO;
        //活动占用当量
        Map<Long, BigDecimal> actOccupyEqvaMap = new HashMap<>();
        //活动使用当量
        Map<Long, BigDecimal> actUsedEqvaMap = new HashMap<>();
        if (!ObjectUtils.isEmpty(taskTimesheetVOS)) {
            for (TaskSettleTimesheetVO infoVO : taskTimesheetVOS) {
                BigDecimal totalEqva = infoVO.getEqva();
                occupyEqva = occupyEqva.add(totalEqva);
                BigDecimal useEqva = infoVO.getEqva() == null ? BigDecimal.ZERO : infoVO.getEqva();
                usedEqva = usedEqva.add(useEqva);

                if (infoVO.getRelatedActId() != null) {
                    BigDecimal actOccupyEqva = actOccupyEqvaMap.get(infoVO.getRelatedActId());
                    if (actOccupyEqva == null) {
                        actOccupyEqva = BigDecimal.ZERO;
                    }
                    actOccupyEqvaMap.put(infoVO.getRelatedActId(), actOccupyEqva.add(totalEqva));
                    BigDecimal actUsedEqva = actUsedEqvaMap.get(infoVO.getRelatedActId());
                    if (actUsedEqva == null) {
                        actUsedEqva = BigDecimal.ZERO;
                    }
                    actUsedEqvaMap.put(infoVO.getRelatedActId(), actUsedEqva.add(usedEqva));

                }
            }
        }
        commonVO.setActOccupyEqvaMap(actOccupyEqvaMap);
        commonVO.setActUsedEqvaMap(actUsedEqvaMap);
        commonVO.setOccupyEqva(occupyEqva);
        commonVO.setUsedEqva(usedEqva);
    }


    ////////////////////////TODO/////////////////////////////////////////////////////////
    @Override
    public void countTotalChange(BudgetVO budgetVO) {
        if (budgetVO.getVersionNo() != null && budgetVO.getVersionNo() > 0) {
            budgetVO.setPlanAmtChange(budgetVO.getPlanAmt().subtract(budgetVO.getOriginalPlanAmt()));
            budgetVO.setPlanEqvaChange(budgetVO.getPlanEqva().subtract(budgetVO.getOriginalPlanEqva()));
            budgetVO.setPlanEqvaAmtChange(budgetVO.getPlanEqvaAmt().subtract(budgetVO.getOriginalPlanEqvaAmt()));
            budgetVO.setTotalAmtChange(budgetVO.getTotalAmt().subtract(budgetVO.getOriginalTotalAmt()));
        } else {
            budgetVO.setPlanAmtChange(BigDecimal.ZERO);
            budgetVO.setPlanEqvaChange(BigDecimal.ZERO);
            budgetVO.setPlanEqvaAmtChange(BigDecimal.ZERO);
            budgetVO.setTotalAmtChange(BigDecimal.ZERO);
        }
    }

    ///////////////////////////////////////////////////////////////////

    @Override
    public BigDecimal getReceivedRate(Long saleConId) {
        // 累计收款比例=所有收款的已收款金额之和/所有收款的当期收款金额之和
        List<ConReceivablePlanVO> receivablePlanVOS = conReceivablePlanService.queryBySaleConId(saleConId);
        // 当期收款金额
        BigDecimal receAmt = receivablePlanVOS.stream().filter(v -> !ObjectUtils.isEmpty(v.getReceAmt())).map(ConReceivablePlanVO::getReceAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        // 已收款金额
        BigDecimal alreadyReceAmt = receivablePlanVOS.stream().map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal receivedRate = BigDecimal.ZERO;
        if (receAmt.doubleValue() > 0) {
            receivedRate = alreadyReceAmt.divide(receAmt, 4, RoundingMode.HALF_UP);
        }
        return receivedRate;
    }

//    //    @Override
//    public BigDecimal getAllocatedProportion(BudgetAppropriationPayload payload, Long budgetId) {
//        // 累计拨付比例=累计拨付审批通过的金额/预算总金额
//        BudgetVO budgetVO = budgetDAO.queryByKey(budgetId);
//        //要包含本次提交的拨付相关金额数据
//        budgetVO.setAllocatedEqva(getValue(budgetVO.getAllocatedEqva()).add(getValue(payload.getApplyEqva())));
//        budgetVO.setAllocatedEqvaAmt(getValue(budgetVO.getAllocatedEqvaAmt()).add(getValue(payload.getApplyEqvaAmt())));
//        budgetVO.setAllocatedAmt(getValue(budgetVO.getAllocatedAmt()).add(getValue(payload.getApplyFeeAmt())));
//        budgetVO.setAllocatedTotalAmt(getValue(budgetVO.getAllocatedTotalAmt()).add(getValue(payload.getApplyAmt())));
//        getAppropriationInfo(budgetVO);
//        log.info("budgetVO拨付数据 :" + budgetVO.toString());
//        return budgetVO.getAllocatedAppropriation();
//    }

    BigDecimal getValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }
//
//    @Override
//    public void getAppropriationInfo(BudgetVO budgetVO) {
//        if (ObjectUtils.isEmpty(budgetVO.getAllocatedAmt())) {
//            budgetVO.setAllocatedAmt(BigDecimal.ZERO);
//        }
//        if (ObjectUtils.isEmpty(budgetVO.getAllocatedEqva())) {
//            budgetVO.setAllocatedEqva(BigDecimal.ZERO);
//            budgetVO.setAllocatedEqvaAmt(BigDecimal.ZERO);
//        }
//        if (ObjectUtils.isEmpty(budgetVO.getAllocatedTotalAmt())) {
//            budgetVO.setAllocatedTotalAmt(BigDecimal.ZERO);
//        }
//
//        //计算剩余可拨付当量、剩余可拨付费用、累计拨付比例
//        budgetVO.setRemainingEqva(budgetVO.getPlanEqva().subtract(budgetVO.getAllocatedEqva()));
//        budgetVO.setRemainingAmt(budgetVO.getPlanAmt().subtract(budgetVO.getAllocatedAmt()));
//        if (budgetVO.getTotalAmt().compareTo(BigDecimal.ZERO) > 0) {
//            budgetVO.setAllocatedAppropriation(budgetVO.getAllocatedTotalAmt().divide(budgetVO.getTotalAmt(), 4, RoundingMode.HALF_UP));
//        } else {
//            budgetVO.setAllocatedAppropriation(BigDecimal.ZERO);
//        }
//
//    }
//
//    @Override
//    @Transactional
//    public void updateAppropriationInfo(Long budgetId) {
//        BigDecimal allocatedAmt = BigDecimal.ZERO;
//        BigDecimal allocatedEqva = BigDecimal.ZERO;
//        BigDecimal allocatedEqvaAmt = BigDecimal.ZERO;
//        BigDecimal allocatedTotalAmt = BigDecimal.ZERO;
//        BudgetAppropriationQuery appropriationQuery = new BudgetAppropriationQuery();
//        appropriationQuery.setBudgetId(budgetId);
//        appropriationQuery.setAppropriationStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//        List<BudgetAppropriationVO> appropriationVOS = budgetAppropriationDAO.queryListDynamic(appropriationQuery);
//        for (BudgetAppropriationVO appropriationVO : appropriationVOS) {
//            allocatedAmt = allocatedAmt.add(appropriationVO.getApplyFeeAmt());
//            allocatedEqva = allocatedEqva.add(appropriationVO.getApplyEqva());
//            allocatedEqvaAmt = allocatedEqvaAmt.add(appropriationVO.getApplyEqvaAmt());
//            allocatedTotalAmt = allocatedTotalAmt.add(appropriationVO.getApplyAmt());
//        }
//        // 更新预算拨付相关金额 将上面四个计算结果更新到预算表中
//        budgetDAO.updateAllocatedAmt(budgetId, allocatedAmt, allocatedEqva, allocatedEqvaAmt, allocatedTotalAmt);
//    }


    //    /**
//     * 预算相关流程审批完成后，涉及到知会财务相关人员的，在TW5.0里放到消息通知-业务提醒中
//     *
//     * @param objectId
//     * @param messageTitle
//     */
//    @Override
//    public void messNotice(Long objectId, String messageTitle) {
//        PrdSystemRoleVO roleVO = daoRole.queryByCode("1000");
//        PrdMessageConfigPayload payload = new PrdMessageConfigPayload();
//        payload.setObjectId(objectId);
//        payload.setMessageTitle(messageTitle);
//        payload.setMessageType(2);
//        payload.setContentBigType("businessMessage");
//        payload.setContentType("financeMessage");
//        payload.setMessageTag("important");
//
//        payload.setNoticeScope("appoint_role");
//        payload.setNoticeSource(roleVO.getId() + "");
//        payload.setNoticeWay("instation");
//
//        payload.setReleaseSource("profileMessage");
//        payload.setCreateSource("系统管理员");
//        payload.setReleaseStatus(3);
//
//        //保存信息
//        PrdMessageConfigVO configVO = messageConfigService.insert(payload);
//        //发布信息
//        messageConfigService.releaseMessage(Arrays.asList(configVO));
//    }
    @Override
    public void checkOnlyOneProc(BudgetVO budgetVO) {
        // 查看是否还有 预算审批流程 和 拨付流程
        if (!ObjectUtils.isEmpty(budgetVO.getProcInstId()) && !WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
            throw TwException.error("", "第一次预算审批流程还未走完，不允许再次申请");
        }
        ComChangeQuery changeQuery = new ComChangeQuery();
        changeQuery.setChangeType(ChangeTypeEnum.BUDGET_CHANGE.getCode());
        changeQuery.setChangeDocId(budgetVO.getId().toString());
        List<ComChangeVO> changeVOS = changeService.changeSearch(changeQuery);
        long count = changeVOS.stream().filter(v -> !ObjectUtils.isEmpty(v.getApprProcInstId()) && !WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(v.getChangeStatus())).count();
        if (count > 0) {
            throw TwException.error("", "上一次的预算变更流程还未走完，不允许再次变更");
        }

    }

//    /**
//     * 获取 验证参数
//     *
//     * @param budgetId
//     * @param contractId
//     * @return
//     */
//    @Override
//    public Map<String, Object> getCheckParam(BudgetAppropriationPayload payload, Long budgetId, Long contractId) {
//        Map<String, Object> variables = new HashMap<>(4);
//
//        // 累计拨付比例=累计拨付审批通过的金额/（可用当量预算总数*当量单价+可用费用预算总金额）
//        BigDecimal allocatedProportion = getAllocatedProportion(payload, budgetId);
//        // 累计收款比例
//        BigDecimal receivedRate = getReceivedRate(contractId);
//        // 比例差 = 累计拨付比例-累计收款比例
//        BigDecimal dRate = allocatedProportion.subtract(receivedRate);
//
//        log.info("比例差dRate:" + dRate + " /累计拨付比例:" + allocatedProportion + " /累计收款比例:" + receivedRate);
//        // 累计拨付比例 <= 累计收款比例
//        variables.put("check1", dRate.compareTo(BigDecimal.ZERO) <= 0);
////        if (dRate.compareTo(BigDecimal.ZERO) <= 0) {
////            throw TwException.error("", "测试流程，暂时不可拨付");
////        }
//        // 0 < 比例差 < 0.05
//        variables.put("check2", dRate.compareTo(BigDecimal.ZERO) > 0 && dRate.compareTo(new BigDecimal(0.05)) < 0);
//        // 0.05 <= 比例差 <= 0.1
//        variables.put("check3", dRate.compareTo(new BigDecimal(0.05)) >= 0 && dRate.compareTo(new BigDecimal(0.1)) <= 0);
//        // 0.1 < 比例差
//        variables.put("check4", dRate.compareTo(new BigDecimal(0.1)) > 0);
//
//        return variables;
//    }

    @Override
    public Boolean isInnerProject(String platType) {
        return SaleConEnum.FICTITIOUS.getCode().equals(platType);
    }

//    @Override
//    public Boolean isOuterProject(String platType) {
//        return SaleConEnum.INTERNAL.getCode().equals(platType) ||
//                SaleConEnum.EXTERNAL.getCode().equals(platType);
//    }

    @Override
    public Boolean isExternalProject(String platType) {
        return SaleConEnum.INTERNAL.getCode().equals(platType) ||
                SaleConEnum.EXTERNAL.getCode().equals(platType) ||
                SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType);
    }

    @Override
    public Boolean isExternalContractProject(String platType, String contractStatus) {
        return isExternalProject(platType) && "ACTIVE".equals(contractStatus);
    }

    @Override
    public Boolean isExternalNoContractProject(String platType, String contractStatus) {
        return SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType) && "ACTIVE_WAITING".equals(contractStatus);
    }


    @Override
    public void countCurrentChange(BudgetVO currentVersionBudge) {
        BudgetVO budgetVO = budgetDAO.queryByKey(currentVersionBudge.getId());

        // 本次变更值
        currentVersionBudge.setCurrentPlanAmtChange(currentVersionBudge.getPlanAmt().subtract(budgetVO.getPlanAmt()));
        currentVersionBudge.setCurrentPlanEqvaChange(currentVersionBudge.getPlanEqva().subtract(budgetVO.getPlanEqva()));
        currentVersionBudge.setCurrentPlanEqvaAmtChange(currentVersionBudge.getPlanEqvaAmt().subtract(budgetVO.getPlanEqvaAmt()));
        currentVersionBudge.setCurrentTotalAmtChange(currentVersionBudge.getTotalAmt().subtract(budgetVO.getTotalAmt()));

        // 累计变更值
        currentVersionBudge.setPlanAmtChange(currentVersionBudge.getPlanAmt().subtract(budgetVO.getOriginalPlanAmt()));
        currentVersionBudge.setPlanEqvaChange(currentVersionBudge.getPlanEqva().subtract(budgetVO.getOriginalPlanEqva()));
        currentVersionBudge.setPlanEqvaAmtChange(currentVersionBudge.getPlanEqvaAmt().subtract(budgetVO.getOriginalPlanEqvaAmt()));
        currentVersionBudge.setTotalAmtChange(currentVersionBudge.getTotalAmt().subtract(budgetVO.getOriginalTotalAmt()));
    }

    @Override
    public void checkBudgetEqva(Long reasonId, String reasonType, Long relatedActId, BigDecimal eqva) {
        // 只有预算状态在执行中 ，才可以创建任务包
        if (ObjectUtils.isEmpty(reasonType)) {
            throw TwException.error("", "事由类型不可为空");
        }
        //仅合同项目校验预算
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            BudgetVO budgetVO = querySimpleBySource(reasonId, reasonType);
            if (ObjectUtils.isEmpty(budgetVO)) {
                throw TwException.error("", "预算不存在，请核验！");
            }
            if (!WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "预算还未审批通过，请核验！");
            }
            //先判断总预算是否控制
            if (BudgetControlType.STIFFNESS.getCode().equals(budgetVO.getControlType())) {
                if (ObjectUtils.isEmpty(budgetVO.getPlanEqva())) {
                    throw TwException.error("", "该项目预算当量不足，请核验！");
                }
                //获取当量占用使用
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                queryBudgetEqva(commonVO, null);
                // 剩余可用当量 = 已拨付的当量 - 占用当量数 - 已使用当量数
                if (eqva.compareTo(budgetVO.getPlanEqva().subtract(commonVO.getOccupyEqva()).subtract(commonVO.getUsedEqva())) > 0) {
                    throw TwException.error("", "该项目预算当量不足，请核验！");
                }
                /**
                 * 明细控制触发机制
                 * 1.活动id非空
                 * 2.合同项目
                 * 3.项目预算是刚性控制
                 * 4.明细控制
                 */
                if (!ObjectUtils.isEmpty(relatedActId)) {
                    PmsProjectActivityVO activityVO = pmsProjectActivityService.queryByKey(relatedActId);
                    // 先判断 明细控制开关开启
                    if (!ObjectUtils.isEmpty(activityVO.getDetailControlFlag()) && activityVO.getDetailControlFlag()) {
                        if (ObjectUtils.isEmpty(activityVO.getPlanEqva())) {
                            throw TwException.error("", "该活动预算当量，请核验！");
                        }
                        BigDecimal actUsedEqva = commonVO.getActUsedEqvaMap().get(relatedActId) == null ? BigDecimal.ZERO : commonVO.getActUsedEqvaMap().get(relatedActId);
                        BigDecimal actOccupyEqva = commonVO.getActOccupyEqvaMap().get(relatedActId) == null ? BigDecimal.ZERO : commonVO.getActOccupyEqvaMap().get(relatedActId);
                        // 剩余可用当量 = 已拨付的当量 - 占用当量数 - 已使用当量数
                        if (eqva.compareTo(activityVO.getPlanEqva().subtract(actOccupyEqva).subtract(actUsedEqva)) > 0) {
                            log.info("派发当量:" + eqva + " /已拨付当量：" + activityVO.getAllocateEqva() + " /占用当量：" + actOccupyEqva + " /使用当量：" + actUsedEqva);
                            throw TwException.error("", "该活动预算当量不足，请核验！");
                        }
                    }
                }
            }

        }
    }

    @Override
    public void checkBudgetReimAmt(Long reasonId, String reasonType, Long budgetItemId, BigDecimal amt, Long...
            reimId) {
        if (ObjectUtils.isEmpty(reasonType)) {
            throw TwException.error("", "事由类型不可为空");
        }
        //仅合同项目校验预算
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            BudgetVO budgetVO = querySimpleBySource(reasonId, reasonType);
            if (ObjectUtils.isEmpty(budgetVO)) {
                throw TwException.error("", "预算不存在，请核验！");
            }
            if (!WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "预算还未审批通过，请核验！");
            }
            //先判断总预算是否控制
            if (BudgetControlType.STIFFNESS.getCode().equals(budgetVO.getControlType())) {
                if (ObjectUtils.isEmpty(budgetVO.getPlanAmt())) {
                    throw TwException.error("", "预算费用金额不足，请核验！");
                }
                //获取当量占用使用
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                queryBudgetReimAmt(commonVO, null, reimId);
                // 剩余可用金额 = 已拨付的金额- 占用金额数 - 已使用金额数
                if (amt.compareTo(budgetVO.getPlanAmt().subtract(commonVO.getOccupyAmt())) > 0) {
                    throw TwException.error("", "预算费用金额不足，请核验！");
                }
                /**
                 * 明细控制触发机制
                 * 1.活动id非空
                 * 2.合同项目
                 * 3.项目预算是刚性控制
                 * 4.明细控制
                 */
                if (!ObjectUtils.isEmpty(budgetItemId)) {
                    BudgetSubjectDetailVO budgetSubjectDetailVO = budgetSubjectDetailDAO.queryByBudgetItemId(budgetItemId);
                    if (budgetSubjectDetailVO == null) {
                        throw TwException.error("", "费用明细不存在，请核验！");
                    }
                    // 先判断 明细控制开关开启
                    if (!ObjectUtils.isEmpty(budgetSubjectDetailVO.getDetailControlFlag()) && budgetSubjectDetailVO.getDetailControlFlag()) {
                        if (ObjectUtils.isEmpty(budgetSubjectDetailVO.getBudgetAmt())) {
                            throw TwException.error("", budgetSubjectDetailVO.getAccName() + "-科目预算费用不足，请核验！");
                        }
                        // BigDecimal accUsedAmt = commonVO.getAccUsedAmtMap().get(budgetItemId) == null ? BigDecimal.ZERO : commonVO.getAccUsedAmtMap().get(budgetItemId);
                        BigDecimal actcccupyAmt = commonVO.getAccOccupyAmtMap().get(budgetItemId) == null ? BigDecimal.ZERO : commonVO.getAccOccupyAmtMap().get(budgetItemId);
                        // 剩余可用金额 = 已拨付的金额- 占用金额数 - 已使用金额数
                        if (amt.compareTo(budgetSubjectDetailVO.getBudgetAmt().subtract(actcccupyAmt)) > 0) {
                            throw TwException.error("", budgetSubjectDetailVO.getAccName() + "-科目预算费用不足，请核验！");
                        }
                    }
                }
            }

        }
    }

//


}
