package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 泛用金额结算管理
 *
 * @author carl
 * @date 2023-11-20
 */
@Entity
@Table(name = "cal_norm_settle", indexes = {
        @Index(name = "out_account_index", columnList = "out_account_id"),
        @Index(name = "in_account_index", columnList = "in_account_id")
})
@org.hibernate.annotations.Table(appliesTo = "cal_norm_settle", comment = "泛用金额结算管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalNormSettleDO extends BaseModel implements Serializable {
    /**
     * 结算单号
     */
    @Comment("结算单号")
    @Column()
    private String settleNo;
    /**
     * 结算状态
     */
    @Comment("结算状态")
    @Column()
    private String settleStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例id
     */
    @Comment("流程实例id")
    @Column()
    private String procInstId;
    /**
     * 单据创建类型
     */
    @Comment("单据创建类型")
    @Column()
    private String createType;
    /**
     * 业务类型
     */
    @Comment("业务类型")
    @Column()
    private String busiType;
    /**
     * 相关业务单据号
     */
    @Comment("相关业务单据号")
    @Column()
    private String relevNo;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDateTime applyDate;
    /**
     * 申请资源id
     */
    @Comment("申请资源id")
    @Column()
    private Long applyResId;
    /**
     * 结算日期
     */
    @Comment("结算日期")
    @Column()
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @Comment("财务期间id")
    @Column()
    private Long finPeriodId;
    /**
     * 子合同id
     */
    @Comment("子合同id")
    @Column()
    private Long contractId;
    /**
     * 子合同名称（冗余）
     */
    @Comment("子合同名称（冗余）")
    @Column()
    private String contractName;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 项目名称（冗余）
     */
    @Comment("项目名称（冗余）")
    @Column()
    private String projName;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column()
    private Long taskId;
    /**
     * 收入方账户
     */
    @Comment("收入方账户")
    @Column()
    private String inAccount;
    /**
     * 收入方科目
     */
    @Comment("收入方科目")
    @Column()
    private String inAcc;
    /**
     * 支出方账户
     */
    @Comment("支出方账户")
    @Column()
    private String outAccount;
    /**
     * 支出方科目
     */
    @Comment("支出方科目")
    @Column()
    private String outAcc;
    /**
     * 收入方账户id
     */
    @Comment("收入方账户id")
    @Column(name = "in_account_id")
    private Long inAccountId;

    /**
     * 支出方账户id
     */
    @Comment("支出方账户id")
    @Column(name = "out_account_id")
    private Long outAccountId;
    /**
     * 实际结算总额
     */
    @Comment("实际结算总额")
    @Column()
    private BigDecimal approveSettleAmt;
    /**
     * 税额
     */
    @Comment("税额")
    @Column()
    private BigDecimal taxAmt;
    /**
     * 申请人bu_id
     */
    @Comment("申请人bu_id")
    @Column()
    private Long applyBuId;
    /**
     * 收款计划id
     */
    @Comment("收款计划id")
    @Column()
    private Long recvplanId;
    /**
     * 收款阶段（冗余）
     */
    @Comment("收款阶段（冗余）")
    @Column()
    private String receStage;

    public void copy(CalNormSettleDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
