package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaCostPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaCostQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaCostService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaCostVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalEqvaCostConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalEqvaCostDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalEqvaCostDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalEqvaCostRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 当量成本配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalEqvaCostServiceImpl extends BaseServiceImpl implements CalEqvaCostService {

    private final CalEqvaCostRepo calEqvaCostRepo;
    private final CalEqvaCostDAO calEqvaCostDAO;

    @Override
    public PagingVO<CalEqvaCostVO> queryPaging(CalEqvaCostQuery query) {
        PagingVO<CalEqvaCostVO> calEqvaCostVOPagingVO = calEqvaCostDAO.queryPaging(query);
        if (calEqvaCostVOPagingVO.getTotal() > 0) {
            calEqvaCostVOPagingVO.getRecords().forEach(this::translateData);
        }
        return calEqvaCostVOPagingVO;
    }

    @Override
    public List<CalEqvaCostVO> queryListDynamic(CalEqvaCostQuery query) {
        return calEqvaCostDAO.queryListDynamic(query);
    }

    @Override
    public CalEqvaCostVO queryByKey(Long key) {
        CalEqvaCostVO calEqvaCostVO = calEqvaCostDAO.queryByKey(key);
        translateData(calEqvaCostVO);
        return calEqvaCostVO;
    }

    /**
     * 数据翻译
     *
     * @param calEqvaCostVO
     */
    void translateData(CalEqvaCostVO calEqvaCostVO) {
        if (calEqvaCostVO.getFinYear() != null && calEqvaCostVO.getFinPeriod() != null) {
            String finPeriodName = calEqvaCostVO.getFinYear() + "-" + (calEqvaCostVO.getFinPeriod() > 9 ? ("" + calEqvaCostVO.getFinPeriod()) : ("0" + calEqvaCostVO.getFinPeriod()));
            calEqvaCostVO.setFinPeriodName(finPeriodName);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)

    public CalEqvaCostVO insertOrUpdate(CalEqvaCostPayload payload) {
        //数据校验
        checkDate(payload);
        CalEqvaCostDO entityDo = CalEqvaCostConvert.INSTANCE.toDo(payload);
        return CalEqvaCostConvert.INSTANCE.toVo(calEqvaCostRepo.save(entityDo));
    }

    /**
     * 数据校验
     *
     * @param payload
     */
    void checkDate(CalEqvaCostPayload payload) {
        if (payload.getFinPeriod() != null && payload.getFinYear() == null) {
            throw TwException.error("", "期间存在，年度不可为空");
        }
        if (StringUtils.hasText(payload.getJobType2()) && !StringUtils.hasText(payload.getJobType1())) {
            throw TwException.error("", "工种子类存在，工种不可为空");
        }
        CalEqvaCostQuery calEqvaCostQuery = CalEqvaCostConvert.INSTANCE.toQuery(payload);
        List<Long> longs = calEqvaCostDAO.queryCheckData(calEqvaCostQuery);
        if (!ObjectUtils.isEmpty(longs)) {
            if (payload.getId() == null || longs.size() > 1 || !longs.get(0).equals(payload.getId())) {
                throw TwException.error("", "存在相同成本配置");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {

            calEqvaCostDAO.deleteSoft(keys);
        }
    }

    @Override
    public CalEqvaCostVO getEqvaCostPlus(CalEqvaCostQuery query) {
        return calEqvaCostDAO.getEqvaCostPlus(query);
    }

}
