package com.elitesland.tw.tw5.server.prd.common;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.json.JSONUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class SyncJdeUtil {
    @Value("${tw5.jde.username}")
    private String username;

    @Value("${tw5.jde.password}")
    private String password;
    @Value("${tw5.jde.count:3}")
    private Integer count;
    private final HttpUtil httpUtil;

    public String syncJde(String requestStr,String syncJdeUrl){
        String buildBasicAuth = cn.hutool.http.HttpUtil.buildBasicAuth(username, password, CharsetUtil.CHARSET_UTF_8);
        String result = "";
        log.info("请求JDE发送参数为:" + requestStr);
        result = httpUtil.sendPost(syncJdeUrl, requestStr, buildBasicAuth);
        log.info("请求JDE返回报文为:" + result);
        log.info("请求jde返回参数为" + JSONUtil.toJsonStr(result));
        return result;
    }

    public String syncJde(String requestStr,String syncJdeUrl,int timeout){
        String buildBasicAuth = cn.hutool.http.HttpUtil.buildBasicAuth(username, password, CharsetUtil.CHARSET_UTF_8);
        String result = "";
        result = httpUtil.sendPost(syncJdeUrl, requestStr, buildBasicAuth,timeout);
        log.info("请求JDE返回报文为:" + result);
        log.info("请求jde返回参数为" + JSONUtil.toJsonStr(result));
        return result;
    }
}
