package com.elitesland.tw.tw5.server.prd.crm.convert;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcel;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.server.common.BaseConvertMapper;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
@Mapper
public interface CrmCustomerOperationConvert extends BaseConvertMapper<CrmCustomerOperationVO, CrmCustomerOperationDO> {

    CrmCustomerOperationConvert INSTANCE = Mappers.getMapper(CrmCustomerOperationConvert.class);

    CrmCustomerOperationDO toDo(CrmCustomerOperationPayload payload);

    CrmCustomerOperationDO excelToDo(CrmCustomerOperationExcel excel);

    CrmCustomerOperationVO toVo(CrmCustomerOperationDO ado);

    CrmCustomerOperationPayload toPayload(CrmCustomerOperationVO vo);

    List<CrmCustomerOperationSimpleVO> toListVoSimple(List<CrmCustomerOperationDO> list);

    List<CrmCustomerOperationExcel> voListVoExcel(List<CrmCustomerOperationVO> list);

    List<CrmCustomerOperationExcelExport> voListVoExcelExport(List<CrmCustomerOperationVO> list);

}
