package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 里程碑计划
 *
 * @author zoey
 * @date 2023-11-01
 */
@Entity
@Table(name = "crm_opportunity_milestone_plan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_milestone_plan", comment = "里程碑计划")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityMilestonePlanDO extends BaseModel implements Serializable  {
    @Comment("商机ID")
    @Column(name = "oppo_id", nullable = false)
    private Long oppoId;
    /** 关键里程碑 */
    @Comment("关键里程碑")
    @Column()
    private String milestone;
    /** 负责人 */
    @Comment("负责人")
    @Column()
    private String directorUserId;
    /** 状态 */
    @Comment("状态")
    @Column()
    private String state;
    /** 开始时间 */
    @Comment("开始时间")
    @Column()
    private LocalDate dateFrom;
    /** 结束时间 */
    @Comment("结束时间")
    @Column()
    private LocalDate dateTo;

    public void copy(CrmOpportunityMilestonePlanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
