package com.elitesland.tw.tw5.server.prd.crm.flow;

/**
 * @author zoey
 * @Description:样例工作流
 * @date 2022/7/20 - 15:53
 */
//@DubboService(group = "crm")
//@Component
//@RequiredArgsConstructor
//@Primary
//@Slf4j
//public class CrmWorkFlowCallBack implements WorkflowCallBack {
//    private final CrmActPlanService actPlanService;
//    private final CrmActActivityService actActivityService;
//    private final CrmOpportunityOutCostService opportunityOutCostService;
//    private final CrmOpportunityOutCostDAO opportunityOutCostDAO;
//    private final CrmActPlanDAO actPlanDAO;
//    private final CrmActActivityDAO actActivityDAO;
//    private final PrjProjectDAO projectDAO;
//    private final PrdSystemBusinessChangeService changeService;
//    private final TransferUtilServiceImpl transferUtilService;
//    private final HttpUtil httpUtil;
//
//    @Value("${tw5.user_default.user_id}")
//    private Long default_role_id;
//    @Value("${tw4.opportunity.outCost_operation}")
//    private String outCost_operation;
//
//    /**
//     * 设置任务审批人
//     *
//     * @param procDefKey   流程定义的key
//     * @param taskKey      任务的key
//     * @param businessKey  业务的key
//     * @param customParams 自定已参数
//     * @return
//     */
//    @Override
//    public ArrayList<String> taskAssignee(String tenantId, String procDefKey, String taskKey, String businessKey, String customParams) {
//        return null;
//    }
//
//    /**
//     * 任务创建事件
//     *
//     * @param procDefKey
//     * @param taskKey
//     * @param businessKey
//     * @param taskAssignees
//     */
//    @Override
//    public void taskCreated(String tenantId, String procDefKey, String taskKey, String businessKey, Set<String> taskAssignees) {
//        log.info("====taskCreated：任务节点：" + taskKey);
//        if (!CollectionUtils.isEmpty(taskAssignees)) {
//            taskAssignees.forEach(assignee -> log.info("====审批人：" + assignee));
//        }
//    }
//
//    /**
//     * 任务结束事件
//     *
//     * @param procDefKey
//     * @param taskKey
//     * @param businessKey
//     */
//    @Override
//    public void taskCompleted(String tenantId, String procDefKey, String taskKey, String businessKey, String taskHandler) {
//        log.info("====taskCompleted：任务节点：" + taskKey);
//    }
//
//
//    /**
//     * @param tenantId
//     * @param procDefKey     流程定义的key
//     * @param procInstStatus 任务的key
//     * @param businessKey    业务的key
//     * @param commentInfo
//     */
//    @Override
//    public void processStatusChange(String tenantId, String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
////        businessKey = businessKey.substring(businessKey.lastIndexOf("_") + 1);
//        log.info("====process：流程状态：" + procInstStatus.name());
//        ProcDefKey defKey = ProcDefKey.valueOf(procDefKey);
//        switch (defKey) {
//            case MARKET_PLAN:
//                processRemarkPlanTrans(procDefKey, procInstStatus, businessKey);
//                break;
//            case MARKET_PLAN_C:
//                processRemarkPlanChangeTrans(procDefKey, procInstStatus, businessKey);
//                break;
//            case MARKET_ACTIVITY:
//                processRemarkActivityTrans(procDefKey, procInstStatus, businessKey);
//                break;
//            case MARKET_ACTIVITY_C:
//                processRemarkActivityChangeTrans(procDefKey, procInstStatus, businessKey);
//                break;
//            case MARKET_END_REPORT:
//                processRemarkEndReportTrans(procDefKey, procInstStatus, businessKey);
//                break;
//            case OPPO_OUT_COST:
//                processRemarkEndOppoOutCostTrans(procDefKey, procInstStatus, businessKey);
//                break;
//        }
//    }
//
//
///************************************************************************************************************/
//
//
//    /**
//     * 市场预算新增流程
//     *
//     * @param procDefKey     流程定义的key
//     * @param procInstStatus 任务的key
//     * @param businessKey    业务的key
//     */
////    @Transactional
//    private void processRemarkPlanTrans(String procDefKey, ProcInstStatus procInstStatus, String businessKey) {
//        CrmActPlanPayload actPlanPayload = new CrmActPlanPayload();
//        actPlanPayload.setId(Long.parseLong(businessKey));
//        //根据业务key查询当前业务对象
//        CrmActPlanVO crmActPlanVO = actPlanService.queryByKey(Long.valueOf(businessKey));
//        if (crmActPlanVO != null) {
//            switch (procInstStatus) {
//                case NOTSUBMIT://创建人提交节点
//                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
//                    break;
//                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    actPlanPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
//                    break;
//                case INVALID://先删除流程再删除单据
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.INVALID.getCode());
//                    actPlanPayload.setDeleteFlag(1);
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.INVALID);
//                    break;
//                case REJECTED://审批人拒绝，回到第一个节点
//                    //将单据状态变为新建状态
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.REJECTED);
//                    break;
//                case APPROVED:
//                    //TODO:这里需要一个事务
//                    //一般情况将单据状态变成"激活"
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVED);
//                    actPlanPayload.setApprovedTime(LocalDateTime.now());
//                    actPlanDAO.updateByKeyDynamic(actPlanPayload);
//                    //重新查询
//                    crmActPlanVO = actPlanService.queryByKey(Long.valueOf(businessKey));
//                    //保存一个版本的初始数据
//                    //保存主表changeLog
//                    changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN.getCode(), crmActPlanVO, null, null, 1);
//                    //保存子表changeLog
//                    List<CrmActPlanDetailVO> crmActPlanDetailVOS = actPlanService.queryDetails(crmActPlanVO.getId(), null);
//                    for (CrmActPlanDetailVO crmActPlanDetailVO : crmActPlanDetailVOS) {
//                        changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), crmActPlanDetailVO, ChangeTypeEnum.MARKET_PLAN.getCode(), crmActPlanVO.getId().toString(), 1);
//                    }
//                    break;
//                case APPROVING:
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVING);
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//            }
//            if (!procInstStatus.equals(ProcInstStatus.APPROVED)) {
//                actPlanDAO.updateByKeyDynamic(actPlanPayload);
//            }
//        }
//    }
//
//
//    /**
//     * 市场预算变更流程
//     *
//     * @param procDefKey     流程定义的key
//     * @param procInstStatus 任务的key
//     * @param businessKey    业务的key
//     */
////    @Transactional
//    private void processRemarkPlanChangeTrans(String procDefKey, ProcInstStatus procInstStatus, String businessKey) {
//        CrmActPlanPayload actPlanPayload = new CrmActPlanPayload();
//        actPlanPayload.setId(Long.parseLong(businessKey));
//        //根据业务key查询当前业务对象
//        CrmActPlanVO crmActPlanVO = actPlanService.queryByKey(Long.valueOf(businessKey));
//        if (crmActPlanVO != null) {
//            switch (procInstStatus) {
//                case NOTSUBMIT://创建人提交节点
//                    //一般情况将单据状态变成"激活",流程状态改为未提交
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
//                    break;
//                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                case INVALID://仅删除流程
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    actPlanPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
//                    //TODO:删除当前版本草稿状态的changeLog
//                    changeService.deleteCurrentVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), crmActPlanVO.getId().toString());
//                    break;
//                case REJECTED://审批人拒绝，回到第一个节点
//                    //将单据状态变为新建状态
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.REJECTED);
//                    break;
//                case APPROVED:
//                    //一般情况将单据状态变成"激活"
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVED);
//                    actPlanPayload.setApprovedTime(LocalDateTime.now());
//                    //TODO:激活当前版本草稿状态的所有changeLog,合并当前及上一个版本
//                    Map<String, Object> stringObjectMap = changeService.activeCurrentVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), crmActPlanVO.getId().toString());
//                    CrmActPlanVO newPlan = JSON.parseObject(stringObjectMap.toString(), CrmActPlanVO.class);
//                    CrmActPlanPayload newPayload = CrmActPlanConvert.INSTANCE.toPayload(newPlan);
//                    actPlanDAO.updateByKeyDynamic(newPayload);
//                    List<Map<String, Object>> details = (List<Map<String, Object>>) stringObjectMap.get(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode());
//                    if (details != null && !details.isEmpty()) {
//                        for (Map<String, Object> detail : details) {
//                            CrmActPlanDetailVO crmActPlanDetailVO = JSON.parseObject(detail.toString(), CrmActPlanDetailVO.class);
//                            CrmActPlanDetailPayload detailPayload = CrmActPlanDetailConvert.INSTANCE.toPayload(crmActPlanDetailVO);
//                            if (detailPayload.getId() == null) {
//                                CrmActPlanDetailDO crmActPlanDetailDO = actPlanDAO.saveDetail(CrmActPlanDetailConvert.INSTANCE.toDo(detailPayload));
//                                Long id = crmActPlanDetailDO.getId();
//                                crmActPlanDetailVO.setId(id);
//                                //更新当前版本的changeLog
//                                changeService.updateVersionContent(Long.parseLong(detail.get("changeLogId").toString()), crmActPlanDetailVO);
//                            } else {
//                                actPlanDAO.updateDetailByKeyDynamic(detailPayload);
//                            }
//                        }
//                    }
//                    break;
//                case APPROVING:
//                    actPlanPayload.setProcInstStatus(ProcInstStatus.APPROVING);
//                    actPlanPayload.setPlanStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//            }
//            actPlanDAO.updateByKeyDynamic(actPlanPayload);
//        }
//    }
//
//    /**
//     * 市场活动新增流程
//     *
//     * @param procDefKey     流程定义的key
//     * @param procInstStatus 任务的key
//     * @param businessKey    业务的key
//     */
//    private void processRemarkActivityTrans(String procDefKey, ProcInstStatus procInstStatus, String businessKey) {
//        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
//        activityPayload.setId(Long.parseLong(businessKey));
//        //根据业务key查询当前业务对象
//        CrmActActivityVO crmActActivityVO = actActivityService.queryByKey(Long.valueOf(businessKey));
//        if (crmActActivityVO != null) {
//            switch (procInstStatus) {
//                case NOTSUBMIT://创建人提交节点
//                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    activityPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
//                    break;
//                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    activityPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
//                    break;
//                case INVALID://先删除流程再删除单据
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.INVALID.getCode());
//                    activityPayload.setDeleteFlag(1);
//                    activityPayload.setProcInstStatus(ProcInstStatus.INVALID);
//                    break;
//                case REJECTED://审批人拒绝，回到第一个节点
//                    //将单据状态变为新建状态
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    activityPayload.setProcInstStatus(ProcInstStatus.REJECTED);
//                    break;
//                case APPROVED:
//                    //一般情况将单据状态变成"激活"
////                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVED);
//                    activityPayload.setApprovedTime(LocalDateTime.now());
//                    activityPayload.setIsRelease(0);
//                    actActivityDAO.updateActivityByKeyDynamic(activityPayload);
//                    //更新项目状态
//                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
//                    //重新查询
//                    crmActActivityVO = actActivityService.queryByKey(Long.valueOf(businessKey));
//                    //保存一个版本的初始数据
//                    changeService.saveNewLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO, null, null, 1);
//                    break;
//                case APPROVING:
//                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVING);
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//            }
//            actActivityDAO.updateActivityByKeyDynamic(activityPayload);
//        }
//    }
//
//
//    /**
//     * 市场活动变更增流程
//     *
//     * @param procDefKey     流程定义的key
//     * @param procInstStatus 任务的key
//     * @param businessKey    业务的key
//     */
//    private void processRemarkActivityChangeTrans(String procDefKey, ProcInstStatus procInstStatus, String businessKey) {
//        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
//        activityPayload.setId(Long.parseLong(businessKey));
//        //根据业务key查询当前业务对象
//        CrmActActivityVO crmActActivityVO = actActivityService.queryByKey(Long.valueOf(businessKey));
//        if (crmActActivityVO != null) {
//            switch (procInstStatus) {
//                case NOTSUBMIT://创建人提交节点
//                    //一般情况将单据状态变成"新建",流程状态改为未提交
////                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    activityPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
//                    //更新项目状态
//                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
//                    break;
//                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                case INVALID://先删除流程再删除单据
//                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
////                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    activityPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
//                    //删除当前版本草稿状态的changeLog
//                    changeService.deleteCurrentVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
//                    //更新项目状态
//                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
//                    break;
//                case REJECTED://审批人拒绝，回到第一个节点
//                    //将单据状态变为新建状态
////                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    activityPayload.setProcInstStatus(ProcInstStatus.REJECTED);
//                    //更新项目状态
//                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
//                    break;
//                case APPROVED:
//                    //一般情况将单据状态变成"激活"
////                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVED);
//                    activityPayload.setApprovedTime(LocalDateTime.now());
//                    //更新项目状态
//                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
//                    //激活当前版本草稿状态的所有changeLog,合并当前及上一个版本
//                    Map<String, Object> stringObjectMap = changeService.activeCurrentVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
//                    CrmActActivityVO newActivity = JSON.parseObject(stringObjectMap.toString(), CrmActActivityVO.class);
//                    CrmActActivityPayload newActivityPayload = CrmActActivityConvert.INSTANCE.toPayload(newActivity);
//                    newActivityPayload.setDoSave(true);
//                    //更新关联的市场活动操作
//                    actActivityService.update(newActivityPayload);
//                    break;
//                case APPROVING:
//                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVING);
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//            }
//            actActivityDAO.updateActivityByKeyDynamic(activityPayload);
//        }
//    }
//
//
//    /**
//     * 市场活动结项报告流程
//     *
//     * @param procDefKey     流程定义的key
//     * @param procInstStatus 任务的key
//     * @param businessKey    业务的key
//     */
//    private void processRemarkEndReportTrans(String procDefKey, ProcInstStatus procInstStatus, String businessKey) {
//        CrmActReportPayload reportPayload = new CrmActReportPayload();
//        reportPayload.setId(Long.parseLong(businessKey));
//        //根据业务key查询当前业务对象
//        List<CrmActReportVO> crmActReportVOS = actActivityService.queryReportByKey(Long.valueOf(businessKey), 2);
//        if (crmActReportVOS != null && !crmActReportVOS.isEmpty()) {
//            switch (procInstStatus) {
//                case NOTSUBMIT://创建人提交节点
//                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    reportPayload.setReportStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    reportPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
//                    break;
//                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    reportPayload.setReportStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    reportPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
//                    break;
//                case INVALID://先删除流程再删除单据
//                    reportPayload.setReportStatus(WorkFlowStatusEnum.INVALID.getCode());
//                    reportPayload.setDeleteFlag(1);
//                    reportPayload.setProcInstStatus(ProcInstStatus.INVALID);
//                    break;
//                case REJECTED://审批人拒绝，回到第一个节点
//                    //将单据状态变为新建状态
//                    reportPayload.setReportStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    reportPayload.setProcInstStatus(ProcInstStatus.REJECTED);
//                    break;
//                case APPROVED:
//                    PrjProjectVO project = projectDAO.queryByKey(crmActReportVOS.get(0).getProjectId());
//                    //一般情况将单据状态变成"激活"
//                    reportPayload.setReportStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    reportPayload.setProcInstStatus(ProcInstStatus.APPROVED);
//                    reportPayload.setApprovedTime(LocalDateTime.now());
//                    //更新项目状态
//                    CrmActActivityPayload acPayload = new CrmActActivityPayload();
//                    acPayload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
//                    acPayload.setCloseReason("act_end");
//                    actActivityDAO.updateProjectByKeyDynamic(acPayload, project.getId());
//                    break;
//                case APPROVING:
//                    reportPayload.setProcInstStatus(ProcInstStatus.APPROVING);
//                    reportPayload.setReportStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//            }
//            actActivityDAO.updateReportyKeyDynamic(reportPayload);
//        }
//    }
//
//    /**
//     * 商机渠道（外包）费用流程  外包费用
//     *
//     * @param procDefKey     流程定义的key
//     * @param procInstStatus 任务的key
//     * @param businessKey    业务的key
//     */
//    private void processRemarkEndOppoOutCostTrans(String procDefKey, ProcInstStatus procInstStatus, String businessKey) {
//        CrmOpportunityOutCostPayload payload = new CrmOpportunityOutCostPayload();
//        final long id = Long.parseLong(businessKey);
//        payload.setId(id);
//        //根据业务key查询当前业务对象
//        final CrmOpportunityOutCostVO crmOpportunityOutCostVO = opportunityOutCostService.queryById(id);
//        if (crmOpportunityOutCostVO != null) {
//            switch (procInstStatus) {
//                case NOTSUBMIT://创建人提交节点
//                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    payload.setActivataStatus("1");
//                    crmOpportunityOutCostVO.setActivataStatus("1");
//                    payload.setApprovalStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
//                    payload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
//                    break;
//                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    payload.setActivataStatus("1");
//                    crmOpportunityOutCostVO.setActivataStatus("1");
//                    payload.setApprovalStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//                    payload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
//                    payload.setProcInstStatus(ProcInstStatus.INTERRUPT);
//                    break;
//                case INVALID://先删除流程再删除单据
//                    payload.setActivataStatus("1");
//                    crmOpportunityOutCostVO.setActivataStatus("1");
//                    payload.setDeleteFlag(1);
//                    payload.setProcInstStatus(ProcInstStatus.INVALID);
//                    payload.setApprovalStatus(WorkFlowStatusEnum.INVALID.getCode());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.INVALID.getCode());
//                    break;
//                case REJECTED://审批人拒绝，回到第一个节点
//                    //将单据状态变为新建状态
//                    payload.setActivataStatus("1");
//                    crmOpportunityOutCostVO.setActivataStatus("1");
//                    payload.setProcInstStatus(ProcInstStatus.REJECTED);
//                    payload.setApprovalStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
//                    break;
//                case APPROVED:
//                    //一般情况将单据状态变成"激活"
//                    payload.setActivataStatus("0");
//                    crmOpportunityOutCostVO.setActivataStatus("0");
//                    payload.setProcInstStatus(ProcInstStatus.APPROVED);
//                    payload.setApprovalStatus(WorkFlowStatusEnum.APPROVED.getCode());
////                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.APPROVED.getCode());
//                    payload.setApprovedTime(LocalDateTime.now());
//
//                    //同步到4.0
//                    Long outCostIdV4 = opportunityOutCostDAO.queryTW4IdById(crmOpportunityOutCostVO.getId());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.APPROVED.getCode());
//                    crmOpportunityOutCostVO.setProcInstStatus(ProcInstStatus.APPROVED);
//                    Map<String, Object> map = transferUtilService.beanToMap(crmOpportunityOutCostVO);
//                    map.put("id", outCostIdV4);
//                    String result = httpUtil.sendSyncPost(outCost_operation, map);
//                    String outCostId = httpUtil.geResultData(result);
//                    if (StringUtils.hasText(outCostId)) {
//                        if (StringUtil.isInteger(outCostId)) {
//                            outCostIdV4 = Long.valueOf(outCostId);
//                        }
//                    }
//                    payload.setOutCostIdV4(outCostIdV4);
//                    break;
//                case APPROVING:
//                    payload.setActivataStatus("1");
//                    payload.setProcInstStatus(ProcInstStatus.APPROVING);
//                    payload.setApprovalStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
//            }
//            opportunityOutCostDAO.updateByKeyDynamic(payload);
//        }
//    }
//
//}
