package com.elitesland.tw.tw5.server.prd.crm.repo;

import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.lang.Nullable;

import java.util.List;
import java.util.Optional;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/19 - 14:13
 */
public interface CrmPotentialCustomerRepo extends JpaRepository<CrmPotentialCustomerDO,Long>, QuerydslPredicateExecutor<CrmPotentialCustomerDO>, JpaSpecificationExecutor<CrmPotentialCustomerDO> {

    @Override
    @EntityGraph(value = "potentialCustomer.rule.list")
    List<CrmPotentialCustomerDO> findAll(@Nullable Specification<CrmPotentialCustomerDO> spec);

    @Override
    @EntityGraph(value = "potentialCustomer.rule.list")
    long count(@Nullable Specification<CrmPotentialCustomerDO> spec);

    @Override
    @EntityGraph(value = "potentialCustomer.rule.list")
    Page<CrmPotentialCustomerDO> findAll(@Nullable Specification<CrmPotentialCustomerDO> spec, Pageable pageable);

    @Override
    @EntityGraph(value = "potentialCustomer.rule.detail")
    Optional<CrmPotentialCustomerDO> findById(Long id);


    Integer countByOpensea_Id(Long openseaId);

    @EntityGraph(value = "potentialCustomer.rule.list")
    List<CrmPotentialCustomerDO> findByOpensea_Id(Long opensea_id);

    @Modifying
    @Query("update CrmPotentialCustomerDO set customerGrade = ?2 where id in ?1")
    void updateCustomerGrade(List<Long> potentialCustomerIds, String grade);
}
