package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityAnalyzePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityAnalyzeService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityAnalyzeVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityAnalyzeConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityAnalyzeDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityAnalyzeDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 商机案情分析管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityAnalyzeServiceImpl implements CrmOpportunityAnalyzeService {
    private final CacheUtil cacheUtil;
    private final CrmOpportunityAnalyzeDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityDAO opportunityDAO;
    private final PrdOrgEmployeeDAO employeeDAO;

    @Value("${tw4.opportunity.analyze_operation}")
    private String analyze_operation;

    @Value("${tw4.opportunity.analyze_del}")
    private String analyze_del;

    @Transactional
    @Override
    public CrmOpportunityAnalyzeVO insert(CrmOpportunityAnalyzePayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getAnalyzeIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getAnalyzeIdV4()));
        }
        if(payload.getManageUserIdV4()!=null){
            payload.setManageUserId(employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
        //同步到4.0
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        String result = httpUtil.sendSyncPost(analyze_operation, map);
//        String analyzeId = httpUtil.geResultData(result);
//        long analyzeIdV4 = 0;
//        if (StringUtils.hasText(analyzeId)) {
//            if (StringUtil.isInteger(analyzeId)) {
//                analyzeIdV4 = Long.valueOf(analyzeId);
//            }
//        }
        CrmOpportunityAnalyzeDO ado = CrmOpportunityAnalyzeConvert.INSTANCE.toDo(payload);
//        ado.setAnalyzeIdV4(analyzeIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "案情分析");
        return CrmOpportunityAnalyzeConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(CrmOpportunityAnalyzePayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getAnalyzeIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getAnalyzeIdV4()));
        }
        if(payload.getManageUserIdV4()!=null){
            payload.setManageUserId(employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
//        //同步到4.0
//        Long analyzeIdV4 = dao.queryTW4IdById(payload.getId());
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        map.put("id", analyzeIdV4);
//        String result = httpUtil.sendSyncPost(analyze_operation, map);
//        httpUtil.geResultData(result);

        CrmOpportunityAnalyzeDO ado = CrmOpportunityAnalyzeConvert.INSTANCE.toDo(payload);
//        ado.setAnalyzeIdV4(analyzeIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "案情分析");

        return 0L;
    }

    @Override
    public List<CrmOpportunityAnalyzeVO> queryList(Long oppoId) {

        return dao.queryList(oppoId);
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        //同步到4.0

//        Map<String, Object> map = new HashMap<>();
//        map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
//        String result = httpUtil.sendSyncGet(analyze_del, map);
//        httpUtil.geResultData(result);

        dao.deleteSoft(keys);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "案情分析");
        return true;
    }
}
