package com.elitesland.tw.tw5.server.prd.humanresources.ability.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdLevelConfigDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdLevelConfigDtlDO;

import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护明细表RepoProc
 */

@Component
public class PrdLevelConfigDtlDao extends BaseRepoProc<PrdLevelConfigDtlDO> {

    private static final QPrdLevelConfigDtlDO qPrdLevelConfigDtlDO = QPrdLevelConfigDtlDO.prdLevelConfigDtlDO;


    protected PrdLevelConfigDtlDao() {

        super(qPrdLevelConfigDtlDO);

    }


    public PagingVO<PrdLevelConfigDtlVO> page(PrdLevelConfigDtlQuery prdLevelConfigDtlQuery) {

        JPAQuery<PrdLevelConfigDtlVO> query =
                select(PrdLevelConfigDtlVO.class)
                        .where(bulidPredicate(prdLevelConfigDtlQuery));
        prdLevelConfigDtlQuery.setPaging(query);
        prdLevelConfigDtlQuery.fillOrders(query, qPrdLevelConfigDtlDO);
        return PagingVO.<PrdLevelConfigDtlVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdLevelConfigDtlDO)
                .set(qPrdLevelConfigDtlDO.deleteFlag, 1)
                .where(qPrdLevelConfigDtlDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdLevelConfigDtlVO get(Long id) {

        PrdLevelConfigDtlVO prdLevelConfigDtlVO = select(PrdLevelConfigDtlVO.class)
                .where(qPrdLevelConfigDtlDO.id.eq(id))
                .fetchOne();

        return prdLevelConfigDtlVO;

    }


    public List<PrdLevelConfigDtlVO> getList(PrdLevelConfigDtlQuery prdLevelConfigDtlQuery) {

        List<PrdLevelConfigDtlVO> res =
                select(PrdLevelConfigDtlVO.class)
                        .where(bulidPredicate(prdLevelConfigDtlQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdLevelConfigDtlDO.masId,
                        qPrdLevelConfigDtlDO.docNo,
                        qPrdLevelConfigDtlDO.name,
                        qPrdLevelConfigDtlDO.id,
                        qPrdLevelConfigDtlDO.sort,
                        qPrdLevelConfigDtlDO.createTime,
                        qPrdLevelConfigDtlDO.remark

                )).from(qPrdLevelConfigDtlDO);

    }


    private Predicate bulidPredicate(PrdLevelConfigDtlQuery prdLevelConfigDtlQuery) {

        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(null != prdLevelConfigDtlQuery.getMasId(), qPrdLevelConfigDtlDO.masId, prdLevelConfigDtlQuery.getMasId())
                .andEq(StringUtils.isNotBlank(prdLevelConfigDtlQuery.getDocNo()), qPrdLevelConfigDtlDO.docNo, prdLevelConfigDtlQuery.getDocNo())
                .andEq(StringUtils.isNotBlank(prdLevelConfigDtlQuery.getName()), qPrdLevelConfigDtlDO.name, prdLevelConfigDtlQuery.getName())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdLevelConfigDtlQuery prdLevelConfigDtlQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 关联id
        if (null != prdLevelConfigDtlQuery.getMasId()) {
            predicates.add(qPrdLevelConfigDtlDO.masId.eq(prdLevelConfigDtlQuery.getMasId()));
        }
        // 编号
        if (StringUtils.isNotEmpty(prdLevelConfigDtlQuery.getDocNo())) {
            predicates.add(qPrdLevelConfigDtlDO.docNo.eq(prdLevelConfigDtlQuery.getDocNo()));
        }
        // 名称
        if (StringUtils.isNotEmpty(prdLevelConfigDtlQuery.getName())) {
            predicates.add(qPrdLevelConfigDtlDO.name.eq(prdLevelConfigDtlQuery.getName()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long delByMasId(Long id) {
        return jpaQueryFactory.update(qPrdLevelConfigDtlDO)
                .set(qPrdLevelConfigDtlDO.deleteFlag, 1)
                .where(qPrdLevelConfigDtlDO.masId.eq(id))
                .execute();

    }

}

