package com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity;

import com.elitesland.tw.tw5.server.prd.humanresources.base.WorkflowBaseDO;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.hibernate.annotations.Where;


/**
 * @author : WWW
 * @date : 2023-11-1
 * @desc : base地与社保地变更申请
 */
 
@Entity
@Table(name="prd_base_region_change")
@org.hibernate.annotations.Table(appliesTo = "prd_base_region_change", comment = "base地与社保地变更申请")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdBaseRegionChangeDO extends WorkflowBaseDO {


    /**
     * 申请人id
     */
    @Column(name = "apply_user_id", columnDefinition = "bigint(20) comment '申请人id'")
    private Long applyUserId;
    
    /**
     * 申请人
     */
    @Column(name = "apply_user", columnDefinition = "varchar(255) comment '申请人'")
    private String applyUser;
    
    /**
     * 申请日期
     */
    @Column(name = "apply_date", columnDefinition = "date comment '申请日期'")
    private LocalDate applyDate;
    
    /**
     * 入职日期
     */
    @Column(name = "entry_date", columnDefinition = "date comment '入职日期'")
    private LocalDate entryDate;
    
    /**
     * 合作方式
     */
    @Column(name = "cooperate_type", columnDefinition = "varchar(255) comment '合作方式'")
    private String cooperateType;
    
    /**
     * 公司id
     */
    @Column(name = "ou_id", columnDefinition = "varchar(255) comment '公司id'")
    private String ouId;
    
    /**
     * 公司名称
     */
    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '公司名称'")
    private String ouName;
    
    /**
     * basebu
     */
    @Column(name = "base_bu_id", columnDefinition = "bigint(20) comment 'basebu'")
    private Long baseBuId;
    
    /**
     * 原base地
     */
    @Column(name = "old_base_region", columnDefinition = "varchar(255) comment '原base地'")
    private String oldBaseRegion;
    
    /**
     * 新base地
     */
    @Column(name = "new_base_region", columnDefinition = "varchar(255) comment '新base地'")
    private String newBaseRegion;
    
    /**
     * 原社保缴纳地
     */
    @Column(name = "old_social_region", columnDefinition = "varchar(255) comment '原社保缴纳地'")
    private String oldSocialRegion;
    
    /**
     * 新社保缴纳地
     */
    @Column(name = "new_social_region", columnDefinition = "varchar(255) comment '新社保缴纳地'")
    private String newSocialRegion;
    
    /**
     * 变更原因
     */
    @Column(name = "change_reason", columnDefinition = "varchar(255) comment '变更原因'")
    private String changeReason;
    
    /**
     * 生效日期
     */
    @Column(name = "active_date", columnDefinition = "date comment '生效日期'")
    private LocalDate activeDate;
    
    /**
     * 审批状态
     */
    @Column(name = "apply_state", columnDefinition = "varchar(255) comment '审批状态'")
    private String applyState;
    
    /**
     * 新增成本
     */
    @Column(name = "new_cost", columnDefinition = "decimal(20,4) comment '新增成本'")
    private BigDecimal newCost;
    

}

