package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigPointVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateDtlConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateDtlDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateDtlRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价明细表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdEvaluateDtlServiceImpl implements PrdEvaluateDtlService {


    private final PrdEvaluateDtlDao prdEvaluateDtlDao;

    private final PrdEvaluateDtlRepo prdEvaluateDtlRepo;

    private final PrdEvaluateConfigPointService prdEvaluateConfigPointService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateDtlVO save(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {

        checkData(prdEvaluateDtlPayload);
        // 校验pointId准确性
        PrdEvaluateConfigPointVO prdEvaluateConfigPointVO = prdEvaluateConfigPointService.get(prdEvaluateDtlPayload.getPointId());
        if (null == prdEvaluateConfigPointVO) {
            throw new BusinessException("评价点pointId未找到，请核对");
        }
        PrdEvaluateDtlDO prdEvaluateDtlDO = new PrdEvaluateDtlDO();
        prdEvaluateDtlDO = PrdEvaluateDtlConvert.INSTANCE.p2d(prdEvaluateDtlPayload);
        PrdEvaluateDtlDO res = prdEvaluateDtlRepo.save(prdEvaluateDtlDO);
        return PrdEvaluateDtlConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateDtlVO update(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {

        Assert.notNull(prdEvaluateDtlPayload.getId(), "id is null");
        PrdEvaluateDtlVO res = save(prdEvaluateDtlPayload);
        return res;

    }


    @Override
    public PrdEvaluateDtlVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdEvaluateDtlVO res = prdEvaluateDtlDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdEvaluateDtlVO> page(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {

        PagingVO<PrdEvaluateDtlVO> res = prdEvaluateDtlDao.page(prdEvaluateDtlQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdEvaluateDtlDao.del(ids);
        return res;

    }

    @Override
    public List<PrdEvaluateDtlVO> getList(PrdEvaluateDtlQuery prdEvaluateDtlQuery) {

        List<PrdEvaluateDtlVO> res = prdEvaluateDtlDao.getList(prdEvaluateDtlQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdEvaluateDtlPayload
     */
    private void checkData(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {

        if (StringUtils.isBlank(prdEvaluateDtlPayload.getPointName())) {
            throw new BusinessException("评价点不能为空");
        }
        if (null == prdEvaluateDtlPayload.getScore()) {
            throw new BusinessException("评分不能为空");
        }
        if (null == prdEvaluateDtlPayload.getPointId()) {
            throw new BusinessException("pointId不能为空");
        }
//        if (StringUtils.isBlank(prdEvaluateDtlPayload.getEvalDesc())) {
//            throw new BusinessException("简评不能为空");
//        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdEvaluateDtlPayload prdEvaluateDtlPayload) {
        Assert.notNull(prdEvaluateDtlPayload.getId(), "id不能为空");
        Long res = prdEvaluateDtlDao.update(prdEvaluateDtlPayload);
        return res;
    }

    @Override
    @Transactional
    public Long delByEvalIds(List<Long> ids) {
        Long res = prdEvaluateDtlDao.delByEvalIds(ids);
        return res;
    }


}

