package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamPointVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamPointConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamPointDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamPointDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamPointRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核点Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdPerformanceExamPointServiceImpl implements PrdPerformanceExamPointService {


    private final PrdPerformanceExamPointDao prdPerformanceExamPointDao;

    private final PrdPerformanceExamPointRepo prdPerformanceExamPointRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamPointVO save(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload) {

        checkData(prdPerformanceExamPointPayload);
        PrdPerformanceExamPointDO prdPerformanceExamPointDO = new PrdPerformanceExamPointDO();
        prdPerformanceExamPointDO = PrdPerformanceExamPointConvert.INSTANCE.p2d(prdPerformanceExamPointPayload);
        PrdPerformanceExamPointDO res = prdPerformanceExamPointRepo.save(prdPerformanceExamPointDO);
        return PrdPerformanceExamPointConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamPointVO update(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload) {

        Assert.notNull(prdPerformanceExamPointPayload.getId(), "id is null");
        PrdPerformanceExamPointVO res = save(prdPerformanceExamPointPayload);
        return res;

    }


    @Override
    public PrdPerformanceExamPointVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdPerformanceExamPointVO res = prdPerformanceExamPointDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdPerformanceExamPointVO> page(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {

        PagingVO<PrdPerformanceExamPointVO> res = prdPerformanceExamPointDao.page(prdPerformanceExamPointQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdPerformanceExamPointDao.del(ids);
        return res;

    }

    @Override
    public List<PrdPerformanceExamPointVO> getList(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {

        List<PrdPerformanceExamPointVO> res = prdPerformanceExamPointDao.getList(prdPerformanceExamPointQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdPerformanceExamPointPayload
     */
    private void checkData(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload) {

        if (null == prdPerformanceExamPointPayload.getWeightRatio()) {
            throw new BusinessException("权重不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload) {
        Assert.notNull(prdPerformanceExamPointPayload.getId(), "id不能为空");
        Long res = prdPerformanceExamPointDao.update(prdPerformanceExamPointPayload);
        return res;
    }

    @Override
    @Transactional
    public Long delByExamId(Long id) {

        Long res = prdPerformanceExamPointDao.delByExamId(id);
        return res;
    }


}

