package com.elitesland.tw.tw5.server.prd.humanresources.recommended.callback;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdInternalRecommVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

@Slf4j
@RestController
@RequestMapping(path = {
        WorkflowConstant.WORKFLOW + "INTERIOR_RECO" + WorkflowConstant.CALLBACK
})
@Transactional
@RequiredArgsConstructor
public class PrdInternalRecommWrokflowCallBackController implements WorkflowCallBack {

    private final PrdInternalRecommService service;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        Long businessKey;
        try {
            businessKey = Long.valueOf(payload.getBusinessKey());
        }catch (Exception e) {
            throw TwException.error("", "业务key格式有误，请检查");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PrdInternalRecommPayload prdInternalRecommPayload = new PrdInternalRecommPayload();
        prdInternalRecommPayload.setId(businessKey);
        //根据业务key查询当前业务对象
        PrdInternalRecommVO prdInternalRecommVO = service.queryByKey(businessKey);
        if (prdInternalRecommVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT -> {//创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    prdInternalRecommPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    prdInternalRecommPayload.setRecommStatus(1);
                }
                case INTERRUPT -> {//中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    prdInternalRecommPayload.setRecommStatus(1);
                    prdInternalRecommPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                }
                case INVALID -> {
                    prdInternalRecommPayload.setRecommStatus(1);
                    prdInternalRecommPayload.setProcInstStatus(ProcInstStatus.INVALID);
                }
                case REJECTED -> {
                    prdInternalRecommPayload.setRecommStatus(6);
                    prdInternalRecommPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                }
                case APPROVED -> {
                    prdInternalRecommPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdInternalRecommPayload.setApprovedTime(LocalDateTime.now());
                    prdInternalRecommPayload.setRecommStatus(3);
                }
                case APPROVING -> {
                    prdInternalRecommPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    prdInternalRecommPayload.setRecommStatus(2);
                }
            }
            service.updateByKeyDynamic(prdInternalRecommPayload);
        }
        return WorkflowResult.success(null);
    }
}
