package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgCompanyNoticeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyNoticeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyNoticeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgCompanyNoticeDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgCompanyNoticeRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdOrgCompanyNoticeDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgCompanyNoticeRepo repo;

    private final QPrdOrgCompanyNoticeDO qdo = QPrdOrgCompanyNoticeDO.prdOrgCompanyNoticeDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdOrgCompanyNoticeDO save(PrdOrgCompanyNoticeDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param ados 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdOrgCompanyNoticeDO> saveAll(List<PrdOrgCompanyNoticeDO> ados) {
        return repo.saveAll(ados);
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdOrgCompanyNoticeVO queryByKey(Long id) {
        JPAQuery<PrdOrgCompanyNoticeVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<PrdOrgCompanyNoticeDO> queryByKeys(List<Long> ids, Integer publishFlag) {
        JPAQuery<PrdOrgCompanyNoticeDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.id.in(ids)).where(qdo.publishFlag.eq(publishFlag));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgCompanyNoticeVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgCompanyNoticeVO.class,
                qdo.id,
                qdo.noticeTitle,
                qdo.noticeAuthorUserId,
                qdo.sort,
                qdo.changeTime,
                qdo.readAmount,
                qdo.topFlag,
                qdo.noticeContent,
                qdo.noticeAbstract,
                qdo.noticeType,
                qdo.sourceId,
                qdo.triggerTimeExpression,
                qdo.fileCodes,
                qdo.publishFlag,
                qdo.createUserId,
                qdo.remark,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.modifyTime,
                qdo.updater
        )).from(qdo);
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdOrgCompanyNoticeVO> queryPaging(PrdOrgCompanyNoticeQuery query) {
        JPAQuery<PrdOrgCompanyNoticeVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdOrgCompanyNoticeVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdOrgCompanyNoticeVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgCompanyNoticeVO> getJpaQueryWhere(PrdOrgCompanyNoticeQuery query) {
        JPAQuery<PrdOrgCompanyNoticeVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getNoticeTitle())) {
            jpaQuery.where(qdo.noticeTitle.like(query.getNoticeTitle()));
        }
        if (!ObjectUtils.isEmpty(query.getNoticeAuthorUserId())) {
            jpaQuery.where(qdo.noticeAuthorUserId.eq(query.getNoticeAuthorUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getTopFlag())) {
            jpaQuery.where(qdo.topFlag.eq(query.getTopFlag()));
        }
        if (!ObjectUtils.isEmpty(query.getPublishFlag())) {
            jpaQuery.where(qdo.publishFlag.eq(query.getPublishFlag()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdo.createUserId.eq(query.getCreateUserId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdOrgCompanyNoticeVO> queryListDynamic(PrdOrgCompanyNoticeQuery query) {
        JPAQuery<PrdOrgCompanyNoticeVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 更新发布状态
     *
     * @param ids
     * @param publishFlag
     * @return
     */
    public long updatePublishFlagByIds(List<Long> ids, Integer publishFlag) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.publishFlag, publishFlag)
                .where(qdo.id.in(ids));
        return update.execute();
    }

}
