package com.elitesland.tw.tw5.server.prd.partner.identity.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessDistributorInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessDistributorInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessDistributorInfoVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessDistributorInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessDistributorInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessDistributorInfoRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务伙伴-经销商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessDistributorInfoDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessDistributorInfoRepo repo;
    private final QBusinessDistributorInfoDO qdo = QBusinessDistributorInfoDO.businessDistributorInfoDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDistributorInfoVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessDistributorInfoVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 业务伙伴id business_partner.id
                qdo.partnerId,
                // 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
                qdo.dealerStatus,
                // 经销商等级 udc[crm:customer_grade]
                qdo.dealerGradle,
                // 授权产品
                qdo.authProduct,
                // 销售区域
                qdo.salesArea,
                // 授权开始时间
                qdo.startTime,
                // 授权结束时间
                qdo.endTime,
                // 授权期间说明
                qdo.collaborateDescription,
                // 审核材料附件
                qdo.fileCodes1,
                // 实地考察附件
                qdo.fileCodes2,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDistributorInfoVO> getJpaQueryWhere(BusinessDistributorInfoQuery query) {
        JPAQuery<BusinessDistributorInfoVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessDistributorInfoQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessDistributorInfoQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 业务伙伴id business_partner.id 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerId())) {
            list.add(qdo.partnerId.eq(query.getPartnerId()));
        }
        /** 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS] 精确 */
        if (!ObjectUtils.isEmpty(query.getDealerStatus())) {
            list.add(qdo.dealerStatus.eq(query.getDealerStatus()));
        }
        /** 经销商等级 udc[crm:customer_grade] 精确 */
        if (!ObjectUtils.isEmpty(query.getDealerGradle())) {
            list.add(qdo.dealerGradle.eq(query.getDealerGradle()));
        }
        /** 授权产品 精确 */
        if (!ObjectUtils.isEmpty(query.getAuthProduct())) {
            list.add(qdo.authProduct.eq(query.getAuthProduct()));
        }
        /** 销售区域 精确 */
        if (!ObjectUtils.isEmpty(query.getSalesArea())) {
            list.add(qdo.salesArea.eq(query.getSalesArea()));
        }
        /** 授权开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getStartTime())) {
            list.add(qdo.startTime.eq(query.getStartTime()));
        }
        /** 授权结束时间 精确 */
        if (!ObjectUtils.isEmpty(query.getEndTime())) {
            list.add(qdo.endTime.eq(query.getEndTime()));
        }
        /** 授权期间说明 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateDescription())) {
            list.add(qdo.collaborateDescription.eq(query.getCollaborateDescription()));
        }
        /** 审核材料附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes1())) {
            list.add(qdo.fileCodes1.eq(query.getFileCodes1()));
        }
        /** 实地考察附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes2())) {
            list.add(qdo.fileCodes2.eq(query.getFileCodes2()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessDistributorInfoVO queryByKey(Long id) {
        JPAQuery<BusinessDistributorInfoVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessDistributorInfoVO> queryListDynamic(BusinessDistributorInfoQuery query) {
        JPAQuery<BusinessDistributorInfoVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessDistributorInfoVO> queryPaging(BusinessDistributorInfoQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessDistributorInfoVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessDistributorInfoVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessDistributorInfoVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessDistributorInfoDO save(BusinessDistributorInfoDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessDistributorInfoDO> saveAll(List<BusinessDistributorInfoDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessDistributorInfoPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 业务伙伴id business_partner.id
        if (payload.getPartnerId() != null) {
            update.set(qdo.partnerId, payload.getPartnerId());
        }
        // 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
        if (payload.getDealerStatus() != null) {
            update.set(qdo.dealerStatus, payload.getDealerStatus());
        }
        // 经销商等级 udc[crm:customer_grade]
        if (payload.getDealerGradle() != null) {
            update.set(qdo.dealerGradle, payload.getDealerGradle());
        }
        // 授权产品
        if (payload.getAuthProduct() != null) {
            update.set(qdo.authProduct, payload.getAuthProduct());
        }
        // 销售区域
        if (payload.getSalesArea() != null) {
            update.set(qdo.salesArea, payload.getSalesArea());
        }
        // 授权开始时间
        if (payload.getStartTime() != null) {
            update.set(qdo.startTime, payload.getStartTime());
        }
        // 授权结束时间
        if (payload.getEndTime() != null) {
            update.set(qdo.endTime, payload.getEndTime());
        }
        // 授权期间说明
        if (payload.getCollaborateDescription() != null) {
            update.set(qdo.collaborateDescription, payload.getCollaborateDescription());
        }
        // 审核材料附件
        if (payload.getFileCodes1() != null) {
            update.set(qdo.fileCodes1, payload.getFileCodes1());
        }
        // 实地考察附件
        if (payload.getFileCodes2() != null) {
            update.set(qdo.fileCodes2, payload.getFileCodes2());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 业务伙伴id business_partner.id
            if (nullFields.contains("partnerId")) {
                update.setNull(qdo.partnerId);
            }
            // 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
            if (nullFields.contains("dealerStatus")) {
                update.setNull(qdo.dealerStatus);
            }
            // 经销商等级 udc[crm:customer_grade]
            if (nullFields.contains("dealerGradle")) {
                update.setNull(qdo.dealerGradle);
            }
            // 授权产品
            if (nullFields.contains("authProduct")) {
                update.setNull(qdo.authProduct);
            }
            // 销售区域
            if (nullFields.contains("salesArea")) {
                update.setNull(qdo.salesArea);
            }
            // 授权开始时间
            if (nullFields.contains("startTime")) {
                update.setNull(qdo.startTime);
            }
            // 授权结束时间
            if (nullFields.contains("endTime")) {
                update.setNull(qdo.endTime);
            }
            // 授权期间说明
            if (nullFields.contains("collaborateDescription")) {
                update.setNull(qdo.collaborateDescription);
            }
            // 审核材料附件
            if (nullFields.contains("fileCodes1")) {
                update.setNull(qdo.fileCodes1);
            }
            // 实地考察附件
            if (nullFields.contains("fileCodes2")) {
                update.setNull(qdo.fileCodes2);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

