package com.elitesland.tw.tw5.server.prd.pay.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.BkPayDetailRecordQuery;
import com.elitesland.tw.tw5.api.prd.pay.service.BkPayDetailRecordService;
import com.elitesland.tw.tw5.api.prd.pay.vo.BkPayDetailRecordVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 支付管理-付款发送记录
 *
 * @folder 支付管理-付款发送记录
 * @author wangly
 * @date 2023-12-12
 */
@Api(tags = "支付管理-付款发送记录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/bkPayDetailRecord")
@Slf4j
public class BkPayDetailRecordController {

private final BkPayDetailRecordService bkPayDetailRecordService;

    /**
     * 支付管理-付款发送记录-新增
     *
     * @folder 支付管理-付款发送记录
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("支付管理-付款发送记录-新增")
    public TwOutputUtil<BkPayDetailRecordVO> insert(@RequestBody BkPayDetailRecordPayload payload){
         return TwOutputUtil.ok(bkPayDetailRecordService.insert(payload));
    }

    /**
     * 支付管理-付款发送记录-更新
     *
         * @folder 支付管理-付款发送记录
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("支付管理-付款发送记录-更新")
    public TwOutputUtil<BkPayDetailRecordVO> update(@RequestBody BkPayDetailRecordPayload payload){
        return TwOutputUtil.ok(bkPayDetailRecordService.update(payload));
    }

    /**
     * 支付管理-付款发送记录-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 支付管理-付款发送记录
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("支付管理-付款发送记录-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BkPayDetailRecordPayload payload){
        return TwOutputUtil.ok(bkPayDetailRecordService.updateByKeyDynamic(payload));
    }

    /**
     * 支付管理-付款发送记录-主键查询
     *
     * @folder 支付管理-付款发送记录
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("支付管理-付款发送记录-主键查询")
    public TwOutputUtil<BkPayDetailRecordVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(bkPayDetailRecordService.queryByKey(key));
    }

    /**
     * 支付管理-付款发送记录-分页
     *
         * @folder 支付管理-付款发送记录
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("支付管理-付款发送记录-分页")
    public TwOutputUtil<PagingVO<BkPayDetailRecordVO>> paging(BkPayDetailRecordQuery query) {
        return TwOutputUtil.ok(bkPayDetailRecordService.queryPaging(query));
    }

    /**
     * 支付管理-付款发送记录-查询列表
     *
     * @folder 支付管理-付款发送记录
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("支付管理-付款发送记录-查询列表")
    public TwOutputUtil<List<BkPayDetailRecordVO>> queryList(BkPayDetailRecordQuery query) {
        return TwOutputUtil.ok(bkPayDetailRecordService.queryListDynamic(query));
    }

    /**
     * 支付管理-付款发送记录-删除
     *
         * @folder 支付管理-付款发送记录
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("支付管理-付款发送记录-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         bkPayDetailRecordService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

